/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.client.messages.TopResults;

final class ImmutableTopResults
implements TopResults {
    private final List<String> titles;
    private final List<List<String>> processes;

    private ImmutableTopResults(List<String> titles, List<List<String>> processes) {
        this.titles = titles;
        this.processes = processes;
    }

    @Override
    @JsonProperty(value="Titles")
    public List<String> titles() {
        return this.titles;
    }

    @Override
    @JsonProperty(value="Processes")
    public List<List<String>> processes() {
        return this.processes;
    }

    public final ImmutableTopResults withTitles(String ... elements) {
        List<String> newValue = ImmutableTopResults.createUnmodifiableList(false, ImmutableTopResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTopResults(newValue, this.processes);
    }

    public final ImmutableTopResults withTitles(Iterable<String> elements) {
        if (this.titles == elements) {
            return this;
        }
        List<String> newValue = ImmutableTopResults.createUnmodifiableList(false, ImmutableTopResults.createSafeList(elements, true, false));
        return new ImmutableTopResults(newValue, this.processes);
    }

    @SafeVarargs
    public final ImmutableTopResults withProcesses(List<String> ... elements) {
        List<List<String>> newValue = ImmutableTopResults.createUnmodifiableList(false, ImmutableTopResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTopResults(this.titles, newValue);
    }

    public final ImmutableTopResults withProcesses(Iterable<? extends List<String>> elements) {
        if (this.processes == elements) {
            return this;
        }
        List<List<String>> newValue = ImmutableTopResults.createUnmodifiableList(false, ImmutableTopResults.createSafeList(elements, true, false));
        return new ImmutableTopResults(this.titles, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTopResults && this.equalTo((ImmutableTopResults)another);
    }

    private boolean equalTo(ImmutableTopResults another) {
        return this.titles.equals(another.titles) && this.processes.equals(another.processes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.titles.hashCode();
        h += (h << 5) + this.processes.hashCode();
        return h;
    }

    public String toString() {
        return "TopResults{titles=" + this.titles + ", processes=" + this.processes + "}";
    }

    public static ImmutableTopResults copyOf(TopResults instance) {
        if (instance instanceof ImmutableTopResults) {
            return (ImmutableTopResults)instance;
        }
        return ImmutableTopResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private List<String> titles = new ArrayList<String>();
        private List<List<String>> processes = new ArrayList<List<String>>();

        private Builder() {
        }

        public final Builder from(TopResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTitles(instance.titles());
            this.addAllProcesses(instance.processes());
            return this;
        }

        public final Builder title(String element) {
            this.titles.add(Objects.requireNonNull(element, "titles element"));
            return this;
        }

        public final Builder titles(String ... elements) {
            for (String element : elements) {
                this.titles.add(Objects.requireNonNull(element, "titles element"));
            }
            return this;
        }

        @JsonProperty(value="Titles")
        public final Builder titles(Iterable<String> elements) {
            this.titles.clear();
            return this.addAllTitles(elements);
        }

        public final Builder addAllTitles(Iterable<String> elements) {
            for (String element : elements) {
                this.titles.add(Objects.requireNonNull(element, "titles element"));
            }
            return this;
        }

        public final Builder processe(List<String> element) {
            this.processes.add(Objects.requireNonNull(element, "processes element"));
            return this;
        }

        @SafeVarargs
        public final Builder processes(List<String> ... elements) {
            for (List<String> element : elements) {
                this.processes.add(Objects.requireNonNull(element, "processes element"));
            }
            return this;
        }

        @JsonProperty(value="Processes")
        public final Builder processes(Iterable<? extends List<String>> elements) {
            this.processes.clear();
            return this.addAllProcesses(elements);
        }

        public final Builder addAllProcesses(Iterable<? extends List<String>> elements) {
            for (List<String> list : elements) {
                this.processes.add(Objects.requireNonNull(list, "processes element"));
            }
            return this;
        }

        public ImmutableTopResults build() {
            return new ImmutableTopResults(ImmutableTopResults.createUnmodifiableList(true, this.titles), ImmutableTopResults.createUnmodifiableList(true, this.processes));
        }
    }
}

