/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AcceleoRefactoringUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameModuleRefactoring;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class AcceleoRenameModuleParticipant
extends RenameParticipant {
    private IFile file;
    private IProject project;
    private Module module;
    private AcceleoRenameModuleRefactoring refactoring;

    protected boolean initialize(Object element) {
        boolean result;
        block7: {
            result = false;
            if (element instanceof IFile && "mtl".equals(((IFile)element).getFileExtension()) && ((IFile)element).exists()) {
                String newName = this.getArguments().getNewName();
                if (newName.length() > 0 && newName.endsWith(".mtl") && this.getArguments().getUpdateReferences()) {
                    this.file = (IFile)element;
                    this.project = this.file.getProject();
                    this.module = AcceleoRefactoringUtils.getModuleFromFile(this.file);
                    if (this.module == null) {
                        AcceleoUIActivator.log(AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.ModuleNotCompiled", this.file.getName()), false);
                        return false;
                    }
                    try {
                        IMarker[] markers = this.file.findMarkers("org.eclipse.acceleo.ide.ui.problem", true, 2);
                        if (markers.length > 0) {
                            result = false;
                            break block7;
                        }
                        this.refactoring = new AcceleoRenameModuleRefactoring(false);
                        result = true;
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
        }
        return result;
    }

    public String getName() {
        return AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.RenameModuleParticipant");
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.refactoring.setFile(this.file);
        this.refactoring.setProject(this.project);
        this.refactoring.setModule(this.module);
        try {
            status.merge(this.refactoring.checkInitialConditions(monitor));
            String newNameWithoutExtension = this.getArguments().getNewName();
            newNameWithoutExtension = newNameWithoutExtension.substring(0, newNameWithoutExtension.lastIndexOf("."));
            this.refactoring.setNewModuleName(newNameWithoutExtension);
            status.merge(this.refactoring.checkFinalConditions(monitor));
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return status;
    }

    public Change createPreChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Change change = this.refactoring.createChange(monitor);
        this.module.eResource().unload();
        return change;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return null;
    }
}

