/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.workingsets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public abstract class AbstractWorkingSetWizardPage
extends WizardPage
implements IWorkingSetPage {
    private boolean fIsFirstValidation;
    private Text fWorkingSetName;
    private IWorkingSet fWorkingSet;

    public AbstractWorkingSetWizardPage(String pageid, String title, ImageDescriptor image) {
        super(pageid, title, image);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.AbstractWorkingSetPage_workingSet_name);
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(e -> this.validateInput());
        this.fWorkingSetName.setFocus();
        Dialog.applyDialogFont((Control)composite);
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.validateInput();
        }
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        if (this.fWorkingSet == null) {
            this.fWorkingSet = this.createWorkingSet(workingSetName);
        }
        this.fWorkingSet.setName(workingSetName);
    }

    protected abstract IWorkingSet createWorkingSet(String var1);

    private void validateInput() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.AbstractWorkingSetPage_warning_nameWhitespace;
        }
        if (newText.equals("")) {
            if (this.fIsFirstValidation) {
                this.setPageComplete(false);
                this.fIsFirstValidation = false;
                return;
            }
            errorMessage = WorkingSetMessages.AbstractWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.fIsFirstValidation = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = WorkingSetMessages.AbstractWorkingSetPage_warning_workingSetExists;
                }
                ++i;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

