/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.properties.discoverer;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.omg.kdm.code.CodeFactory;
import org.eclipse.modisco.omg.kdm.code.CompilationUnit;
import org.eclipse.modisco.omg.kdm.kdm.Attribute;
import org.eclipse.modisco.omg.kdm.kdm.KdmFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesModelDiscoverer2
extends AbstractModelDiscoverer<IFile> {
    public boolean isApplicableTo(IFile file) {
        return file.exists() && "properties".equals(file.getFileExtension());
    }

    protected void basicDiscoverElement(IFile file, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)(file.getFullPath() + ".xmi"), (boolean)true));
        Resource resource = this.discoverBuildPropertiesContent(file);
        this.setTargetModel(resource);
    }

    private Resource discoverBuildPropertiesContent(IFile buildPropertiesFile) throws DiscoveryException {
        Resource pluginPropertiesModelResource = this.createTargetModel();
        CompilationUnit kdmCompilationUnit = CodeFactory.eINSTANCE.createCompilationUnit();
        kdmCompilationUnit.setName(buildPropertiesFile.getName());
        pluginPropertiesModelResource.getContents().add((Object)kdmCompilationUnit);
        try {
            Properties properties = new Properties();
            properties.load(buildPropertiesFile.getContents());
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                String value = properties.get(key).toString();
                Attribute kdmAttribute = KdmFactory.eINSTANCE.createAttribute();
                kdmAttribute.setTag(key);
                kdmAttribute.setValue(value);
                kdmCompilationUnit.getAttribute().add((Object)kdmAttribute);
            }
        }
        catch (Exception e) {
            throw new DiscoveryException("Error discovering build.properties", (Throwable)e);
        }
        return pluginPropertiesModelResource;
    }
}

