/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.resources.refactoring.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ui.IScopeChooser;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ui.Messages;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ui.ScopeChooser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameParticipantsDialog
extends TrayDialog {
    private final IFile context;
    protected IScopeChooser currentScope;

    public RenameParticipantsDialog(Shell parentShell, IFile context) {
        super(parentShell);
        this.context = context;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RenameParticipantsDialog_SELECT_RENAME_OPTION);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        int verticalSpace = this.convertVerticalDLUsToPixels(8);
        Composite composite = new Composite(area, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label blurb = new Label(composite, 64);
        blurb.setText(Messages.RenameParticipantsDialog_DESCRIPTION);
        GridData gdata = new GridData(4, 1, false, false, 2, 1);
        gdata.widthHint = 250;
        blurb.setLayoutData((Object)gdata);
        Label scopeLabel = new Label(composite, 0);
        scopeLabel.setText("Scope:");
        gdata = new GridData(16384, 1, false, false);
        gdata.verticalIndent = verticalSpace;
        scopeLabel.setLayoutData((Object)gdata);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        comboViewer.setUseHashlookup(true);
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public String getText(Object element) {
                if (element instanceof IScopeChooser) {
                    IScopeChooser scope = (IScopeChooser)element;
                    return scope.getName();
                }
                return null;
            }
        });
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Combo combo = comboViewer.getCombo();
        gdata = new GridData(4, 4, false, false);
        gdata.verticalIndent = verticalSpace;
        combo.setLayoutData((Object)gdata);
        Group grpDescription = new Group(composite, 0);
        grpDescription.setText(Messages.RenameParticipantsDialog_DESCRIPTION_LABEL);
        grpDescription.setLayout((Layout)new GridLayout(1, false));
        grpDescription.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        final Text scopeDescription = new Text((Composite)grpDescription, 2634);
        gdata = new GridData(4, 4, false, false);
        gdata.heightHint = this.convertHeightInCharsToPixels(3);
        scopeDescription.setLayoutData((Object)gdata);
        scopeDescription.setText("");
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selec;
                if (event.getSelection() instanceof IStructuredSelection && (selec = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof IScopeChooser) {
                    IScopeChooser chooser = (IScopeChooser)selec.getFirstElement();
                    scopeDescription.setText(chooser.getDescription());
                    RenameParticipantsDialog.this.currentScope = chooser;
                }
            }
        });
        Object[] input = this.getInput();
        comboViewer.setInput((Object)input);
        comboViewer.setSelection((ISelection)new StructuredSelection(input[0]));
        this.setHelpAvailable(false);
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    private Object[] getInput() {
        final ScopeChooser.ScopeChooserVisitor visitor = new ScopeChooser.ScopeChooserVisitor();
        return new IScopeChooser[]{new ScopeChooser(Messages.RenameParticipantsDialog_NAME_PROJECT, Messages.RenameParticipantsDialog_DESCRIPTION_PROJECT){

            @Override
            public List<IFile> getRelatedFiles(IFile f) {
                try {
                    f.getProject().accept((IResourceVisitor)visitor, 2, 4);
                    return visitor.getFiles();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
        }, new ScopeChooser(Messages.RenameParticipantsDialog_NAME_WORKSPACE, Messages.RenameParticipantsDialog_DESCRIPTION_WORKSPACE){

            @Override
            public List<IFile> getRelatedFiles(IFile f) {
                try {
                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)visitor, 2, 4);
                    return visitor.getFiles();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
        }, new ScopeChooser(Messages.RenameParticipantsDialog_NAME_NO_ANALYSIS, Messages.RenameParticipantsDialog_DESCRIPTION_NO_ANALYSIS){

            @Override
            public List<IFile> getRelatedFiles(IFile f) {
                return Arrays.asList(f);
            }
        }};
    }

    public Collection<? extends IResource> getFiles() {
        return this.currentScope.getRelatedFiles(this.context);
    }
}

