/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.toolopts;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.etfw.toolopts.ExecTool;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.etfw.toolopts.IAppInput;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;
import org.eclipse.ptp.etfw.toolopts.ToolApp;
import org.eclipse.ptp.etfw.toolopts.ToolOption;
import org.eclipse.ptp.etfw.toolopts.ToolPane;
import org.eclipse.ptp.internal.etfw.toolopts.ToolArgument;
import org.eclipse.ptp.internal.etfw.toolopts.ToolMaker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ToolParser
extends DefaultHandler {
    private static final String TOOLSET = "toolset";
    boolean oldParser = false;
    private static final String TOOL = "tool";
    private static final String COMPILE = "compile";
    private static final String CC = "cc";
    private static final String CXX = "cxx";
    private static final String F90 = "f90";
    private static final String ALLCOMP = "allcompilers";
    private static final String EXECUTE = "execute";
    private static final String UTILITY = "utility";
    private static final String GLOBAL = "global";
    private static final String ANALYZE = "analyze";
    private static final String OPTIONPANE = "optionpane";
    private static final String TOGOPT = "togoption";
    private static final String LABEL = "label";
    private static final String ID = "optid";
    private static final String TIP = "tooltip";
    private static final String NAME = "optname";
    private static final String VALUE = "optvalue";
    private static final String DEFAULT = "default";
    private static final String DEFAULTNUM = "defaultnum";
    private static final String MINIMUM = "minimum";
    private static final String MAXIMUM = "maximum";
    private static final String DEFSTATE = "defstate";
    private static final String SETON = "seton";
    private static final String SETOFF = "setoff";
    private static final String FIELDREQUIRED = "fieldrequired";
    private static final String REQUIRED = "required";
    private static final String VISIBLE = "visible";
    private static final String DISPLAYOPTIONS = "displayoptions";
    private static final String ENCLOSEVALS = "enclosevalues";
    private static final String ENCLOSEWITH = "enclosewith";
    private static final String SEPARATEWITH = "separatewith";
    private static final String PREPENDWITH = "prependwith";
    private static final String SEPARATEVAL = "separatevalues";
    private static final String ARGUMENT = "argument";
    private static final String ENVVAR = "envvar";
    private static final String PARAMETRIC = "parametric";
    private static final String WEAKSCALING = "weakscaling";
    private static final String NUMPROCS = "numprocs";
    private static final String COMPILEROPT = "compileropt";
    private boolean inParametric = false;
    private boolean inTool = false;
    private boolean inCompilation = false;
    private boolean inExecution = false;
    private boolean inAnalysis = false;
    private final Stack<String> tagStack = new Stack();
    protected ArrayList<ExternalToolProcess> externalToolList = new ArrayList();
    private ExternalToolProcess currentTool;
    private BuildTool buildTool;
    private ExecTool execTool;
    private PostProcTool ppTool;
    private ArrayList<ToolPane> toolPanes;
    private ToolPane currentPane;
    private ArrayList<ToolApp> toolApps;
    private ToolApp currentApp;
    private ArrayList<IAppInput> appInput;
    private ArrayList<ToolOption> toolOptions;
    private ToolOption actOpt;
    private final Stack<StringBuffer> content = new Stack();

    public void characters(char[] chars, int start, int len) {
        this.content.peek().append(chars, start, len);
    }

    private static String getAttribute(String name, Attributes atts) {
        int repdex = atts.getIndex(name);
        if (repdex >= 0) {
            return atts.getValue(repdex);
        }
        return null;
    }

    private static int getIntAttribute(String name, int defValue, Attributes atts) {
        String str = ToolParser.getAttribute(name, atts);
        if (str == null) {
            return defValue;
        }
        int ret = Integer.parseInt(str);
        return ret;
    }

    private static boolean getBooleanAttribute(String name, boolean defValue, Attributes atts) {
        String boolAtt = ToolParser.getAttribute(name, atts);
        if (boolAtt == null) {
            return defValue;
        }
        if (boolAtt.toLowerCase().equals("true")) {
            return true;
        }
        if (boolAtt.toLowerCase().equals("false")) {
            return false;
        }
        return defValue;
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if ((name = name.toLowerCase()).equals(TOOLSET)) {
            this.oldParser = true;
            System.out.println("XML Format Not Supported");
            return;
        }
        if (name.equals(TOOL)) {
            this.inTool = true;
            this.currentTool = new ExternalToolProcess();
            this.currentTool.toolName = ToolParser.getAttribute("name", atts);
            this.currentTool.toolID = ToolParser.getAttribute("id", atts);
            this.currentTool.explicitExecution = ToolParser.getBooleanAttribute("explicitexecution", false, atts);
            if (this.currentTool.toolID == null) {
                this.currentTool.toolID = this.currentTool.toolName;
            }
        } else if (name.equals(COMPILE)) {
            if (this.inTool && this.currentTool != null) {
                this.inCompilation = true;
                this.currentTool.recompile = true;
                this.buildTool = new BuildTool();
                this.buildTool.toolID = this.currentTool.toolID;
                this.buildTool.replaceCompiler = ToolParser.getBooleanAttribute("replace", false, atts);
                this.buildTool.requireTrue = ToolParser.getAttribute("if", atts);
            }
        } else if (name.equals(EXECUTE) && !this.inExecution) {
            this.inExecution = true;
            this.execTool = new ExecTool();
            this.toolApps = new ArrayList();
            this.execTool.replaceExecution = ToolParser.getBooleanAttribute("replace_execution", false, atts);
            this.execTool.requireTrue = ToolParser.getAttribute("if", atts);
        } else if (name.equals(ANALYZE) && !this.inAnalysis) {
            this.inAnalysis = true;
            this.ppTool = new PostProcTool();
            this.toolApps = new ArrayList();
            this.ppTool.requireTrue = ToolParser.getAttribute("if", atts);
            this.ppTool.useDefaultLocation = ToolParser.getBooleanAttribute("defaultloc", false, atts);
            this.ppTool.forAllLike = ToolParser.getAttribute("foralllike", atts);
            this.ppTool.useLatestFileOnly = ToolParser.getBooleanAttribute("uselatestonly", true, atts);
            String depthS = ToolParser.getAttribute("depth", atts);
            if (depthS != null) {
                int depth;
                this.ppTool.depth = depth = Integer.parseInt(depthS);
            }
        } else if (name.equals(PARAMETRIC) && this.inTool && !this.inParametric && this.currentTool != null) {
            this.inParametric = true;
            this.currentTool.para = new ExternalToolProcess.Parametric();
            this.currentTool.para.runParametric = true;
            this.currentTool.para.weakScaling = ToolParser.getBooleanAttribute(WEAKSCALING, false, atts);
            this.currentTool.para.mpiProcs = ToolParser.getAttribute(NUMPROCS, atts);
            this.currentTool.para.compileropt = ToolParser.getAttribute(COMPILEROPT, atts);
        } else if (name.equals(CC) || name.equals(CXX) || name.equals(F90) || name.equals(ALLCOMP) || name.equals(UTILITY)) {
            if (this.inTool && this.currentTool != null) {
                this.currentApp = new ToolApp();
                this.currentApp.toolCommand = ToolParser.getAttribute("command", atts);
                this.currentApp.toolID = ToolParser.getAttribute("id", atts);
                this.currentApp.toolGroup = ToolParser.getAttribute("group", atts);
                this.currentApp.outToFile = ToolParser.getAttribute("outtofile", atts);
                if (this.currentApp.toolGroup != null && this.currentApp.toolCommand != null) {
                    this.currentTool.groupApp.put(this.currentApp.toolGroup, this.currentApp.toolCommand);
                }
                if (this.inExecution) {
                    this.currentTool.prependExecution = true;
                }
                this.currentApp.isVisualizer = ToolParser.getBooleanAttribute("visualizer", false, atts);
            }
        } else if (name.equals(GLOBAL)) {
            if (this.inTool && this.currentTool != null) {
                this.currentApp = new ToolApp();
                this.currentApp.toolID = ToolParser.getAttribute("command", atts);
            }
        } else if (name.equals(ENVVAR)) {
            if (this.inParametric) {
                this.currentTool.para.varNames.add(ToolParser.getAttribute("name", atts));
                this.currentTool.para.varValues.add(ToolParser.getAttribute("values", atts));
                String weak = "0";
                if (ToolParser.getBooleanAttribute(WEAKSCALING, false, atts)) {
                    weak = "1";
                }
                this.currentTool.para.varWeakBools.add(weak);
            } else {
                if (this.appInput == null) {
                    this.appInput = new ArrayList();
                }
                boolean local = ToolParser.getBooleanAttribute("localdir", false, atts);
                String flag = ToolParser.getAttribute("flag", atts);
                String val = ToolParser.getAttribute("value", atts);
                String sep = ToolParser.getAttribute("separator", atts);
                String cval = ToolParser.getAttribute("confvalue", atts);
                ToolArgument tArg = new ToolArgument(flag, val, sep, local);
                if (cval != null) {
                    tArg.setUseConfValue(true);
                    tArg.setConfValue(cval);
                }
                tArg.setType(ToolArgument.VAR);
                this.appInput.add(tArg);
            }
        } else if (name.equals(ARGUMENT)) {
            if (this.inParametric) {
                this.currentTool.para.argNames.add(ToolParser.getAttribute("name", atts));
                this.currentTool.para.argValues.add(ToolParser.getAttribute("values", atts));
                String weak = "0";
                if (ToolParser.getBooleanAttribute(WEAKSCALING, false, atts)) {
                    weak = "1";
                }
                this.currentTool.para.argWeakBools.add(weak);
            } else {
                if (this.appInput == null) {
                    this.appInput = new ArrayList();
                }
                boolean local = ToolParser.getBooleanAttribute("localdir", false, atts);
                String flag = ToolParser.getAttribute("flag", atts);
                String val = ToolParser.getAttribute("value", atts);
                String sep = ToolParser.getAttribute("separator", atts);
                String cval = ToolParser.getAttribute("confvalue", atts);
                boolean needsVal = ToolParser.getBooleanAttribute(FIELDREQUIRED, false, atts);
                ToolArgument tArg = new ToolArgument(flag, val, sep, local);
                if (cval != null) {
                    tArg.setUseConfValue(true);
                    tArg.setConfValue(cval);
                }
                tArg.setRequireValue(needsVal);
                this.appInput.add(tArg);
            }
        } else if (name.equals(OPTIONPANE)) {
            boolean virtual = ToolParser.getBooleanAttribute("virtual", false, atts);
            boolean embedded = ToolParser.getBooleanAttribute("embedded", false, atts);
            this.toolOptions = new ArrayList();
            this.currentPane = new ToolPane(virtual);
            this.currentPane.setName(ToolParser.getAttribute("title", atts));
            this.currentPane.toolName = this.currentTool.toolName;
            this.currentPane.embedded = embedded;
            int optdex = atts.getIndex(PREPENDWITH);
            if (optdex >= 0) {
                this.currentPane.prependOpts = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(ENCLOSEWITH)) >= 0) {
                this.currentPane.encloseOpts = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(SEPARATEWITH)) >= 0) {
                this.currentPane.separateOpts = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(ENCLOSEVALS)) >= 0) {
                this.currentPane.encloseValues = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(SEPARATEVAL)) >= 0) {
                this.currentPane.separateNameValue = atts.getValue(optdex);
            }
            if ((optdex = atts.getIndex(DISPLAYOPTIONS)) >= 0) {
                String abool = atts.getValue(optdex);
                if ((abool = abool.toLowerCase()).equals("false")) {
                    this.currentPane.displayOptions = false;
                }
            }
        } else if (name.equals(TOGOPT)) {
            this.actOpt = new ToolOption();
            this.actOpt.isArgument = !ToolParser.getBooleanAttribute(ENVVAR, false, atts);
            this.actOpt.optLabel = ToolParser.getAttribute(LABEL, atts);
            this.actOpt.optName = ToolParser.getAttribute(NAME, atts);
            this.actOpt.optID = ToolParser.getAttribute(ID, atts);
            if (this.actOpt.optID == null) {
                this.actOpt.optID = this.actOpt.optName;
            }
            this.actOpt.toolTip = ToolParser.getAttribute(TIP, atts);
            this.actOpt.defState = ToolParser.getBooleanAttribute(DEFSTATE, false, atts);
            this.actOpt.required = ToolParser.getBooleanAttribute(REQUIRED, false, atts);
            this.actOpt.visible = ToolParser.getBooleanAttribute(VISIBLE, true, atts);
        } else if (name.equals(VALUE) && this.actOpt != null && this.tagStack.peek().equals(TOGOPT)) {
            this.actOpt.defText = ToolParser.getAttribute(DEFAULT, atts);
            this.actOpt.defNum = ToolParser.getIntAttribute(DEFAULTNUM, 0, atts);
            this.actOpt.minNum = ToolParser.getIntAttribute(MINIMUM, 0, atts);
            this.actOpt.maxNum = ToolParser.getIntAttribute(MAXIMUM, Integer.MAX_VALUE, atts);
            String type = ToolParser.getAttribute("type", atts);
            this.actOpt.valueToolTip = ToolParser.getAttribute("TIP", atts);
            if (type != null) {
                if ((type = type.toLowerCase()).equals("text")) {
                    this.actOpt.type = 1;
                } else if (type.equals("dir")) {
                    this.actOpt.type = 2;
                } else if (type.equals("file")) {
                    this.actOpt.type = 3;
                    this.actOpt.fileLike = ToolParser.getAttribute("filelike", atts);
                } else if (type.equals("number")) {
                    this.actOpt.type = 5;
                } else if (type.equals("combo")) {
                    this.actOpt.type = 4;
                    String items = ToolParser.getAttribute("items", atts);
                    if (items != null) {
                        this.actOpt.items = ToolParser.parseItems(items);
                    }
                } else if (type.equals("toggle")) {
                    this.actOpt.type = 7;
                    String hold = ToolParser.getAttribute(SETON, atts);
                    if (hold == null) {
                        hold = "1";
                    }
                    this.actOpt.setOn = hold;
                    this.actOpt.setOff = ToolParser.getAttribute(SETOFF, atts);
                }
                this.actOpt.fieldrequired = ToolParser.getBooleanAttribute(FIELDREQUIRED, false, atts);
            }
        }
        this.tagStack.push(name.toLowerCase());
        this.content.push(new StringBuffer());
    }

    private static String[] parseItems(String in) {
        return in.split(":::");
    }

    private ToolApp finishApp() {
        if (this.appInput != null && this.appInput.size() > 0) {
            this.currentApp.allInput = new IAppInput[this.appInput.size()];
            this.appInput.toArray(this.currentApp.allInput);
        }
        if (this.toolPanes != null && this.toolPanes.size() > 0) {
            this.currentApp.toolPanes = new ToolPane[this.toolPanes.size()];
            this.toolPanes.toArray(this.currentApp.toolPanes);
        }
        if (this.currentApp.toolID == null) {
            this.currentApp.toolID = this.currentTool.toolID;
        }
        this.toolPanes = null;
        this.appInput = null;
        return this.currentApp;
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        name = name.toLowerCase();
        if (this.oldParser) {
            System.out.println("XML Format not supported");
            return;
        }
        if (name.equals(TOOL)) {
            this.inTool = false;
            this.externalToolList.add(this.currentTool);
        } else if (name.equals(CC) && this.inCompilation) {
            if (this.currentTool != null && this.buildTool != null) {
                this.buildTool.setCcCompiler(this.finishApp());
            }
        } else if (name.equals(CXX) && this.inCompilation) {
            if (this.currentTool != null && this.buildTool != null) {
                this.buildTool.setCxxCompiler(this.finishApp());
            }
        } else if (name.equals(F90) && this.inCompilation) {
            if (this.currentTool != null && this.buildTool != null) {
                this.buildTool.setF90Compiler(this.finishApp());
            }
        } else if (name.equals(PARAMETRIC)) {
            this.inParametric = false;
        } else if (name.equals(ALLCOMP) && this.inCompilation) {
            if (this.currentTool != null && this.buildTool != null) {
                this.buildTool.setAllCompilers(this.finishApp());
            }
        } else if (name.equals(COMPILE)) {
            if (this.currentTool != null && this.buildTool != null) {
                this.currentTool.externalTools.add(this.buildTool);
            }
            this.inCompilation = false;
        } else if (name.equals(EXECUTE) && this.inExecution) {
            this.execTool.execUtils = new ToolApp[this.toolApps.size()];
            this.toolApps.toArray(this.execTool.execUtils);
            this.currentTool.externalTools.add(this.execTool);
            this.inExecution = false;
        } else if (name.equals(UTILITY)) {
            this.toolApps.add(this.finishApp());
            this.currentApp = null;
        } else if (name.equals(ANALYZE) && this.inAnalysis) {
            this.ppTool.analysisCommands = new ToolApp[this.toolApps.size()];
            this.toolApps.toArray(this.ppTool.analysisCommands);
            this.currentTool.externalTools.add(this.ppTool);
            this.inAnalysis = false;
        } else if (name.equals(OPTIONPANE)) {
            if (this.toolOptions != null) {
                if (this.toolPanes == null) {
                    this.toolPanes = new ArrayList();
                }
                if (this.appInput == null) {
                    this.appInput = new ArrayList();
                }
                this.currentPane.setOptions(this.toolOptions);
                this.toolPanes.add(this.currentPane);
                this.appInput.add(this.currentPane);
            }
        } else if (name.equals(TOGOPT)) {
            if (this.actOpt != null) {
                String panename = "";
                if (this.currentPane != null && this.currentPane.configID != null) {
                    panename = this.currentPane.configID;
                }
                this.actOpt = ToolMaker.finishToolOption(this.actOpt, panename);
                if (this.actOpt != null) {
                    this.toolOptions.add(this.actOpt);
                }
            }
        } else if (name.equals(GLOBAL)) {
            ToolApp gApp = this.finishApp();
            if (this.inCompilation && this.buildTool != null) {
                this.buildTool.global = gApp;
            } else if (this.inExecution && this.execTool != null) {
                this.execTool.global = gApp;
            } else if (this.inAnalysis && this.ppTool != null) {
                this.ppTool.global = gApp;
            }
            this.currentApp = null;
        }
        this.tagStack.pop();
        this.content.pop();
    }
}

