/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.core.resources.IResource;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IControlFlowGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraphNode
implements ICallGraphNode {
    protected IResource resource_;
    protected String fileName_;
    protected String funcName_;
    protected IASTFunctionDefinition fdef_;
    protected List<ICallGraphNode> callers_;
    protected List<ICallGraphNode> callees_;
    protected boolean nested;
    protected IControlFlowGraph CFG_;
    protected ICallGraphNode botNext_;
    protected ICallGraphNode topNext_;
    protected Hashtable<String, Object> attrs_;
    protected boolean recursive;

    public CallGraphNode(IResource resource, String filename, String funcname, IASTFunctionDefinition fdef) {
        this.resource_ = resource;
        this.fileName_ = filename;
        this.funcName_ = funcname;
        this.fdef_ = fdef;
        this.init();
    }

    public CallGraphNode(IResource resource, String filename, IASTFunctionDefinition fdef) {
        this.resource_ = resource;
        this.fileName_ = filename;
        this.fdef_ = fdef;
        this.funcName_ = this.getFuncName(fdef);
        this.init();
    }

    private void init() {
        this.callers_ = new ArrayList<ICallGraphNode>();
        this.callees_ = new ArrayList<ICallGraphNode>();
        this.nested = false;
        this.CFG_ = null;
        this.topNext_ = null;
        this.botNext_ = null;
        this.attrs_ = new Hashtable();
        this.recursive = false;
    }

    private String getFuncName(IASTFunctionDefinition fdef) {
        IASTFunctionDeclarator fdecl = fdef.getDeclarator();
        return new String(fdecl.getName().toCharArray());
    }

    @Override
    public String getFuncName() {
        return this.funcName_;
    }

    @Override
    public String getFileName() {
        return this.fileName_;
    }

    @Override
    public IResource getResource() {
        return this.resource_;
    }

    @Override
    public IASTFunctionDefinition getFuncDef() {
        return this.fdef_;
    }

    public boolean isNested() {
        return this.nested;
    }

    @Override
    public List<ICallGraphNode> getCallers() {
        return this.callers_;
    }

    @Override
    public void addCaller(ICallGraphNode caller) {
        if (!this.callers_.contains(caller)) {
            this.callers_.add(caller);
        }
    }

    @Override
    public List<ICallGraphNode> getCallees() {
        return this.callees_;
    }

    @Override
    public void addCallee(ICallGraphNode callee) {
        if (!this.callees_.contains(callee)) {
            this.callees_.add(callee);
        }
    }

    @Override
    public ICallGraphNode botNext() {
        return this.botNext_;
    }

    @Override
    public void setBotNext(ICallGraphNode node) {
        this.botNext_ = node;
    }

    @Override
    public IControlFlowGraph getCFG() {
        return this.CFG_;
    }

    @Override
    public ICallGraphNode topNext() {
        return this.topNext_;
    }

    @Override
    public void setTopNext(ICallGraphNode node) {
        this.topNext_ = node;
    }

    @Override
    public void setCFG(IControlFlowGraph cfg) {
        this.CFG_ = cfg;
    }

    @Override
    public void setAttr(String name, Object attr) {
        this.attrs_.put(name, attr);
    }

    @Override
    public Object getAttr(String name) {
        return this.attrs_.get(name);
    }

    @Override
    public void removeAttr(String name) {
        this.attrs_.remove(name);
    }

    @Override
    public void setRecursive(boolean val) {
        this.recursive = val;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }
}

