/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree;

import org.eclipse.reddeer.common.matcher.AndMatcher;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.TreeItemHandler;
import org.eclipse.reddeer.core.lookup.TreeItemLookup;
import org.eclipse.reddeer.core.matcher.TreeItemTextMatcher;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class XMLDesignPage {
    public XMLDesignPageNode getNode(String ... path) {
        TreeItem item = TreeItemLookup.getInstance().getTreeItem((Tree)new DefaultTree().getSWTWidget(), 0, this.createNodeMatchers(path));
        return new XMLDesignPageNode(item);
    }

    public XMLDesignPageNode getNode(XMLDesignPageNode node, String ... path) {
        TreeItem item = TreeItemLookup.getInstance().getTreeItem(node.item, 0, this.createNodeMatchers(path));
        return new XMLDesignPageNode(item);
    }

    public String getAttributeValue(XMLDesignPageNode node, String name) {
        TreeItem item = TreeItemLookup.getInstance().getTreeItem(node.item, 0, new Matcher[]{this.createAttributeMatcher(name)});
        return TreeItemHandler.getInstance().getText(item, 1);
    }

    public String getContent(XMLDesignPageNode node) {
        return node.getTreeItemText(1);
    }

    private Matcher<TreeItem>[] createNodeMatchers(String[] treeItemPath) {
        Matcher[] matchers = new Matcher[treeItemPath.length];
        int i = 0;
        while (i < treeItemPath.length) {
            matchers[i] = new AndMatcher(new Matcher[]{new NodeMatcher(), new TreeItemTextMatcher(treeItemPath[i])});
            ++i;
        }
        return matchers;
    }

    private Matcher<TreeItem> createAttributeMatcher(String name) {
        return new AndMatcher(new Matcher[]{new AttributeMatcher(), new TreeItemTextMatcher(name)});
    }

    private static class AttributeMatcher
    extends TypeSafeMatcher<TreeItem> {
        private AttributeMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("represents XML attribute");
        }

        protected boolean matchesSafely(final TreeItem item) {
            String dataClassName = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

                public String run() {
                    return item.getData().getClass().getSimpleName();
                }
            });
            return dataClassName.equals("AttrImpl");
        }
    }

    private static class NodeMatcher
    extends TypeSafeMatcher<TreeItem> {
        private NodeMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("represents XML node");
        }

        protected boolean matchesSafely(final TreeItem item) {
            String dataClassName = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

                public String run() {
                    return item.getData().getClass().getSimpleName();
                }
            });
            return dataClassName.equals("ElementImpl");
        }
    }

    public static class XMLDesignPageNode {
        private TreeItem item;

        public XMLDesignPageNode(TreeItem item) {
            this.item = item;
        }

        public String getName() {
            return this.getTreeItemText(0);
        }

        private String getTreeItemText(int cellIndex) {
            return TreeItemHandler.getInstance().getText(this.item, cellIndex);
        }
    }
}

