/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.lookup;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.gef.GEFLayerException;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditor;
import org.eclipse.ui.IEditorPart;

public class ViewerLookup {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static ViewerLookup instance;

    private ViewerLookup() {
    }

    public static ViewerLookup getInstance() {
        if (instance == null) {
            instance = new ViewerLookup();
        }
        return instance;
    }

    public GraphicalViewer findGraphicalViewer() {
        return this.findGraphicalViewer(new ActiveEditor().getIEditorPart());
    }

    public GraphicalViewer findGraphicalViewer(final IEditorPart editorPart) {
        GraphicalViewer viewer = (GraphicalViewer)Display.syncExec((ResultRunnable)new ResultRunnable<GraphicalViewer>(){

            public GraphicalViewer run() {
                return (GraphicalViewer)editorPart.getAdapter(GraphicalViewer.class);
            }
        });
        if (viewer == null) {
            throw new GEFLayerException("Cannot find graphical viewer in a given editor part");
        }
        return viewer;
    }

    private class ActiveEditor
    extends DefaultEditor {
        public IEditorPart getIEditorPart() {
            return this.getEditorPart();
        }
    }
}

