/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.internal;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;

public class SourceProvider
extends AbstractSourceProvider
implements IEventListener {
    public static final String defaultContextSelectionName = "defaultContextSelection";
    private static final String RE_EVAL = "org.eclipse.ui.internal.services.EvaluationService.evaluate";
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"defaultContextSelection"};
    private IEvaluationService service = null;
    private IPeerNode defaultContext;
    private IPeerNode prevContext;
    private volatile boolean changePending;

    public void initialize(IServiceLocator locator) {
        super.initialize(locator);
        this.defaultContext = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
        EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class);
        if (locator.hasService(IEvaluationService.class)) {
            this.service = (IEvaluationService)locator.getService(IEvaluationService.class);
            if (this.service != null) {
                this.service.addSourceProvider((ISourceProvider)this);
            }
        }
    }

    public void dispose() {
        EventManager.getInstance().removeEventListener((IEventListener)this);
        if (this.service != null) {
            this.service.removeSourceProvider((ISourceProvider)this);
            this.service = null;
        }
    }

    public String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    public Map getCurrentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put(defaultContextSelectionName, this.defaultContext != null ? this.defaultContext : IEvaluationContext.UNDEFINED_VARIABLE);
        return state;
    }

    public void eventFired(EventObject event) {
        ChangeEvent changeEvent;
        if (event instanceof ChangeEvent && ((changeEvent = (ChangeEvent)event).getSource() instanceof IDefaultContextService || changeEvent.getSource() == this.defaultContext)) {
            this.defaultContext = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            if (this.changePending || !PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            this.changePending = true;
            final Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){
                private boolean scheduled;

                @Override
                public void run() {
                    if (SourceProvider.this.service == null) {
                        return;
                    }
                    if (!this.scheduled) {
                        this.scheduled = true;
                        display.timerExec(100, (Runnable)this);
                        return;
                    }
                    IPeerNode newContext = SourceProvider.this.defaultContext;
                    SourceProvider.this.changePending = false;
                    if (newContext == SourceProvider.this.prevContext) {
                        SourceProvider.this.service.getCurrentState().addVariable(SourceProvider.RE_EVAL, new Object());
                    } else {
                        SourceProvider.this.fireSourceChanged(0, SourceProvider.defaultContextSelectionName, newContext != null ? newContext : IEvaluationContext.UNDEFINED_VARIABLE);
                    }
                    SourceProvider.this.prevContext = newContext;
                }
            });
        }
    }
}

