/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.utils;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.IRootProcessor;
import org.eclipse.wb.internal.core.xml.model.IWrapperInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAdd;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectMove;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectResolveTag;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.xml.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.core.xml.model.utils.ElementTarget;
import org.eclipse.wb.internal.core.xml.model.utils.TagResolverProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlObjectUtils {
    private static final String KEY_PARAMETER_PREFIX = "Instance-level parameter: ";

    public static boolean isImplicit(XmlObjectInfo object) {
        return object.getCreationSupport() instanceof IImplicitCreationSupport;
    }

    public static void setParameter(XmlObjectInfo object, String name, String value) {
        String key = KEY_PARAMETER_PREFIX + name;
        object.putArbitraryValue(key, value);
    }

    public static String getParameter(XmlObjectInfo object, String name) {
        String key = KEY_PARAMETER_PREFIX + name;
        String value = (String)object.getArbitraryValue(key);
        if (value != null) {
            return value;
        }
        return object.getDescription().getParameter(name);
    }

    public static boolean hasTrueParameter(XmlObjectInfo object, String name) {
        String parameter = XmlObjectUtils.getParameter(object, name);
        return "true".equals(parameter);
    }

    public static Map<String, String> getParameters(XmlObjectInfo object) {
        HashMap parameters = Maps.newHashMap();
        parameters.putAll(XmlObjectUtils.extractArbitraryParameters(object));
        parameters.putAll(object.getDescription().getParameters());
        return parameters;
    }

    private static Map<String, String> extractArbitraryParameters(XmlObjectInfo object) {
        HashMap parameters = Maps.newHashMap();
        for (Map.Entry arbitrary : object.getArbitraries().entrySet()) {
            String stringKey;
            Object key = arbitrary.getKey();
            Object value = arbitrary.getValue();
            if (!(key instanceof String) || !(value instanceof String) || !(stringKey = (String)key).startsWith(KEY_PARAMETER_PREFIX)) continue;
            parameters.put(stringKey.substring(KEY_PARAMETER_PREFIX.length()), (String)value);
        }
        return parameters;
    }

    public static Object executeScriptParameter(XmlObjectInfo model, String scriptName) throws Exception {
        String script = XmlObjectUtils.getParameter(model, scriptName);
        if (script == null) {
            return null;
        }
        return XmlObjectUtils.executeScript(model, script);
    }

    public static Object executeScript(XmlObjectInfo model, String script) throws Exception {
        ClassLoader classLoader = model.getContext().getClassLoader();
        HashMap variables = Maps.newHashMap();
        variables.put("model", model);
        variables.put("object", model.getObject());
        return ScriptUtils.evaluate((ClassLoader)classLoader, (String)script, (Map)variables);
    }

    public static void callRootProcessors(XmlObjectInfo root) throws Exception {
        List processors = ExternalFactoriesHelper.getElementsInstances(IRootProcessor.class, (String)"org.eclipse.wb.core.xml.rootProcessors", (String)"processor");
        for (IRootProcessor processor : processors) {
            processor.process(root);
        }
    }

    public static XmlObjectInfo getWrapped(XmlObjectInfo original) throws Exception {
        if (original instanceof IWrapperInfo) {
            IWrapperInfo wrapperInfo = (IWrapperInfo)((Object)original);
            return wrapperInfo.getWrapped();
        }
        return original;
    }

    public static XmlObjectInfo createObject(EditorContext context, String componentClassName, CreationSupport creationSupport) throws Exception {
        Class<?> componentClass = context.getClassLoader().loadClass(componentClassName);
        return XmlObjectUtils.createObject(context, componentClass, creationSupport);
    }

    public static XmlObjectInfo createObject(EditorContext context, Class<?> componentClass, CreationSupport creationSupport) throws Exception {
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription(context, componentClass);
        return XmlObjectUtils.createObject(context, componentDescription, creationSupport);
    }

    public static XmlObjectInfo createObject(EditorContext context, ComponentDescription componentDescription, CreationSupport creationSupport) throws Exception {
        Class<?> modelClass = componentDescription.getModelClass();
        Constructor<?> modelConstructor = modelClass.getConstructor(EditorContext.class, ComponentDescription.class, CreationSupport.class);
        return (XmlObjectInfo)((Object)modelConstructor.newInstance(context, componentDescription, creationSupport));
    }

    public static void addFirst(XmlObjectInfo component, Association association, XmlObjectInfo container) throws Exception {
        container.addChildFirst(component);
        ElementTarget target = new ElementTarget(container.getCreationSupport().getElement(), 0);
        association.add(component, target);
    }

    public static void add(XmlObjectInfo component, Association association, XmlObjectInfo container, XmlObjectInfo nextComponent) throws Exception {
        ((XmlObjectAdd)container.getBroadcast(XmlObjectAdd.class)).before(container, component);
        container.addChild(component, nextComponent);
        ElementTarget target = XmlObjectUtils.getTarget(container, nextComponent);
        association.add(component, target);
        ((XmlObjectAdd)container.getBroadcast(XmlObjectAdd.class)).after(container, component);
    }

    public static void move(XmlObjectInfo component, Association association, XmlObjectInfo container, XmlObjectInfo nextComponent) throws Exception {
        XmlObjectInfo oldParent = component.getParentXML();
        ((XmlObjectMove)container.getBroadcast(XmlObjectMove.class)).before(component, oldParent, container);
        if (oldParent == container) {
            container.moveChild(component, nextComponent);
        } else {
            component.getParent().removeChild((ObjectInfo)component);
            container.addChild(component, nextComponent);
        }
        if (association != null) {
            ElementTarget target = XmlObjectUtils.getTarget(container, nextComponent);
            association.move(component, target, oldParent, container);
        } else {
            Assert.isTrue((oldParent == container ? 1 : 0) != 0, (String)"Without association only reorder is possible");
            DocumentElement containerElement = container.getElement();
            DocumentElement componentElement = XmlObjectUtils.getElementInParent(container, component.getElement());
            int targetIndex = XmlObjectUtils.getTargetIndex(containerElement, nextComponent);
            containerElement.moveChild(componentElement, targetIndex);
        }
        ((XmlObjectMove)container.getBroadcast(XmlObjectMove.class)).after(component, oldParent, container);
    }

    private static ElementTarget getTarget(XmlObjectInfo container, XmlObjectInfo nextComponent) {
        DocumentElement containerElement = container.getCreationSupport().getElement();
        int index = XmlObjectUtils.getTargetIndex(containerElement, nextComponent);
        return new ElementTarget(containerElement, index);
    }

    private static int getTargetIndex(DocumentElement containerElement, XmlObjectInfo component) {
        List children = containerElement.getChildren();
        if (component == null) {
            return children.size();
        }
        DocumentElement componentElement = component.getCreationSupport().getElement();
        componentElement = containerElement.getDirectChild(componentElement);
        return children.indexOf(componentElement);
    }

    public static DocumentElement getElementInParent(XmlObjectInfo parent, DocumentElement element) {
        DocumentElement parentElement = parent.getCreationSupport().getElement();
        return parentElement.getDirectChild(element);
    }

    public static void registerTagResolvers(XmlObjectInfo rootObject) throws Exception {
        List providers = ExternalFactoriesHelper.getElementsInstances(TagResolverProvider.class, (String)"org.eclipse.wb.core.xml.tagResolverProviders", (String)"provider");
        for (TagResolverProvider provider : providers) {
            provider.register(rootObject);
        }
    }

    public static String getTagForClass(XmlObjectInfo object, Class<?> clazz) throws Exception {
        String[] namespaceArray = new String[1];
        String[] tagArray = new String[1];
        ((XmlObjectResolveTag)object.getBroadcast(XmlObjectResolveTag.class)).invoke(object, clazz, namespaceArray, tagArray);
        String namespace = namespaceArray[0];
        String tag = tagArray[0];
        Assert.isTrue2((namespace != null && tag != null ? 1 : 0) != 0, (String)"Can not resolve tag for {0}", (Object[])new Object[]{clazz});
        if (StringUtils.isEmpty((String)namespace)) {
            return tag;
        }
        return String.valueOf(namespace) + ":" + tag;
    }

    public static void flowContainerCreate(XmlObjectInfo container, XmlObjectInfo component, XmlObjectInfo nextComponent) throws Exception {
        List<FlowContainer> flowContainers = new FlowContainerFactory(container, false).get();
        for (FlowContainer flowContainer : flowContainers) {
            if (!flowContainer.validateComponent((Object)component)) continue;
            flowContainer.command_CREATE((Object)component, (Object)nextComponent);
            ExecutionUtils.refresh((ObjectInfo)container);
            break;
        }
    }

    public static void flowContainerMove(XmlObjectInfo container, XmlObjectInfo component, XmlObjectInfo nextComponent) throws Exception {
        List<FlowContainer> flowContainers = new FlowContainerFactory(container, false).get();
        for (FlowContainer flowContainer : flowContainers) {
            if (!flowContainer.validateComponent((Object)component)) continue;
            flowContainer.command_MOVE((Object)component, (Object)nextComponent);
            ExecutionUtils.refresh((ObjectInfo)container);
            break;
        }
    }
}

