/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsoluteBasedLayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsoluteLayoutSelectionEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.AbstractAlignmentActionsSupport;
import org.eclipse.wb.internal.core.gef.policy.snapping.IAbsoluteLayoutCommands;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swt.gef.policy.layout.AbsoluteBasedLayoutEditPolicySWT;
import org.eclipse.wb.internal.swt.model.layout.absolute.IAbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.SelectionActionsSupport;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbsoluteLayoutEditPolicy<C extends IControlInfo>
extends AbsoluteBasedLayoutEditPolicySWT<C> {
    private final IAbsoluteLayoutInfo<C> m_layout;

    public AbsoluteLayoutEditPolicy(IAbsoluteLayoutInfo<C> layout) {
        super(layout);
        this.m_layout = layout;
        this.createPlacementsSupport(IAbsoluteLayoutCommands.EMPTY);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        final List editParts = request.getEditParts();
        return new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                ArrayList models = Lists.newArrayList();
                for (EditPart editPart : editParts) {
                    models.add((IControlInfo)editPart.getModel());
                }
                AbsoluteLayoutEditPolicy.this.placementsSupport.commit();
                for (IControlInfo widget : models) {
                    Rectangle bounds = widget.getModelBounds();
                    AbsoluteLayoutEditPolicy.this.m_layout.commandChangeBounds(widget, bounds.getLocation(), null);
                }
            }
        };
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        final List editParts = request.getEditParts();
        return new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                ArrayList models = Lists.newArrayList();
                for (EditPart editPart : editParts) {
                    models.add((IControlInfo)editPart.getModel());
                }
                AbsoluteLayoutEditPolicy.this.placementsSupport.commitAdd();
                for (IControlInfo widget : models) {
                    Rectangle bounds = widget.getModelBounds();
                    AbsoluteLayoutEditPolicy.this.m_layout.commandMove(widget, null);
                    AbsoluteLayoutEditPolicy.this.m_layout.commandChangeBounds(widget, bounds.getLocation(), widget.getModelBounds().getSize());
                }
            }
        };
    }

    protected Command getCreateCommand(CreateRequest request) {
        final IControlInfo control = (IControlInfo)request.getNewObject();
        return new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                AbsoluteLayoutEditPolicy.this.placementsSupport.commitAdd();
                Rectangle bounds = control.getModelBounds();
                AbsoluteLayoutEditPolicy.this.m_layout.commandCreate(control, null);
                AbsoluteLayoutEditPolicy.this.m_layout.commandChangeBounds(control, bounds.getLocation(), bounds.getSize());
            }
        };
    }

    protected void doPasteComponent(Point pasteLocation, AbsoluteBasedLayoutEditPolicy.PastedComponentInfo pastedWidget) throws Exception {
        IControlInfo control = (IControlInfo)pastedWidget.getComponent();
        this.m_layout.commandCreate(control, null);
        Point relativeLocation = pastedWidget.getBounds().getLocation();
        this.m_layout.commandChangeBounds(control, pasteLocation.getTranslated(relativeLocation), pastedWidget.getBounds().getSize());
    }

    protected Command getResizeCommand(final ChangeBoundsRequest request) {
        return new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                for (EditPart editPart : request.getEditParts()) {
                    IControlInfo widget = (IControlInfo)editPart.getModel();
                    Rectangle bounds = widget.getModelBounds();
                    AbsoluteLayoutEditPolicy.this.m_layout.commandChangeBounds(widget, bounds.getLocation(), bounds.getSize());
                }
            }
        };
    }

    protected void decorateChild(EditPart child) {
        if (this.m_layout.getControls().contains(child.getModel())) {
            child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new AbsoluteLayoutSelectionEditPolicy());
        }
    }

    protected AbstractAlignmentActionsSupport<C> getAlignmentActionsSupport() {
        return new SelectionActionsSupport<C>(this.m_layout);
    }

    protected ToolkitDescription getToolkit() {
        return GlobalState.getToolkit();
    }
}

