/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.ModelMessages;

public final class AcceleratorPropertyEditor
extends TextDialogPropertyEditor {
    public static final PropertyEditor INSTANCE = new AcceleratorPropertyEditor();
    private static List<String> m_keyFields;
    private static Map<Integer, String> m_keyCodeToName;
    private static Map<String, Integer> m_keyNameToCode;

    private AcceleratorPropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof Integer) {
            return AcceleratorPropertyEditor.getText((Integer)value);
        }
        return null;
    }

    protected void openDialog(Property property) throws Exception {
        KeyStrokeDialog dialog = new KeyStrokeDialog(property.getTitle());
        Object value = property.getValue();
        if (value instanceof Integer) {
            int keyStroke = (Integer)value;
            dialog.setKeyStroke(keyStroke);
        }
        if (dialog.open() == 0) {
            GenericProperty genericProperty = (GenericProperty)property;
            int accelerator = dialog.getAccelerator();
            String source = AcceleratorPropertyEditor.getSource(accelerator);
            genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
        }
    }

    private static String getText(int accelerator) {
        KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator);
        return keyStroke.toString();
    }

    private static String getSource(int accelerator) {
        String source = AcceleratorPropertyEditor.getText(accelerator);
        source = StringUtils.replace((String)source, (String)"ALT+", (String)"org.eclipse.swt.SWT.ALT | ");
        source = StringUtils.replace((String)source, (String)"CTRL+", (String)"org.eclipse.swt.SWT.CTRL | ");
        source = StringUtils.replace((String)source, (String)"SHIFT+", (String)"org.eclipse.swt.SWT.SHIFT | ");
        int length = source.length();
        int index = StringUtils.lastIndexOf((String)source, (char)' ');
        source = index == length - 2 ? String.valueOf(source.substring(0, index)) + " '" + source.substring(index + 1) + "'" : (index > 0 ? String.valueOf(source.substring(0, index)) + " org.eclipse.swt.SWT." + source.substring(index + 1) : "org.eclipse.swt.SWT." + source);
        return source;
    }

    private static String getKeyName(int accelerator) {
        AcceleratorPropertyEditor.prepareKeyMaps();
        int keyCode = SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator).getNaturalKey();
        return m_keyCodeToName.get(keyCode);
    }

    private static int getKeyCode(String keyName) {
        AcceleratorPropertyEditor.prepareKeyMaps();
        return m_keyNameToCode.get(keyName);
    }

    private static void prepareKeyMaps() {
        if (m_keyCodeToName == null) {
            m_keyFields = Lists.newArrayList();
            m_keyCodeToName = Maps.newTreeMap();
            m_keyNameToCode = Maps.newTreeMap();
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    char charValue;
                    Field[] fieldArray = SWT.class.getFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        String fieldName = field.getName();
                        int fieldValue = field.getInt(null);
                        if (AcceleratorPropertyEditor.hasBits(fieldValue, 0x1000000)) {
                            m_keyFields.add(fieldName);
                            m_keyCodeToName.put(fieldValue, fieldName);
                            m_keyNameToCode.put(fieldName, fieldValue);
                        }
                        ++n2;
                    }
                    char c = '0';
                    while (c < '9') {
                        String charName = Character.toString(c);
                        charValue = c;
                        m_keyFields.add(charName);
                        m_keyCodeToName.put(Integer.valueOf(charValue), charName);
                        m_keyNameToCode.put(charName, Integer.valueOf(charValue));
                        c = (char)(c + '\u0001');
                    }
                    c = 'A';
                    while (c < 'Z') {
                        String charName = Character.toString(c);
                        charValue = c;
                        m_keyFields.add(charName);
                        m_keyCodeToName.put(Integer.valueOf(charValue), charName);
                        m_keyNameToCode.put(charName, Integer.valueOf(charValue));
                        c = (char)(c + '\u0001');
                    }
                }
            });
        }
    }

    private static boolean hasBits(int value, int bits) {
        return (value & bits) == bits;
    }

    private static final class KeyStrokeDialog
    extends ResizableDialog {
        private final String m_title;
        private int m_accelerator;
        private Text m_keyStrokeText;
        private org.eclipse.swt.widgets.List m_keyCodeList;
        private final Map<Integer, Button> m_modifierToButton = Maps.newHashMap();

        public KeyStrokeDialog(String title) {
            super(DesignerPlugin.getShell(), (AbstractUIPlugin)Activator.getDefault());
            this.m_title = title;
            this.setShellStyle(67696);
        }

        public void setKeyStroke(int keyStroke) {
            this.m_accelerator = keyStroke;
        }

        public int getAccelerator() {
            return this.m_accelerator;
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            GridDataFactory.create((Control)area).grab().fill();
            GridLayoutFactory.create((Composite)area);
            Label label = new Label(area, 0);
            label.setText(ModelMessages.AcceleratorPropertyEditor_combinationLabel);
            this.m_keyStrokeText = new Text(area, 2056);
            GridDataFactory.create((Control)this.m_keyStrokeText).grabH().fillH();
            this.m_keyStrokeText.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    KeyStrokeDialog.this.m_accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
                    KeyStrokeDialog.this.displayAccelerator();
                }
            });
            Group propertiesGroup = new Group(area, 0);
            GridDataFactory.create((Control)propertiesGroup).grab().fill();
            GridLayoutFactory.create((Composite)propertiesGroup);
            propertiesGroup.setText(ModelMessages.AcceleratorPropertyEditor_keyStrokeLabel);
            Group modifiersGroup = new Group((Composite)propertiesGroup, 0);
            GridDataFactory.create((Control)modifiersGroup).grabH().fillH();
            GridLayoutFactory.create((Composite)modifiersGroup).columns(5);
            modifiersGroup.setText(ModelMessages.AcceleratorPropertyEditor_modifiers);
            this.addModifierButton((Composite)modifiersGroup, 65536, "&Alt");
            this.addModifierButton((Composite)modifiersGroup, 262144, "&Ctrl");
            this.addModifierButton((Composite)modifiersGroup, 131072, "&Shift");
            this.addModifierButton((Composite)modifiersGroup, 0x400000, "&Command");
            Group keyGroup = new Group((Composite)propertiesGroup, 0);
            GridDataFactory.create((Control)keyGroup).grab().fill();
            GridLayoutFactory.create((Composite)keyGroup);
            keyGroup.setText(ModelMessages.AcceleratorPropertyEditor_keyCode);
            this.m_keyCodeList = new org.eclipse.swt.widgets.List((Composite)keyGroup, 2560);
            GridDataFactory.create((Control)this.m_keyCodeList).hintC(50, 15).grab().fill();
            AcceleratorPropertyEditor.prepareKeyMaps();
            for (String name : m_keyFields) {
                this.m_keyCodeList.add(name);
            }
            this.m_keyCodeList.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    String name = KeyStrokeDialog.this.m_keyCodeList.getSelection()[0];
                    int keyCode = AcceleratorPropertyEditor.getKeyCode(name);
                    int modifiers = KeyStrokeDialog.this.m_accelerator & SWT.MODIFIER_MASK;
                    KeyStrokeDialog.this.m_accelerator = modifiers | keyCode;
                    KeyStrokeDialog.this.displayAccelerator();
                }
            });
            this.displayAccelerator();
            return area;
        }

        private void addModifierButton(Composite parent, final int modifier, String title) {
            final Button button = new Button(parent, 32);
            button.setText(title);
            this.m_modifierToButton.put(modifier, button);
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (button.getSelection()) {
                        KeyStrokeDialog keyStrokeDialog = KeyStrokeDialog.this;
                        keyStrokeDialog.m_accelerator = keyStrokeDialog.m_accelerator | modifier;
                    } else {
                        KeyStrokeDialog keyStrokeDialog = KeyStrokeDialog.this;
                        keyStrokeDialog.m_accelerator = keyStrokeDialog.m_accelerator & ~modifier;
                    }
                    KeyStrokeDialog.this.displayAccelerator();
                }
            });
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.m_title);
        }

        private void displayAccelerator() {
            this.m_keyStrokeText.setText(AcceleratorPropertyEditor.getText(this.m_accelerator));
            for (Map.Entry<Integer, Button> entry : this.m_modifierToButton.entrySet()) {
                int modifier = entry.getKey();
                Button button = entry.getValue();
                if ((this.m_accelerator & modifier) != 0) {
                    button.setSelection(true);
                    continue;
                }
                button.setSelection(false);
            }
            this.m_keyCodeList.setSelection(new String[]{AcceleratorPropertyEditor.getKeyName(this.m_accelerator)});
        }
    }
}

