/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.yaml;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class YAMLLanguageServer
extends ProcessStreamConnectionProvider {
    private static final String YAML_KEY = "yaml";
    private static final String VALIDATE_KEY = "validate";
    private static final String COMPLETION_KEY = "completion";
    private static final String HOVER_KEY = "hover";
    private static final String SCHEMAS_KEY = "schemas";
    private static final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private static final LanguageServersRegistry.LanguageServerDefinition yamlLsDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.yaml");
    private static final IPropertyChangeListener psListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("wildwebdeveloper.yaml.schema".equals(event.getProperty())) {
                HashMap<String, Map> settings = new HashMap<String, Map>();
                settings.put(YAMLLanguageServer.YAML_KEY, YAMLLanguageServer.getYamlConfigurationOptions());
                DidChangeConfigurationParams params = new DidChangeConfigurationParams(settings);
                LanguageServiceAccessor.getActiveLanguageServers(null).stream().filter(server -> yamlLsDefinition.equals(LanguageServiceAccessor.resolveServerDefinition((LanguageServer)server).get())).forEach(ls -> ls.getWorkspaceService().didChangeConfiguration(params));
            }
        }
    };

    public YAMLLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/yaml-language-server/out/server/src/server.js"));
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        ResponseMessage responseMessage;
        if (message instanceof ResponseMessage && (responseMessage = (ResponseMessage)message).getResult() instanceof InitializeResult) {
            HashMap<String, Map<String, Object>> settings = new HashMap<String, Map<String, Object>>();
            settings.put(YAML_KEY, YAMLLanguageServer.getYamlConfigurationOptions());
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(settings);
            languageServer.getWorkspaceService().didChangeConfiguration(params);
        }
    }

    private static Map<String, Object> getYamlConfigurationOptions() {
        HashMap<String, Object> yaml = new HashMap<String, Object>();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String schemaStr = preferenceStore.getString("wildwebdeveloper.yaml.schema");
        Map schemas = (Map)new Gson().fromJson(schemaStr, new TypeToken<HashMap<String, Object>>(){}.getType());
        yaml.put(SCHEMAS_KEY, schemas);
        yaml.put(VALIDATE_KEY, true);
        yaml.put(COMPLETION_KEY, true);
        yaml.put(HOVER_KEY, true);
        return yaml;
    }

    public String toString() {
        return "YAML Language Server: " + super.toString();
    }

    public void start() throws IOException {
        super.start();
        store.addPropertyChangeListener(psListener);
    }

    public void stop() {
        store.removePropertyChangeListener(psListener);
        super.stop();
    }
}

