"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.pluginModuleFactory = void 0;
const path_1 = __importDefault(require("path"));
const language_service_proxy_builder_1 = require("./language-service-proxy-builder");
const eslint_adapter_1 = require("./eslint-adapter");
const ast_converter_1 = require("./ast-converter");
const eslint_config_provider_1 = require("./eslint-config-provider");
const consts_1 = require("./consts");
function create(info) {
    if (!!process.env["TS_ESLINT_SERVICE_DISABLED"])
        return info.languageService;
    const { languageService, serverHost, project, config: pluginConfigObj } = info;
    const projectDir = path_1.default.dirname(project.getProjectName());
    const logger = (msg) => project.projectService.logger.info(`[typescript-eslint-language-service] ${msg}`);
    logger("config: " + JSON.stringify(pluginConfigObj));
    let watchDirs;
    if (Array.isArray(pluginConfigObj.watchDirs)) {
        watchDirs = pluginConfigObj.watchDirs
            .filter(x => typeof x === "string")
            .map(x => path_1.default.resolve(projectDir, x));
    }
    else {
        watchDirs = [projectDir];
    }
    const getProgram = () => {
        const program = languageService.getProgram();
        if (!program) {
            throw new Error();
        }
        return program;
    };
    const converter = new ast_converter_1.AstConverter({
        getProgram,
    });
    const configProvider = new eslint_config_provider_1.ESLintConfigProvider({
        directoriesToWatch: watchDirs,
        host: serverHost,
    });
    const adapter = new eslint_adapter_1.ESLintAdapter({
        logger,
        converter,
        configProvider,
        getSourceFile(fileName) {
            return getProgram().getSourceFile(fileName);
        },
    });
    const proxy = new language_service_proxy_builder_1.LanguageServiceProxyBuilder(info)
        .wrap("getSemanticDiagnostics", delegate => adapter.getSemanticDiagnostics.bind(adapter, delegate))
        .wrap("getCodeFixesAtPosition", delegate => adapter.getCodeFixesAtPosition.bind(adapter, delegate))
        .build();
    return proxy;
}
exports.pluginModuleFactory = ({ typescript }) => {
    // NOTE
    // Now ts.LanguageService does not exported method to get supported fixable codes.
    // So I monkey-patche to override ts.getSupportedCodeFixes til https://github.com/microsoft/TypeScript/pull/29010 is merged.
    const delegate = typescript.getSupportedCodeFixes;
    typescript.getSupportedCodeFixes = () => [...delegate(), `${consts_1.TS_LANGSERVICE_ESLINT_DIAGNOSTIC_ERROR_CODE}`];
    return { create };
};
//# sourceMappingURL=plugin-module-factory.js.map