/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.cmake.core.internal.IOsOverridesSelector;
import org.eclipse.cdt.cmake.core.properties.CMakeGenerator;
import org.eclipse.cdt.cmake.core.properties.ICMakeProperties;
import org.eclipse.cdt.cmake.core.properties.IOsOverrides;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

class CommandDescriptorBuilder {
    private final ICMakeProperties cmakeProperties;
    private final IOsOverridesSelector overridesSelector;

    CommandDescriptorBuilder(ICMakeProperties cmakeProperties, IOsOverridesSelector overridesSelector) {
        this.cmakeProperties = Objects.requireNonNull(cmakeProperties);
        this.overridesSelector = Objects.requireNonNull(overridesSelector);
    }

    CommandDescriptor makeCMakeCommandline(Path toolChainFile) throws CoreException {
        String file;
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> env = new ArrayList<String>();
        args.add("cmake");
        if (this.cmakeProperties.isWarnNoDev()) {
            args.add("-Wno-dev");
        }
        if (this.cmakeProperties.isDebugTryCompile()) {
            args.add("--debug-trycompile");
        }
        if (this.cmakeProperties.isDebugOutput()) {
            args.add("--debug-output");
        }
        if (this.cmakeProperties.isTrace()) {
            args.add("--trace");
        }
        if (this.cmakeProperties.isWarnUnitialized()) {
            args.add("--warn-unitialized");
        }
        if (this.cmakeProperties.isWarnUnused()) {
            args.add("--warn-unused");
        }
        if ((file = this.cmakeProperties.getCacheFile()) != null && !file.isBlank()) {
            args.add("-C");
            args.add(file);
        }
        CommandDescriptorBuilder.appendCMakeArguments(args, this.cmakeProperties.getExtraArguments());
        CommandDescriptorBuilder.appendCMakeOsOverrideArgs(args, this.overridesSelector.getOsOverrides(this.cmakeProperties));
        String bt = this.cmakeProperties.getBuildType();
        if (bt != null && !bt.isBlank()) {
            args.add("-DCMAKE_BUILD_TYPE=" + bt);
        }
        args.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
        if (toolChainFile != null) {
            args.add("-DCMAKE_TOOLCHAIN_FILE=" + toolChainFile.toString());
        }
        return new CommandDescriptor(args, env);
    }

    CommandDescriptor makeCMakeBuildCommandline(String buildscriptTarget) throws CoreException {
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> env = new ArrayList<String>();
        IOsOverrides osOverrides = this.overridesSelector.getOsOverrides(this.cmakeProperties);
        if (osOverrides.getUseDefaultCommand()) {
            args.add("cmake");
        } else {
            IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
            String cmd = varManager.performStringSubstitution(osOverrides.getCommand());
            args.add(cmd);
        }
        args.add("--build");
        args.add(".");
        args.add("--target");
        args.add(buildscriptTarget);
        return new CommandDescriptor(args, env);
    }

    private static void appendCMakeArguments(List<String> argList, List<String> moreArgs) throws CoreException {
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        for (String arg : moreArgs) {
            String expanded = mgr.performStringSubstitution(arg);
            argList.add(expanded);
        }
    }

    private static void appendCMakeOsOverrideArgs(List<String> args, IOsOverrides prefs) throws CoreException {
        if (!prefs.getUseDefaultCommand()) {
            IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
            String cmd = varManager.performStringSubstitution(prefs.getCommand());
            args.set(0, cmd);
        }
        args.add("-G");
        CMakeGenerator generator = prefs.getGenerator();
        args.add(generator.getCMakeName());
        CommandDescriptorBuilder.appendCMakeArguments(args, prefs.getExtraArguments());
    }

    static final class CommandDescriptor {
        private final List<String> arguments;
        private final List<String> environment;

        CommandDescriptor(List<String> arguments, List<String> environment) {
            this.arguments = Objects.requireNonNull(arguments);
            this.environment = Objects.requireNonNull(environment);
        }

        public List<String> getArguments() {
            return this.arguments;
        }

        public List<String> getEnvironment() {
            return this.environment;
        }
    }
}

