/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.search.mixin.model;

public class TclNamespaceImport {
    private static final String NAMESPACE_PREFIX = "@";
    private String namespace = null;
    private String importNsName = null;

    public TclNamespaceImport(String namespace, String pattern) {
        this.namespace = namespace;
        this.importNsName = pattern;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getImportNsName() {
        return this.importNsName;
    }

    public static String makeKey(String namespace, String pattern) {
        if (namespace.startsWith("::")) {
            namespace = namespace.substring(2);
        }
        if (pattern != null) {
            return NAMESPACE_PREFIX + namespace + "|" + pattern;
        }
        return null;
    }

    public static String processPattern(String pattern) {
        int pos;
        if (pattern.startsWith("::")) {
            pattern = pattern.substring(2);
        }
        if ((pos = pattern.lastIndexOf("::")) == -1) {
            return pattern;
        }
        pattern = pattern.substring(0, pos);
        return pattern;
    }

    public static TclNamespaceImport parseKey(String key) {
        if (!key.startsWith(NAMESPACE_PREFIX)) {
            return null;
        }
        key = key.substring(1);
        int pos = key.indexOf("|");
        return new TclNamespaceImport(key.substring(0, pos), key.substring(pos + 1));
    }
}

