/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.parser.compiler.AbstractAcceleoCompiler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.eef.EEFGen.EEFGenPackage;
import org.eclipse.emf.eef.components.ComponentsPackage;
import org.eclipse.emf.eef.mapping.MappingPackage;
import org.eclipse.emf.eef.mapping.filters.FiltersPackage;
import org.eclipse.emf.eef.mapping.navigation.NavigationPackage;
import org.eclipse.emf.eef.toolkits.ToolkitsPackage;
import org.eclipse.emf.eef.views.ViewsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEFCodegenCompiler
extends AbstractAcceleoCompiler {
    public static void main(String[] args) {
        if (args.length < 3) {
            throw new IllegalArgumentException("Missing parameters");
        }
        EEFCodegenCompiler acceleoCompiler = new EEFCodegenCompiler();
        acceleoCompiler.setSourceFolder(args[0]);
        acceleoCompiler.setOutputFolder(args[1]);
        acceleoCompiler.setBinaryResource(Boolean.valueOf(args[2]));
        if (args.length == 4 && args[3] != null && !"".equals(args[3])) {
            acceleoCompiler.setDependencies(args[3]);
        }
        acceleoCompiler.doCompile((Monitor)new BasicMonitor());
    }

    public void doCompile(Monitor monitor) {
        super.doCompile(monitor);
    }

    protected void registerPackages() {
        super.registerPackages();
        EPackage.Registry.INSTANCE.put((Object)ComponentsPackage.eINSTANCE.getNsURI(), (Object)ComponentsPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)MappingPackage.eINSTANCE.getNsURI(), (Object)MappingPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)NavigationPackage.eINSTANCE.getNsURI(), (Object)NavigationPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)FiltersPackage.eINSTANCE.getNsURI(), (Object)FiltersPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)ViewsPackage.eINSTANCE.getNsURI(), (Object)ViewsPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)ToolkitsPackage.eINSTANCE.getNsURI(), (Object)ToolkitsPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)EEFGenPackage.eINSTANCE.getNsURI(), (Object)EEFGenPackage.eINSTANCE);
    }

    protected void registerResourceFactories() {
        super.registerResourceFactories();
    }

    protected void computeDependencies(List<URI> dependenciesURIs, Map<URI, URI> mapURIs) {
        Iterator identifiersIt = this.dependenciesIDs.iterator();
        Iterator dependenciesIt = this.dependencies.iterator();
        while (dependenciesIt.hasNext() && identifiersIt.hasNext()) {
            File requiredFolder = (File)dependenciesIt.next();
            String identifier = (String)identifiersIt.next();
            if (requiredFolder == null || !requiredFolder.exists() || !requiredFolder.isDirectory()) continue;
            ArrayList emtlFiles = new ArrayList();
            this.members(emtlFiles, requiredFolder, "emtl");
            for (File emtlFile : emtlFiles) {
                String requiredFolderAbsolutePath = requiredFolder.getAbsolutePath();
                if (requiredFolderAbsolutePath.endsWith("target/classes")) {
                    String[] splited = requiredFolderAbsolutePath.split("\\/");
                    StringBuffer buf = new StringBuffer(requiredFolderAbsolutePath.length());
                    int i = 0;
                    while (i < splited.length - 3) {
                        buf.append(splited[i]);
                        buf.append("/");
                        ++i;
                    }
                    requiredFolderAbsolutePath = buf.toString();
                    String emtlAbsolutePath = emtlFile.getAbsolutePath();
                    URI emtlFileURI = URI.createFileURI((String)emtlAbsolutePath);
                    dependenciesURIs.add(emtlFileURI);
                    String emtlModifiedPath = emtlAbsolutePath.replaceAll("target\\/|classes\\/", "");
                    Path relativePath = new Path(emtlModifiedPath.substring(requiredFolderAbsolutePath.length()));
                    URI relativeURI = URI.createPlatformPluginURI((String)relativePath.toString(), (boolean)false);
                    mapURIs.put(emtlFileURI, relativeURI);
                    continue;
                }
                String emtlAbsolutePath = emtlFile.getAbsolutePath();
                URI emtlFileURI = URI.createFileURI((String)emtlAbsolutePath);
                dependenciesURIs.add(emtlFileURI);
                IPath relativePath = new Path(identifier).append(emtlAbsolutePath.substring(requiredFolderAbsolutePath.length()));
                mapURIs.put(emtlFileURI, URI.createPlatformPluginURI((String)relativePath.toString(), (boolean)false));
            }
        }
    }
}

