/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import java.lang.reflect.Method;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.command.ClosureCommand;
import org.eclipse.jpt.common.utility.internal.command.CommandRunnable;
import org.eclipse.jpt.common.utility.internal.command.CommandWrapper;
import org.eclipse.jpt.common.utility.internal.command.CompositeCommand;
import org.eclipse.jpt.common.utility.internal.command.DisabledCommand;
import org.eclipse.jpt.common.utility.internal.command.FactoryCommand;
import org.eclipse.jpt.common.utility.internal.command.NullCommand;
import org.eclipse.jpt.common.utility.internal.command.RepeatingCommand;
import org.eclipse.jpt.common.utility.internal.command.RunnableCommand;
import org.eclipse.jpt.common.utility.internal.command.SafeCommandWrapper;
import org.eclipse.jpt.common.utility.internal.command.StaticMethodCommand;
import org.eclipse.jpt.common.utility.internal.command.ThreadLocalCommand;
import org.eclipse.jpt.common.utility.internal.command.TransformerCommand;
import org.eclipse.jpt.common.utility.internal.exception.DefaultExceptionHandler;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class CommandTools {
    public static Command adapt(Runnable runnable) {
        return new RunnableCommand(runnable);
    }

    public static Runnable runnable(Command command) {
        return new CommandRunnable(command);
    }

    public static Command adapt(Closure<?> closure) {
        return new ClosureCommand(closure);
    }

    public static Command adapt(Factory<?> factory) {
        return new FactoryCommand(factory);
    }

    public static Command adapt(Transformer<?, ?> transformer) {
        return new TransformerCommand(transformer);
    }

    public static Command composite(Command ... commands) {
        return CommandTools.composite(ArrayTools.iterable(commands));
    }

    public static Command composite(Iterable<Command> commands) {
        return new CompositeCommand(commands);
    }

    public static ThreadLocalCommand threadLocalCommand() {
        return CommandTools.threadLocalCommand(NullCommand.instance());
    }

    public static ThreadLocalCommand threadLocalCommand(Command defaultCommand) {
        return new ThreadLocalCommand(defaultCommand);
    }

    public static CommandWrapper wrap(Command command) {
        return new CommandWrapper(command);
    }

    public static Command safe(Command command) {
        return CommandTools.safe(command, DefaultExceptionHandler.instance());
    }

    public static Command safe(Command command, ExceptionHandler exceptionHandler) {
        return new SafeCommandWrapper(command, exceptionHandler);
    }

    public static Command repeat(Command command, int count) {
        return new RepeatingCommand(command, count);
    }

    public static Command disabledCommand() {
        return DisabledCommand.instance();
    }

    public static Command nullCommand() {
        return NullCommand.instance();
    }

    public static Command execute(Class<?> clazz, String methodName) {
        return CommandTools.execute(clazz, methodName, ClassTools.EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static Command execute(Class<?> clazz, String methodName, Class<?> parameterType, Object argument) {
        return CommandTools.execute(clazz, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static Command execute(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        return CommandTools.execute(ClassTools.method(clazz, methodName, parameterTypes), arguments);
    }

    public static Command execute(Method method, Object[] arguments) {
        return new StaticMethodCommand(method, arguments);
    }

    private CommandTools() {
        throw new UnsupportedOperationException();
    }
}

