/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.query.AbstractEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.IHierarchicalEntityVisitor;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleEntityQueryVisitorImpl
extends AbstractEntityQueryVisitor
implements IHierarchicalEntityVisitor {
    private HierarchicalSearchControl control;
    private boolean _stop;
    private EntityQueryFilterVisitor entityQuery;
    private List<Entity> _entityResults;
    private Entity initialEntityContext;

    public SimpleEntityQueryVisitorImpl() {
        this.control = new HierarchicalSearchControl();
    }

    public SimpleEntityQueryVisitorImpl(HierarchicalSearchControl control) {
        this.control = control;
    }

    @Override
    public IResultSet<Entity> findEntities(Entity initialEntity, String entityKey) {
        this.resetQuery();
        if (initialEntity != null) {
            this.initialEntityContext = initialEntity;
            this.entityQuery = new EntityQueryFilterVisitor(initialEntity.getId(), entityKey);
            initialEntity.accept(this);
        }
        return new SimpleResultSet<Entity>(this.getInternalEntityResults());
    }

    private void resetQuery() {
        this._stop = false;
        this._entityResults = null;
    }

    private List<Entity> getInternalEntityResults() {
        if (this._entityResults == null) {
            this._entityResults = new ArrayList<Entity>();
        }
        return this._entityResults;
    }

    @Override
    public boolean visitEnter(Entity entity) {
        if (entity == this.initialEntityContext) {
            return true;
        }
        this.entityQuery.pushLevel();
        if (this.entityQuery.canVisit(entity)) {
            return this.entityQuery.visit(entity);
        }
        return false;
    }

    @Override
    public boolean visitLeave(Entity entity) {
        this.checkShouldStopVisitingEntities();
        if (entity != this.initialEntityContext) {
            this.entityQuery.popLevel();
        }
        return true;
    }

    @Override
    public void visit(Entity key) {
    }

    @Override
    public boolean stopVisiting() {
        return this._stop;
    }

    private void checkShouldStopVisitingEntities() {
        if (!this._stop && this.control.getCountLimit() == this.getInternalEntityResults().size() && this.control.getCountLimit() != -1) {
            this._stop = true;
        }
    }

    private class EntityQueryFilterVisitor {
        private String entityId;
        private List<String> entityQueue;
        private int curLevel = 0;

        public EntityQueryFilterVisitor(String initialContextId, String queryKey) {
            this.init(initialContextId, queryKey);
        }

        private void init(String initialContextId, String key) {
            this.entityQueue = new ArrayList<String>(3);
            this.addLevel(initialContextId);
            if (key == null || key.trim().equals("") || key.trim().equals(SimpleEntityQueryVisitorImpl.this.getLevelDelimiter())) {
                this.addLevel("");
            } else {
                StringTokenizer st = new StringTokenizer(key, SimpleEntityQueryVisitorImpl.this.getLevelDelimiter());
                String partialKey = st.nextToken();
                this.addLevel(partialKey);
                while (st.hasMoreElements()) {
                    partialKey = st.nextToken();
                    this.addLevel(partialKey);
                }
            }
        }

        public boolean canVisit(Entity entity) {
            return this.entityId.compareTo(entity.getId().toUpperCase()) == 0;
        }

        public boolean visit(Entity entity) {
            if (this.curLevel == this.entityQueue.size() - 1) {
                SimpleEntityQueryVisitorImpl.this.getInternalEntityResults().add(entity);
                return false;
            }
            return true;
        }

        private void addLevel(String key) {
            this.entityQueue.add(key.toUpperCase());
        }

        public void popLevel() {
            this.entityId = this.entityQueue.get(--this.curLevel);
        }

        public void pushLevel() {
            this.entityId = this.entityQueue.get(++this.curLevel);
        }
    }
}

