/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.resolver.structureddocument.internal.impl;

import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class StructuredDocumentResolverUtil {
    StructuredDocumentResolverUtil() {
    }

    static IDOMDocument getDOMDocument(IStructuredDocument document) {
        IStructuredModel model = StructuredDocumentResolverUtil.getStructuredModel(document);
        try {
            if (model instanceof IDOMModel) {
                IDOMDocument iDOMDocument = ((IDOMModel)model).getDocument();
                return iDOMDocument;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    static IndexedRegion getIndexedRegion(IStructuredDocument document, int documentOffset) {
        IndexedRegion region;
        block7: {
            IStructuredModel model = StructuredDocumentResolverUtil.getStructuredModel(document);
            region = null;
            if (model != null) {
                try {
                    int lastOffset = documentOffset;
                    region = model.getIndexedRegion(documentOffset);
                    while (region == null && lastOffset >= 0) {
                        region = model.getIndexedRegion(--lastOffset);
                    }
                    if (!(region instanceof IDOMElement)) break block7;
                    IDOMElement domElement = (IDOMElement)region;
                    NamedNodeMap attributes = domElement.getAttributes();
                    int i = 0;
                    while (i < attributes.getLength()) {
                        IDOMAttr attr;
                        Node attrNode = attributes.item(i);
                        if (attrNode instanceof IDOMAttr && documentOffset >= (attr = (IDOMAttr)attrNode).getStartOffset() && documentOffset < attr.getEndOffset()) {
                            region = attr;
                            break;
                        }
                        ++i;
                    }
                }
                finally {
                    model.releaseFromRead();
                }
            }
        }
        return region;
    }

    private static IStructuredModel getStructuredModel(IStructuredDocument document) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager != null) {
            return StructuredModelManager.getModelManager().getModelForRead(document);
        }
        return null;
    }
}

