/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetException;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetUninstallConfig;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtilFactory;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.jst.jsf.core.internal.project.facet.JsfFacetConfigurationUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JSFFacetUninstallDelegate
implements IDelegate {
    private final boolean jsfFacetConfigurationEnabled = JsfFacetConfigurationUtil.isJsfFacetConfigurationEnabled();

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            JSFUtils jsfUtil = new JSFUtilFactory().create(fv, ModelProviderManager.getModelProvider((IProject)project));
            if (jsfUtil == null) {
                throw new JSFFacetException(NLS.bind((String)Messages.Could_Not_GetJSFVersion, (Object)fv.toString()));
            }
            if (this.jsfFacetConfigurationEnabled) {
                IModelProvider provider = jsfUtil.getModelProvider();
                if (provider == null) {
                    throw new JSFFacetException(NLS.bind((String)Messages.JSFFacetUninstallDelegate_ConfigErr, (Object)project.getName()));
                }
                if (!provider.validateEdit(null, null).isOK()) {
                    throw new JSFFacetException(NLS.bind((String)Messages.JSFFacetUninstallDelegate_NonUpdateableWebXML, (Object)project.getName()));
                }
            }
            ((JSFFacetUninstallConfig)((Object)config)).getLibrariesUninstallDelegate().execute(null);
            if (this.jsfFacetConfigurationEnabled) {
                this.uninstallJSFReferencesFromWebApp(project, monitor, jsfUtil);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void uninstallJSFReferencesFromWebApp(IProject project, IProgressMonitor monitor, JSFUtils jsfUtil) {
        IModelProvider provider = jsfUtil.getModelProvider();
        Object webAppObj = provider.getModelObject();
        if (webAppObj != null) {
            IPath ddPath = new Path("WEB-INF").append("web.xml");
            if (this.isJavaEEWebApp(webAppObj)) {
                provider.modify((Runnable)new RemoveJSFFromJavaEEWebAppOperation(project, jsfUtil), ddPath);
            } else {
                provider.modify((Runnable)new RemoveJSFFromJ2EEWebAppOperation(project, jsfUtil), ddPath);
            }
        }
    }

    private boolean isJavaEEWebApp(Object webAppObj) {
        return webAppObj instanceof WebApp;
    }

    static class RemoveJSFFromJ2EEWebAppOperation
    implements Runnable {
        private IProject _project;
        private JSFUtils _jsfUtil;

        RemoveJSFFromJ2EEWebAppOperation(IProject project, JSFUtils jsfUtil) {
            this._project = project;
            this._jsfUtil = jsfUtil;
        }

        public void run() {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this._project).getModelObject();
            this._jsfUtil.rollbackWebApp(webApp);
        }
    }

    static class RemoveJSFFromJavaEEWebAppOperation
    implements Runnable {
        private IProject _project;
        private JSFUtils _jsfUtil;

        RemoveJSFFromJavaEEWebAppOperation(IProject project, JSFUtils jsfUtil) {
            this._project = project;
            this._jsfUtil = jsfUtil;
        }

        public void run() {
            WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this._project).getModelObject();
            this._jsfUtil.rollbackWebApp(webApp);
        }
    }
}

