/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.felix;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.felix.IFelixVersionHandler;
import org.eclipse.libra.framework.felix.Messages;
import org.eclipse.wst.server.core.IModule;

public class Felix2Handler
implements IFelixVersionHandler {
    public IStatus verifyInstallPath(IPath location) {
        File f = location.append("conf").toFile();
        if (f == null || !f.exists()) {
            return new Status(4, "org.eclipse.libra.framework.felix", 0, Messages.warningCantReadConfig, null);
        }
        File[] conf = f.listFiles();
        if (conf != null) {
            int size = conf.length;
            int i = 0;
            while (i < size) {
                if (!f.canRead()) {
                    return new Status(2, "org.eclipse.libra.framework.felix", 0, Messages.warningCantReadConfig, null);
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public String getFrameworkClass() {
        return "org.apache.felix.main.Main";
    }

    public List getFrameworkClasspath(IPath installPath, IPath configPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath binPath = installPath.append("bin");
        if (binPath.toFile().exists()) {
            IPath path = binPath.append("felix.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
        }
        return cp;
    }

    public String[] getFrameworkProgramArguments(IPath configPath, boolean debug, boolean starting) {
        return new String[]{configPath.append("cache").makeAbsolute().toPortableString()};
    }

    public String[] getExcludedFrameworkProgramArguments(boolean debug, boolean starting) {
        return null;
    }

    public String[] getFrameworkVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv, boolean jmxEnabled, int jmxPort) {
        String configPathStr = deployPath.makeAbsolute().append("config.properties").toPortableString();
        String vmArgs = "-Dfelix.config.properties=file:" + configPathStr;
        String profilePath = deployPath.append("java.profile").toOSString();
        String vmArgs2 = "";
        try {
            this.copyFile(this.getClass().getResourceAsStream("java6-server.profile"), new File(profilePath));
            vmArgs2 = String.valueOf(vmArgs2) + "-Dosgi.java.profile=file:" + profilePath;
        }
        catch (IOException e) {
            Trace.trace((byte)2, (String)("Could not set equinox VM arguments:" + e.getMessage()), (Throwable)e);
        }
        if (jmxEnabled) {
            return new String[]{"-Dcom.sun.management.jmxremote.port=" + jmxPort, "-Dcom.sun.management.jmxremote.authenticate=false", "-Dcom.sun.management.jmxremote.ssl=false", vmArgs, vmArgs2};
        }
        return new String[]{vmArgs, vmArgs2};
    }

    private void copyFile(InputStream source, File destFile) throws IOException {
        FileOutputStream destination = null;
        try {
            int c;
            destination = new FileOutputStream(destFile);
            while ((c = source.read()) != -1) {
                destination.write(c);
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public IStatus canAddModule(IModule module) {
        String id = module.getModuleType().getId();
        if ("osgi.bundle".equals(id)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.libra.framework.felix", 0, Messages.errorNotBundle, null);
    }

    public IStatus prepareFrameworkInstanceDirectory(IPath baseDir) {
        return Status.OK_STATUS;
    }

    public IStatus prepareDeployDirectory(IPath deployPath) {
        File temp;
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, (String)("Creating runtime directory at " + deployPath.toOSString()));
        }
        if (!(temp = deployPath.append("plugins").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = deployPath.append("auto").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = deployPath.append("cache").toFile()).exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }

    public boolean supportsServeModulesWithoutPublish() {
        return true;
    }

    public void prepareFrameworkConfigurationFile(IPath configPath, String workspaceBundles, String kernelBundles) {
        Properties properties = new Properties();
        properties.setProperty("felix.auto.deploy.dir", configPath.append("auto").makeAbsolute().toPortableString());
        properties.setProperty("felix.auto.deploy.action", "install,start");
        properties.setProperty("org.osgi.framework.startlevel.beginning", "2");
        properties.setProperty("felix.auto.install.1", kernelBundles);
        properties.setProperty("felix.auto.start.1", kernelBundles);
        properties.setProperty("felix.auto.install.2", workspaceBundles);
        properties.setProperty("felix.auto.start.2", workspaceBundles);
        properties.setProperty("org.osgi.framework.storage", "file:" + configPath.append("auto").makeAbsolute().toPortableString());
        properties.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
        try {
            properties.store(new FileOutputStream(configPath.append("config.properties").makeAbsolute().toFile()), "## AUTO GENERATED ##");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

