/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.docker.core.Activator;
import org.mandas.docker.client.LogReader;
import org.mandas.docker.client.LogStream;

public class HttpHijackWorkaround {
    public static WritableByteChannel getOutputStream(LogStream stream, String uri) throws Exception {
        String[] fields = new String[]{"reader", "stream", "original", "input", "in", "in", "wrappedStream", "in", "inStream"};
        String[] declared = new String[]{"org.mandas.docker.client.DefaultLogStream", LogReader.class.getName(), "org.glassfish.jersey.message.internal.ReaderInterceptorExecutor$UnCloseableInputStream", "org.glassfish.jersey.message.internal.EntityInputStream", FilterInputStream.class.getName(), FilterInputStream.class.getName(), "org.apache.http.conn.EofSensorInputStream", "org.apache.http.impl.io.IdentityInputStream", "org.apache.http.impl.io.SessionInputBufferImpl"};
        String[] bundles = new String[]{"org.glassfish.jersey.core.jersey-common", "org.apache.httpcomponents.httpcore", "org.apache.httpcomponents.httpclient"};
        LinkedList<String[]> list = new LinkedList<String[]>();
        int i = 0;
        while (i < fields.length) {
            list.add(new String[]{declared[i], fields[i]});
            ++i;
        }
        try {
            Class<?> cLogFactory = null;
            Class<?> cLog = null;
            String[] commonsLogging = new String[]{"org.apache.commons.logging"};
            cLogFactory = HttpHijackWorkaround.loadClass("org.apache.commons.logging.LogFactory", commonsLogging);
            cLog = HttpHijackWorkaround.loadClass("org.apache.commons.logging.Log", commonsLogging);
            if (cLogFactory != null && cLog != null) {
                Method mGetLog = cLogFactory.getMethod("getLog", String.class);
                Object log = mGetLog.invoke(null, "org.apache.http.wire");
                Method mIsDebug = cLog.getMethod("isDebugEnabled", new Class[0]);
                Boolean isDebug = (Boolean)mIsDebug.invoke(log, new Object[0]);
                if (isDebug.booleanValue()) {
                    list.add(new String[]{"org.apache.http.impl.conn.LoggingInputStream", "in"});
                }
            }
        }
        catch (Exception cLogFactory) {
            // empty catch block
        }
        if (uri.startsWith("unix:")) {
            list.add(new String[]{"sun.nio.ch.ChannelInputStream", "ch"});
        } else if (uri.startsWith("https:")) {
            float jvmVersion = Float.parseFloat(System.getProperty("java.specification.version"));
            String fName = jvmVersion < 1.9f ? "c" : "socket";
            list.add(new String[]{"sun.security.ssl.AppInputStream", fName});
        } else {
            list.add(new String[]{"java.net.SocketInputStream", "socket"});
        }
        Object res = HttpHijackWorkaround.getInternalField(stream, list, bundles);
        if (res instanceof WritableByteChannel) {
            return (WritableByteChannel)res;
        }
        if (res instanceof Socket) {
            return Channels.newChannel(((Socket)res).getOutputStream());
        }
        return null;
    }

    public static InputStream getInputStream(LogStream stream) {
        String[] fields = new String[]{"reader", "stream"};
        String[] declared = new String[]{"org.mandas.docker.client.DefaultLogStream", LogReader.class.getName()};
        LinkedList<String[]> list = new LinkedList<String[]>();
        int i = 0;
        while (i < fields.length) {
            list.add(new String[]{declared[i], fields[i]});
            ++i;
        }
        return (InputStream)HttpHijackWorkaround.getInternalField(stream, list, new String[0]);
    }

    private static Object getInternalField(Object input, List<String[]> set, String[] bundles) {
        Object curr = input;
        try {
            for (String[] e : set) {
                Field f = HttpHijackWorkaround.loadClass(e[0], bundles).getDeclaredField(e[1]);
                f.setAccessible(true);
                curr = f.get(curr);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
        return curr;
    }

    /*
     * Unable to fully structure code
     */
    private static Class<?> loadClass(String key, String[] bundles) {
        try {
            return Class.forName(key);
        }
        catch (ClassNotFoundException e) {
            var6_3 = bundles;
            var5_4 = bundles.length;
            var4_5 = 0;
            ** while (var4_5 < var5_4)
        }
lbl-1000:
        // 1 sources

        {
            bsName = var6_3[var4_5];
            b = Platform.getBundle((String)bsName);
            try {
                return b.loadClass(key);
            }
            catch (ClassNotFoundException var8_8) {
                ++var4_5;
            }
            continue;
        }
lbl15:
        // 1 sources

        return null;
    }
}

