/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.jetty;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;

public class JettyNameResolvers {

    @Subject(value="org.apache.jasper.servlet.JasperLoader")
    public static class JasperLoaderResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject object) throws SnapshotException {
            IObject parent = (IObject)object.resolveValue("parent");
            return parent != null ? MessageUtil.format((String)Messages.JettyNameResolvers_JSPofWebApp, (Object[])new Object[]{parent.getClassSpecificName()}) : null;
        }
    }

    @Subject(value="org.mortbay.jetty.webapp.WebAppClassLoader")
    public static class WebAppClassLoaderResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject object) throws SnapshotException {
            IObject name = (IObject)object.resolveValue("_name");
            if (name != null) {
                return name.getClassSpecificName();
            }
            IObject contextPath = (IObject)object.resolveValue("_context._contextPath");
            return contextPath != null ? contextPath.getClassSpecificName() : null;
        }
    }
}

