/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.editor.editors;

import org.eclipse.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.modisco.infra.browser.custom.editor.editors.MetaclassViewConfiguration;
import org.eclipse.modisco.infra.browser.custom.editor.editors.MetaclassViewer;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MetaclassViewToolBar {
    private final ToolBar toolBar;
    private MetaclassViewer metaclassViewer;
    private ToolItem btnShowMetaclassesFullQualifiedName;
    private ToolItem btnShowMultiplicity;
    private ToolItem btnSortLinks;
    private ToolItem btnSortLinksByType;
    private ToolItem btnShowDerivedLinks;
    private final MetaclassViewConfiguration metaclassViewConfiguration;
    private final Composite fParent;

    public MetaclassViewToolBar(Composite parent, MetaclassViewConfiguration metaclassViewConfiguration) {
        this.fParent = parent;
        this.metaclassViewConfiguration = metaclassViewConfiguration;
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        this.toolBar = new ToolBar(parent, 0);
        GridData toolBarGridData = new GridData();
        toolBarGridData.grabExcessHorizontalSpace = false;
        toolBarGridData.horizontalAlignment = 4;
        this.toolBar.setLayoutData((Object)toolBarGridData);
        this.createToolButtons();
        this.initialize();
    }

    public Composite getParentComposite() {
        return this.fParent;
    }

    public void setMetaclassViewer(MetaclassViewer metaclassViewer) {
        this.metaclassViewer = metaclassViewer;
    }

    private void createToolButtons() {
        this.createShowMetaclassesFullQualifiedNameButton();
        this.createShowMultiplicityButton();
        this.createSortLinksButton();
        this.createSortLinksByTypeButton();
        this.createShowDerivedLinksButton();
    }

    private void createShowMetaclassesFullQualifiedNameButton() {
        this.btnShowMetaclassesFullQualifiedName = new ToolItem(this.toolBar, 32);
        this.btnShowMetaclassesFullQualifiedName.setToolTipText(Messages.MetaclassViewToolBar_showFullQualifiedNames);
        this.btnShowMetaclassesFullQualifiedName.setImage(ImageProvider.getInstance().getShowFullQualifiedNamesIcon());
        this.btnShowMetaclassesFullQualifiedName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewConfiguration.setShowMetaclassesFullQualifiedNames(MetaclassViewToolBar.this.btnShowMetaclassesFullQualifiedName.getSelection());
                MetaclassViewToolBar.this.metaclassViewer.refresh();
            }
        });
    }

    private void createShowMultiplicityButton() {
        this.btnShowMultiplicity = new ToolItem(this.toolBar, 32);
        this.btnShowMultiplicity.setToolTipText(Messages.MetaclassViewToolBar_showMultiplicity);
        this.btnShowMultiplicity.setImage(ImageProvider.getInstance().getShowMultiplicityIcon());
        this.btnShowMultiplicity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewConfiguration.setShowMultiplicity(MetaclassViewToolBar.this.btnShowMultiplicity.getSelection());
                MetaclassViewToolBar.this.metaclassViewer.refresh();
            }
        });
    }

    private void createSortLinksButton() {
        this.btnSortLinks = new ToolItem(this.toolBar, 32);
        this.btnSortLinks.setToolTipText(Messages.MetaclassViewToolBar_sortLinks);
        this.btnSortLinks.setImage(ImageProvider.getInstance().getSortLinksIcon());
        this.btnSortLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MetaclassViewToolBar.this.metaclassViewConfiguration.setSortLinks(MetaclassViewToolBar.this.btnSortLinks.getSelection());
                MetaclassViewToolBar.this.metaclassViewer.refresh();
            }
        });
    }

    private void createSortLinksByTypeButton() {
        this.btnSortLinksByType = new ToolItem(this.toolBar, 32);
        this.btnSortLinksByType.setToolTipText(Messages.MetaclassViewToolBar_sortLinksByType);
        this.btnSortLinksByType.setImage(ImageProvider.getInstance().getSortLinksByTypeIcon());
        this.btnSortLinksByType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MetaclassViewToolBar.this.metaclassViewConfiguration.setSortLinksByType(MetaclassViewToolBar.this.btnSortLinksByType.getSelection());
                MetaclassViewToolBar.this.metaclassViewer.refresh();
            }
        });
    }

    private void createShowDerivedLinksButton() {
        this.btnShowDerivedLinks = new ToolItem(this.toolBar, 32);
        this.btnShowDerivedLinks.setToolTipText(Messages.MetaclassViewToolBar_showDerivedLinks);
        this.btnShowDerivedLinks.setImage(ImageProvider.getInstance().getShowDerivedLinksIcon());
        this.btnShowDerivedLinks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassViewToolBar.this.metaclassViewConfiguration.setShowDerivedLinks(MetaclassViewToolBar.this.btnShowDerivedLinks.getSelection());
                MetaclassViewToolBar.this.metaclassViewer.refresh();
            }
        });
    }

    private void initialize() {
        this.btnShowDerivedLinks.setSelection(this.metaclassViewConfiguration.isShowDerivedLinks());
        this.btnShowMetaclassesFullQualifiedName.setSelection(this.metaclassViewConfiguration.isShowMetaclassesFullQualifiedNames());
        this.btnShowMultiplicity.setSelection(this.metaclassViewConfiguration.isShowMultiplicity());
        this.btnSortLinks.setSelection(this.metaclassViewConfiguration.isSortLinks());
        this.btnSortLinksByType.setSelection(this.metaclassViewConfiguration.isSortLinksByType());
    }
}

