/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.FunctionName;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Quote;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class ConstantHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new ConstantApply();
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(true).setDefaultTextColor(0, 0, 192).setItalicByDefault(true);
    }

    public String getDisplayName() {
        return Messages.ConstantHighlighting_0;
    }

    protected class ConstantApply
    extends AbstractSemanticApply {
        boolean isInQuote = false;

        protected ConstantApply() {
        }

        public boolean visit(ConstantDeclaration constDecl) {
            List names = constDecl.names();
            for (Identifier name : names) {
                ConstantHighlighting.this.highlight((ASTNode)name);
            }
            return true;
        }

        public boolean visit(Quote quote) {
            this.isInQuote = true;
            return true;
        }

        public void endVisit(Quote quote) {
            this.isInQuote = false;
        }

        public boolean visit(Scalar scalar) {
            Identifier identifier;
            FunctionInvocation fi;
            String value = scalar.getStringValue();
            if (!((scalar.getScalarType() != 2 || this.isInQuote) && scalar.getScalarType() != 4 || "null".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || value.length() <= 0 || value.charAt(0) == '\'' || value.charAt(0) == '\"')) {
                ConstantHighlighting.this.highlight((ASTNode)scalar);
            } else if (scalar.getParent() instanceof FunctionInvocation && (fi = (FunctionInvocation)scalar.getParent()).parameters().get(0) == scalar && fi.getFunctionName().getName() instanceof Identifier && ("define".equalsIgnoreCase((identifier = (Identifier)fi.getFunctionName().getName()).getName()) || "constant".equalsIgnoreCase(identifier.getName()))) {
                ConstantHighlighting.this.highlight((ASTNode)scalar);
            }
            return true;
        }

        public boolean visit(StaticConstantAccess access) {
            if (!"class".equalsIgnoreCase(access.getConstant().getName())) {
                ConstantHighlighting.this.highlight((ASTNode)access.getConstant());
            }
            return true;
        }

        public boolean visit(NamespaceName namespace) {
            Identifier c;
            List segs;
            ASTNode parent = namespace.getParent();
            if (!(parent instanceof NamespaceDeclaration || parent instanceof StaticDispatch || parent instanceof FunctionName || parent instanceof UseStatement || (segs = namespace.segments()).size() <= 0 || PHPElementConciliator.concile((ASTNode)(c = (Identifier)segs.get(segs.size() - 1))) != 5)) {
                ConstantHighlighting.this.highlight((ASTNode)c);
            }
            return true;
        }
    }
}

