/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFGNode;

public class OMPBasicBlock
extends OMPCFGNode {
    protected LinkedList statements_ = new LinkedList();
    protected IASTName label_ = null;
    protected IASTExpression branchingExpression_ = null;
    protected int branchingType_ = -1;
    public static final int NoBranch = -1;
    public static final int IfBranch = 0;
    public static final int SwitchBranch = 1;
    public static final int WhileBranch = 2;
    public static final int DoBranch = 3;
    public static final int ForBranch = 4;
    protected LinkedList fundStmtsExprs_ = null;

    public void addStatement(IASTStatement element) {
        this.statements_.add(element);
    }

    public IASTName getLabel() {
        return this.label_;
    }

    public boolean isCase() {
        if (this.statements_.isEmpty()) {
            return false;
        }
        IASTStatement statement = (IASTStatement)this.statements_.getFirst();
        return statement instanceof IASTCaseStatement;
    }

    public void setBranchingExpression(IASTExpression branch, int type) {
        this.branchingExpression_ = branch;
        this.branchingType_ = type;
    }

    public IASTStatement[] getStatements() {
        IASTStatement[] list = new IASTStatement[this.statements_.size()];
        int count = 0;
        Iterator i = this.statements_.iterator();
        while (i.hasNext()) {
            list[count++] = (IASTStatement)i.next();
        }
        return list;
    }

    public IASTExpression getBranchingExpression() {
        return this.branchingExpression_;
    }

    public int getBranchingType() {
        return this.branchingType_;
    }

    public LinkedList getFundamentals() {
        if (this.fundStmtsExprs_ != null) {
            return this.fundStmtsExprs_;
        }
        this.fundStmtsExprs_ = new LinkedList();
        for (IASTStatement stmt : this.statements_) {
            FundVisitor fv = new FundVisitor(this.fundStmtsExprs_);
            stmt.accept((ASTVisitor)fv);
        }
        return this.fundStmtsExprs_;
    }

    protected class FundVisitor
    extends ASTVisitor {
        protected LinkedList list_ = null;

        public FundVisitor(LinkedList list) {
            this.list_ = list;
            this.shouldVisitStatements = true;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTIfStatement) {
                this.processIfStatement((IASTIfStatement)statement);
                return 1;
            }
            if (statement instanceof IASTSwitchStatement) {
                this.processSwitchStatement((IASTSwitchStatement)statement);
                return 1;
            }
            if (statement instanceof IASTCaseStatement) {
                this.processCaseStatement((IASTCaseStatement)statement);
                return 3;
            }
            if (statement instanceof IASTForStatement) {
                this.processForStatement((IASTForStatement)statement);
                return 1;
            }
            if (statement instanceof IASTWhileStatement) {
                this.processWhileStatement((IASTWhileStatement)statement);
                return 1;
            }
            if (statement instanceof IASTDoStatement) {
                this.processDoStatement((IASTDoStatement)statement);
                return 1;
            }
            if (statement instanceof IASTCompoundStatement) {
                return 3;
            }
            if (statement instanceof IASTBreakStatement) {
                this.list_.add(statement);
                return 3;
            }
            if (statement instanceof IASTContinueStatement) {
                this.list_.add(statement);
                return 3;
            }
            if (statement instanceof IASTReturnStatement) {
                this.list_.add(statement);
                return 3;
            }
            this.list_.add(statement);
            return 3;
        }

        protected void processIfStatement(IASTIfStatement statement) {
            this.list_.add(statement.getConditionExpression());
            if (statement.getThenClause() != null) {
                FundVisitor thenVisitor = new FundVisitor(this.list_);
                statement.getThenClause().accept((ASTVisitor)thenVisitor);
            }
            if (statement.getElseClause() != null) {
                FundVisitor elseVisitor = new FundVisitor(this.list_);
                statement.getElseClause().accept((ASTVisitor)elseVisitor);
            }
        }

        protected void processSwitchStatement(IASTSwitchStatement statement) {
            this.list_.add(statement.getControllerExpression());
            FundVisitor bodyVisitor = new FundVisitor(this.list_);
            statement.getBody().accept((ASTVisitor)bodyVisitor);
        }

        protected void processCaseStatement(IASTCaseStatement statement) {
            this.list_.add(statement.getExpression());
        }

        protected void processForStatement(IASTForStatement statement) {
            this.list_.add(statement.getConditionExpression());
            this.list_.add(statement.getIterationExpression());
            if (statement.getInitializerStatement() != null) {
                FundVisitor initVisitor = new FundVisitor(this.list_);
                statement.getInitializerStatement().accept((ASTVisitor)initVisitor);
            }
            if (statement.getBody() != null) {
                FundVisitor bodyVisitor = new FundVisitor(this.list_);
                statement.getBody().accept((ASTVisitor)bodyVisitor);
            }
        }

        protected void processWhileStatement(IASTWhileStatement statement) {
            this.list_.add(statement.getCondition());
            if (statement.getBody() != null) {
                FundVisitor bodyVisitor = new FundVisitor(this.list_);
                statement.getBody().accept((ASTVisitor)bodyVisitor);
            }
        }

        protected void processDoStatement(IASTDoStatement statement) {
            this.list_.add(statement.getCondition());
            if (statement.getBody() != null) {
                FundVisitor bodyVisitor = new FundVisitor(this.list_);
                statement.getBody().accept((ASTVisitor)bodyVisitor);
            }
        }
    }
}

