/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPPragmaNode;

public class OMPCFGNode {
    protected LinkedList inNodes_ = new LinkedList();
    protected LinkedList outNodes_ = new LinkedList();
    protected int id_ = -1;
    protected OMPPragmaNode pragmaContext_ = null;

    public void connectTo(OMPCFGNode node) {
        if (node == null) {
            return;
        }
        this.addOutNode(node);
        node.addInNode(this);
    }

    public void addInNode(OMPCFGNode inNode) {
        if (!this.inNodes_.contains(inNode)) {
            this.inNodes_.add(inNode);
        }
    }

    public void addOutNode(OMPCFGNode outNode) {
        if (!this.outNodes_.contains(outNode)) {
            this.outNodes_.add(outNode);
        }
    }

    public OMPCFGNode getSuccessor() {
        if (this.outNodes_.size() != 0) {
            return (OMPCFGNode)this.outNodes_.get(0);
        }
        return null;
    }

    public boolean hasPredecessors() {
        return this.inNodes_.size() != 0;
    }

    public OMPCFGNode[] getInNodes() {
        OMPCFGNode[] inNodesArray = new OMPCFGNode[this.inNodes_.size()];
        int count = 0;
        Iterator i = this.inNodes_.iterator();
        while (i.hasNext()) {
            inNodesArray[count++] = (OMPCFGNode)i.next();
        }
        return inNodesArray;
    }

    public OMPCFGNode[] getOutNodes() {
        OMPCFGNode[] outNodesArray = new OMPCFGNode[this.outNodes_.size()];
        int count = 0;
        Iterator i = this.outNodes_.iterator();
        while (i.hasNext()) {
            outNodesArray[count++] = (OMPCFGNode)i.next();
        }
        return outNodesArray;
    }

    public void setId(int id) {
        this.id_ = id;
    }

    public int getId() {
        return this.id_;
    }

    public void setPragmaContext(OMPPragmaNode pNode) {
        this.pragmaContext_ = pNode;
    }

    public OMPPragmaNode getPragmaContext() {
        return this.pragmaContext_;
    }
}

