/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import org.eclipse.ptp.pldt.openmp.analysis.OpenMPError;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPErrorManager;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFG;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFGNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPDFS;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPPragmaNode;

public class PASTSemanticCheck {
    protected int numErrors_ = 0;

    protected PASTSemanticCheck(OMPCFG cfg) {
        SemanticDFS dfs = new SemanticDFS(cfg.getRoot());
        dfs.startWalking();
    }

    public static boolean checkSemantics(OMPCFG cfg) {
        PASTSemanticCheck psc = new PASTSemanticCheck(cfg);
        return psc.getNumErrors() == 0;
    }

    public int getNumErrors() {
        return this.numErrors_;
    }

    private void checkPragmaSemantics(OMPPragmaNode pnode) {
        PASTOMPPragma pragma = pnode.getPragma();
        if (pragma == null) {
            return;
        }
        switch (pragma.getOMPType()) {
            case 0: {
                this.parallelCheck(pnode);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 7: {
                this.masterCheck(pnode);
                break;
            }
            case 8: {
                break;
            }
            case 12: {
                this.orderedCheck(pnode);
                break;
            }
            case 1: 
            case 5: {
                this.forCheck(pnode);
                break;
            }
            case 9: {
                this.barrierCheck(pnode);
                break;
            }
            case 11: 
            case 13: {
                break;
            }
            case 10: {
                break;
            }
            case -1: {
                return;
            }
        }
    }

    private void parallelCheck(OMPPragmaNode pnode) {
        OMPPragmaNode parent = pnode.getContextPredecessor();
        while (parent != null) {
            int pType = parent.getPragma().getOMPType();
            if (pType == 0 || pType == 5 || pType == 6) {
                this.handleProblem(pnode.getPragma(), "Parallel directive dynamically inside another parallel, establishes single thread context", 1);
                ++this.numErrors_;
                break;
            }
            parent = parent.getContextPredecessor();
        }
    }

    private void forCheck(OMPPragmaNode pnode) {
        PASTOMPPragma pragma = pnode.getPragma();
        boolean isParallel = pragma.getOMPType() == 5;
        OMPPragmaNode parent = pnode.getContextPredecessor();
        boolean errorFound = false;
        while (parent != null) {
            int parentType = parent.getPragma().getOMPType();
            if (!errorFound) {
                if (parentType == 1 || parentType == 3 || parentType == 4) {
                    errorFound = true;
                } else {
                    if (parentType == 8 || parentType == 12 || parentType == 7) {
                        this.handleProblem(pnode.getPragma(), "For directive embedded within critical, ordered, or master extents", 2);
                        ++this.numErrors_;
                        errorFound = true;
                        break;
                    }
                    if (parentType == 5 || parentType == 6) {
                        this.handleProblem(pnode.getPragma(), "For directive embedded within another parallel for or parallel sections", 2);
                        ++this.numErrors_;
                        errorFound = true;
                        break;
                    }
                    if (isParallel && parentType == 0) {
                        this.handleProblem(pnode.getPragma(), "Parallel directive dynamically inside another parallel, establishes single thread context", 1);
                        ++this.numErrors_;
                        break;
                    }
                }
            }
            if (errorFound && (parentType == 0 || parentType == 5 || parentType == 6)) {
                this.handleProblem(pnode.getPragma(), "For directive embedded within another for, sections, or single directive", 2);
                ++this.numErrors_;
                break;
            }
            parent = parent.getContextPredecessor();
        }
    }

    private void barrierCheck(OMPPragmaNode pnode) {
        OMPPragmaNode parent = pnode.getContextPredecessor();
        while (parent != null) {
            int pType = parent.getPragma().getOMPType();
            if (pType == 1 || pType == 5 || pType == 12 || pType == 3 || pType == 4 || pType == 7 || pType == 8) {
                this.handleProblem(pnode.getPragma(), "Barrier directive not permitted in region extent of for, ordered, sections, single, master, and critical", 2);
                ++this.numErrors_;
                break;
            }
            parent = parent.getContextPredecessor();
        }
    }

    private void masterCheck(OMPPragmaNode pnode) {
        OMPPragmaNode parent = pnode.getContextPredecessor();
        while (parent != null) {
            int pType = parent.getPragma().getOMPType();
            if (pType == 11 || pType == 5 || pType == 3 || pType == 6 || pType == 4) {
                this.handleProblem(pnode.getPragma(), "Master directive not permitted in dynamic extent of for, sections, or single directives", 2);
                ++this.numErrors_;
                break;
            }
            parent = parent.getContextPredecessor();
        }
    }

    private void orderedCheck(OMPPragmaNode pnode) {
        OMPPragmaNode parent = pnode.getContextPredecessor();
        while (parent != null) {
            int pType = parent.getPragma().getOMPType();
            if (pType == 8) {
                this.handleProblem(pnode.getPragma(), "Ordered directive not permitted in dynamic extent of critical region", 2);
                ++this.numErrors_;
                break;
            }
            parent = parent.getContextPredecessor();
        }
    }

    private void handleProblem(PASTOMPPragma pragma, String description, int severity) {
        OpenMPError error = new OpenMPError(description, pragma.getContainingFilename(), pragma.getStartingLine(), severity);
        OpenMPErrorManager.getCurrentErrorManager().addError(error);
        pragma.addProblem(error);
    }

    private class SemanticDFS
    extends OMPDFS {
        public SemanticDFS(OMPCFGNode startNode) {
            super(startNode);
        }

        @Override
        public int visit(OMPCFGNode node) {
            if (node instanceof OMPPragmaNode) {
                PASTSemanticCheck.this.checkPragmaSemantics((OMPPragmaNode)node);
            }
            return 0;
        }
    }
}

