/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.parser;

import java.util.Arrays;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.ptp.pldt.openmp.analysis.parser.OpenMPKeywords;
import org.eclipse.ptp.pldt.openmp.analysis.parser.OpenMPToken;

public class OpenMPScanner {
    private char[] inputBuffer_ = null;
    private int currentPos_ = -1;
    private int endPos_ = 0;
    protected final boolean supportMinAndMax = true;
    protected final boolean support$Initializers = true;
    protected static char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final int mpAtomic = 0;
    public static final int mpBarrier = 1;
    public static final int mpCopyin = 2;
    public static final int mpCopyprivate = 3;
    public static final int mpCritical = 4;
    public static final int mpDefault = 5;
    public static final int mpFirstprivate = 6;
    public static final int mpFlush = 7;
    public static final int mpFor = 8;
    public static final int mpIf = 9;
    public static final int mpLastprivate = 10;
    public static final int mpMaster = 11;
    public static final int mpNone = 12;
    public static final int mpNowait = 13;
    public static final int mpNumthreads = 14;
    public static final int mpOmp = 15;
    public static final int mpOrdered = 16;
    public static final int mpParallel = 17;
    public static final int mpPrivate = 18;
    public static final int mpReduction = 19;
    public static final int mpSchedule = 20;
    public static final int mpSection = 21;
    public static final int mpSections = 22;
    public static final int mpShared = 23;
    public static final int mpSingle = 24;
    public static final int mpThreadPrivate = 25;
    public static final int mpPound = 26;
    public static final int mpPragma = 27;
    public static final int mpDynamic = 28;
    public static final int mpGuided = 29;
    public static final int mpRuntime = 30;
    public static final int mpStatic = 31;
    public static final CharArrayIntMap mpKeywords = new CharArrayIntMap(16, -1);

    static {
        mpKeywords.put(OpenMPKeywords.ATOMIC, 0);
        mpKeywords.put(OpenMPKeywords.BARRIER, 1);
        mpKeywords.put(OpenMPKeywords.COPYIN, 2);
        mpKeywords.put(OpenMPKeywords.COPYPRIVATE, 3);
        mpKeywords.put(OpenMPKeywords.CRITICAL, 4);
        mpKeywords.put(OpenMPKeywords.DEFAULT, 5);
        mpKeywords.put(OpenMPKeywords.FIRSTPRIVATE, 6);
        mpKeywords.put(OpenMPKeywords.FLUSH, 7);
        mpKeywords.put(OpenMPKeywords.FOR, 8);
        mpKeywords.put(OpenMPKeywords.IF, 9);
        mpKeywords.put(OpenMPKeywords.LASTPRIVATE, 10);
        mpKeywords.put(OpenMPKeywords.MASTER, 11);
        mpKeywords.put(OpenMPKeywords.NONE, 12);
        mpKeywords.put(OpenMPKeywords.NOWAIT, 13);
        mpKeywords.put(OpenMPKeywords.NUMTHREADS, 14);
        mpKeywords.put(OpenMPKeywords.OMP, 15);
        mpKeywords.put(OpenMPKeywords.ORDERED, 16);
        mpKeywords.put(OpenMPKeywords.PARALLEL, 17);
        mpKeywords.put(OpenMPKeywords.PRIVATE, 18);
        mpKeywords.put(OpenMPKeywords.REDUCTION, 19);
        mpKeywords.put(OpenMPKeywords.SCHEDULE, 20);
        mpKeywords.put(OpenMPKeywords.SECTION, 21);
        mpKeywords.put(OpenMPKeywords.SECTIONS, 22);
        mpKeywords.put(OpenMPKeywords.SHARED, 23);
        mpKeywords.put(OpenMPKeywords.SINGLE, 24);
        mpKeywords.put(OpenMPKeywords.POUND, 26);
        mpKeywords.put(OpenMPKeywords.PRAGMA, 27);
        mpKeywords.put(OpenMPKeywords.THREADPRIVATE, 25);
        mpKeywords.put(OpenMPKeywords.DYNAMIC, 28);
        mpKeywords.put(OpenMPKeywords.STATIC, 31);
    }

    public OpenMPScanner(String inputBuffer) {
        this.inputBuffer_ = inputBuffer.toCharArray();
        this.endPos_ = inputBuffer.length();
    }

    public OpenMPToken nextToken() {
        return this.fetchToken();
    }

    protected OpenMPToken fetchToken() {
        block39: while (this.currentPos_ < this.endPos_) {
            this.skipOverWhiteSpace();
            ++this.currentPos_;
            if (this.currentPos_ >= this.endPos_) {
                return null;
            }
            switch (this.inputBuffer_[this.currentPos_]) {
                case '\n': 
                case '\r': {
                    break;
                }
                case 'L': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '\"') {
                        return this.scanString();
                    }
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '\'') {
                        return this.scanCharLiteral();
                    }
                    return this.scanIdentifier();
                }
                case '\"': {
                    return this.scanString();
                }
                case '\'': {
                    return this.scanCharLiteral();
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    return this.scanIdentifier();
                }
                case '\\': {
                    if (this.currentPos_ + 1 >= this.endPos_ || this.inputBuffer_[this.currentPos_ + 1] != 'u' && this.inputBuffer_[this.currentPos_ + 1] != 'U') continue block39;
                    return this.scanIdentifier();
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.scanNumber();
                }
                case '.': {
                    if (this.currentPos_ + 1 < this.endPos_) {
                        switch (this.inputBuffer_[this.currentPos_ + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                return this.scanNumber();
                            }
                            case '.': {
                                if (this.currentPos_ + 2 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 2] == '.') {
                                    this.currentPos_ += 2;
                                    return this.newToken(48);
                                }
                            }
                            case '*': {
                                ++this.currentPos_;
                                return this.newToken(49);
                            }
                        }
                    }
                    return this.newToken(50);
                }
                case '#': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '#') {
                        ++this.currentPos_;
                        return this.newToken(139);
                    }
                    return this.newToken(26);
                }
                case '{': {
                    ++this.currentPos_;
                    return this.newToken(12);
                }
                case '}': {
                    ++this.currentPos_;
                    return this.newToken(13);
                }
                case '[': {
                    ++this.currentPos_;
                    return this.newToken(10);
                }
                case ']': {
                    ++this.currentPos_;
                    return this.newToken(11);
                }
                case '(': {
                    return this.newToken(8);
                }
                case ')': {
                    return this.newToken(9);
                }
                case ';': {
                    return this.newToken(5);
                }
                case ':': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == ':') {
                        ++this.currentPos_;
                        return this.newToken(3);
                    }
                    return this.newToken(4);
                }
                case '?': {
                    return this.newToken(7);
                }
                case '+': {
                    if (this.currentPos_ + 1 < this.endPos_) {
                        if (this.inputBuffer_[this.currentPos_ + 1] == '+') {
                            ++this.currentPos_;
                            return this.newToken(15);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '=') {
                            ++this.currentPos_;
                            return this.newToken(14);
                        }
                    }
                    return this.newToken(16);
                }
                case '-': {
                    if (this.currentPos_ + 1 < this.endPos_) {
                        if (this.inputBuffer_[this.currentPos_ + 1] == '>') {
                            if (this.currentPos_ + 2 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 2] == '*') {
                                this.currentPos_ += 2;
                                return this.newToken(19);
                            }
                            ++this.currentPos_;
                            return this.newToken(20);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '-') {
                            ++this.currentPos_;
                            return this.newToken(18);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '=') {
                            ++this.currentPos_;
                            return this.newToken(17);
                        }
                    }
                    return this.newToken(21);
                }
                case '*': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '=') {
                        ++this.currentPos_;
                        return this.newToken(22);
                    }
                    return this.newToken(23);
                }
                case '/': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '=') {
                        ++this.currentPos_;
                        return this.newToken(51);
                    }
                    return this.newToken(52);
                }
                case '%': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '=') {
                        ++this.currentPos_;
                        return this.newToken(24);
                    }
                    return this.newToken(25);
                }
                case '^': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '=') {
                        ++this.currentPos_;
                        return this.newToken(26);
                    }
                    return this.newToken(27);
                }
                case '&': {
                    if (this.currentPos_ + 1 < this.endPos_) {
                        if (this.inputBuffer_[this.currentPos_ + 1] == '&') {
                            ++this.currentPos_;
                            return this.newToken(29);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '=') {
                            ++this.currentPos_;
                            return this.newToken(28);
                        }
                    }
                    return this.newToken(30);
                }
                case '|': {
                    if (this.currentPos_ + 1 < this.endPos_) {
                        if (this.inputBuffer_[this.currentPos_ + 1] == '|') {
                            ++this.currentPos_;
                            return this.newToken(32);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '=') {
                            ++this.currentPos_;
                            return this.newToken(31);
                        }
                    }
                    return this.newToken(33);
                }
                case '~': {
                    return this.newToken(34);
                }
                case '!': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '=') {
                        ++this.currentPos_;
                        return this.newToken(35);
                    }
                    return this.newToken(36);
                }
                case '=': {
                    if (this.currentPos_ + 1 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 1] == '=') {
                        ++this.currentPos_;
                        return this.newToken(37);
                    }
                    return this.newToken(38);
                }
                case '<': {
                    if (this.currentPos_ + 1 < this.endPos_) {
                        if (this.inputBuffer_[this.currentPos_ + 1] == '=') {
                            ++this.currentPos_;
                            return this.newToken(41);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '<') {
                            if (this.currentPos_ + 2 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 2] == '=') {
                                this.currentPos_ += 2;
                                return this.newToken(47);
                            }
                            ++this.currentPos_;
                            return this.newToken(40);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '?') {
                            ++this.currentPos_;
                            return this.newToken(CharArrayUtils.extract((char[])this.inputBuffer_, (int)this.currentPos_, (int)2), 153);
                        }
                    }
                    return this.newToken(42);
                }
                case '>': {
                    if (this.currentPos_ + 1 < this.endPos_) {
                        if (this.inputBuffer_[this.currentPos_ + 1] == '=') {
                            ++this.currentPos_;
                            return this.newToken(45);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '>') {
                            if (this.currentPos_ + 2 < this.endPos_ && this.inputBuffer_[this.currentPos_ + 2] == '=') {
                                this.currentPos_ += 2;
                                return this.newToken(43);
                            }
                            ++this.currentPos_;
                            return this.newToken(44);
                        }
                        if (this.inputBuffer_[this.currentPos_ + 1] == '?') {
                            ++this.currentPos_;
                            return this.newToken(CharArrayUtils.extract((char[])this.inputBuffer_, (int)this.currentPos_, (int)2), 152);
                        }
                    }
                    return this.newToken(46);
                }
                case ',': {
                    return this.newToken(6);
                }
                default: {
                    if (!Character.isLetter(this.inputBuffer_[this.currentPos_]) && this.inputBuffer_[this.currentPos_] != '_' && this.inputBuffer_[this.currentPos_] != '$') continue block39;
                    return this.scanIdentifier();
                }
            }
        }
        return null;
    }

    protected OpenMPToken scanString() {
        char[] buffer = this.inputBuffer_;
        int tokenType = 130;
        if (buffer[this.currentPos_] == 'L') {
            ++this.currentPos_;
            tokenType = 131;
        }
        int stringStart = this.currentPos_ + 1;
        int stringLen = 0;
        boolean escaped = false;
        boolean foundClosingQuote = false;
        while (++this.currentPos_ < this.endPos_) {
            ++stringLen;
            char c = buffer[this.currentPos_];
            if (c == '\"') {
                if (!escaped) {
                    foundClosingQuote = true;
                    break;
                }
            } else {
                if (c == '\\') {
                    escaped = !escaped;
                    continue;
                }
                if (c == '\n') {
                    if (!escaped) {
                        break;
                    }
                } else if (c == '\r' && this.currentPos_ + 1 < this.endPos_ && buffer[this.currentPos_ + 1] == '\n') {
                    ++this.currentPos_;
                    if (!escaped) break;
                }
            }
            escaped = false;
        }
        char[] result = CharArrayUtils.extract((char[])buffer, (int)stringStart, (int)(--stringLen));
        return this.newToken(result, tokenType);
    }

    protected OpenMPToken scanCharLiteral() {
        char[] buffer = this.inputBuffer_;
        int start = this.currentPos_;
        int limit = this.endPos_;
        int tokenType = 132;
        int length = 1;
        if (this.inputBuffer_[this.currentPos_] == 'L') {
            ++this.currentPos_;
            tokenType = 133;
            ++length;
        }
        if (start >= limit) {
            return this.newToken(EMPTY_CHAR_ARRAY, tokenType);
        }
        boolean escaped = false;
        while (++this.currentPos_ < this.endPos_) {
            ++length;
            int pos = this.currentPos_;
            if (buffer[pos] == '\'') {
                if (!escaped) {
                    break;
                }
            } else if (buffer[pos] == '\\') {
                escaped = !escaped;
                continue;
            }
            escaped = false;
        }
        if (this.currentPos_ == this.endPos_) {
            return this.newToken(EMPTY_CHAR_ARRAY, tokenType);
        }
        char[] image = length > 0 ? CharArrayUtils.extract((char[])buffer, (int)start, (int)length) : EMPTY_CHAR_ARRAY;
        return this.newToken(image, tokenType);
    }

    protected OpenMPToken scanNumber() {
        char[] buffer = this.inputBuffer_;
        int start = this.currentPos_;
        int limit = this.endPos_;
        boolean isFloat = buffer[start] == '.';
        boolean hasExponent = false;
        boolean isHex = false;
        boolean isOctal = false;
        boolean isMalformedOctal = false;
        if (buffer[start] == '0' && start + 1 < limit) {
            switch (buffer[start + 1]) {
                case 'X': 
                case 'x': {
                    isHex = true;
                    ++this.currentPos_;
                    break;
                }
                default: {
                    if (buffer[start + 1] > '0' && buffer[start + 1] < '7') {
                        isOctal = true;
                        break;
                    }
                    if (buffer[start + 1] != '8' && buffer[start + 1] != '9') break;
                    isOctal = true;
                    isMalformedOctal = true;
                    break;
                }
            }
        }
        block21: while (++this.currentPos_ < limit) {
            int pos = this.currentPos_++;
            block3 : switch (buffer[pos]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (buffer[pos] != '8' && buffer[pos] != '9' || !isOctal) continue block21;
                    isMalformedOctal = true;
                    break block21;
                }
                case '.': {
                    if (isFloat) break block21;
                    isFloat = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (isHex) continue block21;
                    if (hasExponent || pos + 1 >= limit) break block21;
                    switch (buffer[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            isFloat = true;
                            hasExponent = true;
                            break block3;
                        }
                    }
                    break block21;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': {
                    if (!isHex) break block21;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (isHex) continue block21;
                    ++this.currentPos_;
                    if (this.currentPos_ >= buffer.length || buffer[this.currentPos_] != 'i') break block21;
                    break;
                }
                case 'P': 
                case 'p': {
                    if (!isFloat || !isHex) {
                        --this.currentPos_;
                        break block21;
                    }
                    if (hasExponent || pos + 1 >= limit) break block21;
                    switch (buffer[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            isFloat = true;
                            hasExponent = true;
                            ++this.currentPos_;
                            break block3;
                        }
                    }
                    break block21;
                }
                case 'L': 
                case 'U': 
                case 'l': 
                case 'u': {
                    while (++this.currentPos_ < limit) {
                        switch (buffer[this.currentPos_]) {
                            case 'L': 
                            case 'U': 
                            case 'l': 
                            case 'u': {
                                break;
                            }
                            default: {
                                break block21;
                            }
                        }
                    }
                }
                default: {
                    break block21;
                }
            }
        }
        --this.currentPos_;
        char[] result = CharArrayUtils.extract((char[])buffer, (int)start, (int)(this.currentPos_ - start + 1));
        int tokenType = isFloat ? 129 : 2;
        return this.newToken(result, tokenType);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void skipOverWhiteSpace() {
        char[] buffer = this.inputBuffer_;
        block5: while (++this.currentPos_ < this.endPos_) {
            switch (buffer[this.currentPos_]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    continue block5;
                }
                case '/': {
                    if (this.currentPos_ + 1 >= this.endPos_) break;
                    if (buffer[this.currentPos_ + 1] == '/') {
                        this.currentPos_ = this.endPos_;
                        return;
                    }
                    if (buffer[this.currentPos_ + 1] != '*') break;
                    boolean foundEnd = false;
                    this.currentPos_ += 2;
                    while (this.currentPos_ < this.endPos_) {
                        if (buffer[this.currentPos_] == '*' && this.currentPos_ + 1 < this.endPos_ && buffer[this.currentPos_ + 1] == '/') {
                            this.currentPos_ += 2;
                            foundEnd = true;
                            break;
                        }
                        ++this.currentPos_;
                    }
                    if (foundEnd) continue block5;
                    return;
                }
                case '\\': {
                    if (this.currentPos_ + 1 < this.endPos_ && buffer[this.currentPos_ + 1] == '\n') {
                        ++this.currentPos_;
                        continue block5;
                    }
                    if (this.currentPos_ + 1 >= this.endPos_ || buffer[this.currentPos_ + 1] != '\r' || this.currentPos_ + 2 >= this.endPos_ || buffer[this.currentPos_ + 2] != '\n') break;
                    this.currentPos_ += 2;
                    continue block5;
                }
            }
            --this.currentPos_;
            return;
        }
        --this.currentPos_;
    }

    protected OpenMPToken scanIdentifier() {
        char[] buffer = this.inputBuffer_;
        boolean escapedNewline = false;
        int start = this.currentPos_;
        int len = 1;
        while (++this.currentPos_ < this.endPos_) {
            char c = buffer[this.currentPos_];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c)) {
                ++len;
                continue;
            }
            if (c == '\\' && this.currentPos_ + 1 < this.endPos_ && buffer[this.currentPos_ + 1] == '\n') {
                ++this.endPos_;
                len += 2;
                escapedNewline = true;
                continue;
            }
            if (c != '\\' || this.currentPos_ + 1 >= this.endPos_ || buffer[this.currentPos_ + 1] != 'u' && buffer[this.currentPos_ + 1] != 'U') break;
            ++this.currentPos_;
            len += 2;
        }
        --this.currentPos_;
        char[] result = escapedNewline ? this.removedEscapedNewline(buffer, start, len) : CharArrayUtils.extract((char[])buffer, (int)start, (int)len);
        int tokenType = escapedNewline ? mpKeywords.get(result, 0, result.length) : mpKeywords.get(buffer, start, len);
        return this.newToken(result, tokenType);
    }

    protected OpenMPToken newToken(int signal) {
        return new OpenMPToken(signal, this.currentPos_);
    }

    protected OpenMPToken newToken(char[] image, int signal) {
        return new OpenMPToken(new String(image), this.currentPos_, signal);
    }

    protected char[] removedEscapedNewline(char[] text, int start, int len) {
        if (CharArrayUtils.indexOf((char)'\n', (char[])text, (int)start, (int)len) == -1) {
            return text;
        }
        char[] result = new char[text.length];
        Arrays.fill(result, ' ');
        int counter = 0;
        int i = 0;
        while (i < text.length) {
            if (text[i] == '\\' && i + 1 < text.length && text[i + 1] == '\n') {
                ++i;
            } else if (text[i] == '\\' && i + 1 < text.length && text[i + 1] == '\r' && i + 2 < text.length && text[i + 2] == '\n') {
                i += 2;
            } else {
                result[counter++] = text[i];
            }
            ++i;
        }
        return CharArrayUtils.trim((char[])result);
    }

    private void handleProblem(int id, int startOffset) {
    }
}

