/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ptp.internal.rm.lml.core.messages.Messages;
import org.eclipse.ptp.internal.rm.lml.core.model.FastImpCheck;
import org.eclipse.ptp.internal.rm.lml.core.model.LMLCheck;
import org.eclipse.ptp.rm.lml.core.elements.GobjectType;
import org.eclipse.ptp.rm.lml.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplayelement;
import org.eclipse.ptp.rm.lml.core.elements.NodedisplaylayoutType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectFactory;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.LguiHandler;
import org.eclipse.ptp.rm.lml.core.model.Mask;

public class NodedisplayAccess
extends LguiHandler {
    private HashMap<String, HashMap<Integer, String>> oidToTagNames;
    private HashMap<String, HashMap<Integer, Mask>> oidToMasks;
    private HashMap<String, ArrayList<NodedisplaylayoutType>> oidToLayouts;
    private List<Nodedisplay> nodedisplays;
    private static Nodedisplayelement defaultlayout;

    public static Nodedisplayelement getDefaultLayout() {
        return defaultlayout;
    }

    public NodedisplayAccess(ILguiItem lguiItem, LguiType model) {
        super(lguiItem, model);
        this.updateData();
        this.lguiItem.addListener(new ILguiListener(){

            @Override
            public void handleEvent(ILguiUpdatedEvent e) {
                NodedisplayAccess.this.update(e.getLgui());
                NodedisplayAccess.this.updateData();
            }
        });
    }

    public String getImplicitName(String nodedisplayId, ArrayList<Integer> ids) {
        if (ids == null || ids.size() == 0) {
            return "";
        }
        ArrayList<Integer> copy = LMLCheck.copyArrayList(ids);
        Nodedisplay nodedisplay = this.getNodedisplayById(nodedisplayId);
        if (nodedisplay == null) {
            return "";
        }
        return LMLCheck.getImplicitName(copy, nodedisplay.getScheme());
    }

    public ArrayList<NodedisplaylayoutType> getLayouts(String id) {
        return this.oidToLayouts.get(id);
    }

    public Mask getMask(String id, int level) {
        HashMap<Integer, Mask> masks = this.getMasks(id);
        if (masks == null) {
            return null;
        }
        return masks.get(level);
    }

    public HashMap<Integer, Mask> getMasks(String id) {
        return this.oidToMasks.get(id);
    }

    public Nodedisplay getNodedisplayById(String id) {
        List<Nodedisplay> displays = this.getNodedisplays();
        for (Nodedisplay nodedisplay : displays) {
            if (!nodedisplay.getId().equals(id)) continue;
            return nodedisplay;
        }
        return null;
    }

    public Object getNodedisplayData(int i) {
        return this.getNodedisplays().get(i).getData();
    }

    public int getNodedisplayNumbers() {
        return this.getNodedisplays().size();
    }

    public List<Nodedisplay> getNodedisplays() {
        if (this.nodedisplays == null) {
            this.nodedisplays = new ArrayList<Nodedisplay>();
            for (GobjectType tag : this.lguiItem.getOverviewAccess().getGraphicalObjects()) {
                if (!(tag instanceof Nodedisplay)) continue;
                this.nodedisplays.add((Nodedisplay)tag);
            }
        }
        return this.nodedisplays;
    }

    public Object getNodedisplayScheme(int i) {
        return this.getNodedisplays().get(i).getScheme();
    }

    public String getNodedisplayTitel(int i) {
        return this.getNodedisplays().get(i).getTitle();
    }

    public LMLCheck.SchemeAndData getSchemeAndDataByLevels(String nodedisplayId, ArrayList<Integer> ids) {
        Nodedisplay nodedisplay = this.getNodedisplayById(nodedisplayId);
        if (nodedisplay == null) {
            return null;
        }
        return LMLCheck.getSchemeAndDataByLevels(ids, (Object)nodedisplay.getData(), (Object)nodedisplay.getScheme());
    }

    public SchemeElement getSchemeByLevels(String nodedisplayId, ArrayList<Integer> ids) {
        Nodedisplay nodedisplay = this.getNodedisplayById(nodedisplayId);
        if (nodedisplay == null) {
            return null;
        }
        return LMLCheck.getSchemeByLevels(ids, nodedisplay.getScheme());
    }

    public int getSchemeDepth(String nodedisplayId) {
        Nodedisplay nodedisplay = this.getNodedisplayById(nodedisplayId);
        if (nodedisplay == null) {
            return -1;
        }
        return LMLCheck.getDeepestSchemeLevel(nodedisplay.getScheme());
    }

    public String getTagname(String id, int level) {
        HashMap<Integer, String> tagnames = this.getTagnames(id);
        if (tagnames == null) {
            return null;
        }
        return tagnames.get(level);
    }

    public HashMap<Integer, String> getTagnames(String id) {
        return this.oidToTagNames.get(id);
    }

    public String getTitle(String gid) {
        List<Nodedisplay> displays = this.getNodedisplays();
        if (displays.size() == 0 || displays.get(0) == null) {
            return "Nodedisplay";
        }
        return displays.get(0).getTitle();
    }

    public ArrayList<Integer> impnameToLevel(String nodedisplayId, String impname) {
        Nodedisplay nodedisplay = this.getNodedisplayById(nodedisplayId);
        if (nodedisplay == null) {
            return null;
        }
        return FastImpCheck.impNameToOneLevel(impname, nodedisplay, new ArrayList<Integer>());
    }

    public String toString() {
        List<Nodedisplay> nodedisplays = this.getNodedisplays();
        if (nodedisplays.size() > 0) {
            return this.getNodedisplays().get(0).getTitle();
        }
        return Messages.NodedisplayAccess_2;
    }

    public void updateData() {
        this.oidToTagNames = new HashMap();
        this.oidToMasks = new HashMap();
        this.oidToLayouts = new HashMap();
        this.nodedisplays = null;
        this.getNodedisplays();
        for (Nodedisplay nodedisplay : this.nodedisplays) {
            HashMap<Integer, String> atagnames = new HashMap<Integer, String>();
            HashMap<Integer, Mask> amasks = new HashMap<Integer, Mask>();
            this.findtagNamesAndMasks(nodedisplay.getScheme(), 1, atagnames, amasks);
            this.oidToTagNames.put(nodedisplay.getId(), atagnames);
            this.oidToMasks.put(nodedisplay.getId(), amasks);
        }
        List<NodedisplaylayoutType> nodedisplayLayouts = this.lguiItem.getLayoutAccess().getNodedisplayLayouts();
        for (NodedisplaylayoutType nodedisplayLayout : nodedisplayLayouts) {
            if (this.oidToLayouts.containsKey(nodedisplayLayout.getGid())) {
                ArrayList<NodedisplaylayoutType> old = this.oidToLayouts.get(nodedisplayLayout.getGid());
                old.add(nodedisplayLayout);
                continue;
            }
            ArrayList<NodedisplaylayoutType> layouts = new ArrayList<NodedisplaylayoutType>();
            layouts.add(nodedisplayLayout);
            this.oidToLayouts.put(nodedisplayLayout.getGid(), layouts);
        }
        ObjectFactory objf = new ObjectFactory();
        defaultlayout = objf.createNodedisplayelement();
    }

    private void findtagNamesAndMasks(Object schemeelement, int level, HashMap<Integer, String> tagnames, HashMap<Integer, Mask> masks) {
        List<? extends SchemeElement> els = LMLCheck.getLowerSchemeElements(schemeelement);
        Iterator<? extends SchemeElement> iterator = els.iterator();
        while (iterator.hasNext()) {
            SchemeElement el;
            SchemeElement asel = el = iterator.next();
            if (!tagnames.containsKey(level) && asel.getTagname() != null) {
                tagnames.put(level, asel.getTagname());
            }
            if (!masks.containsKey(level) && asel.getMask() != null) {
                masks.put(level, new Mask(asel));
            }
            this.findtagNamesAndMasks(asel, level + 1, tagnames, masks);
        }
    }
}

