/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.logging.LogListener;

public class Logger
implements Preferences.IPropertyChangeListener {
    public static final boolean DEBUG = false;
    public static final String LOGGING_LEVEL = "logging_level";
    public static final int LOG_ERROR = 0;
    public static final int LOG_WARNING = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_DEBUG = 3;
    private ILog systemsPluginLog = null;
    private LogListener logListener = null;
    private String pluginId = null;
    private Plugin systemPlugin = null;
    private int debug_level = 0;

    Logger(Plugin systemPlugin) {
        this.systemPlugin = systemPlugin;
        this.pluginId = systemPlugin.getBundle().getSymbolicName();
        this.initialize();
    }

    public synchronized void freeResources() {
        this.logListener.freeResources();
    }

    public synchronized int getDebugLevel() {
        return this.debug_level;
    }

    public synchronized void logDebugMessage(String className, String message) {
    }

    public synchronized void logError(String message, Throwable ex) {
        if (this.debug_level >= 0) {
            if (message == null) {
                message = "";
            }
            Status errorStatus = new Status(4, this.pluginId, 0, message, ex);
            this.systemsPluginLog.log((IStatus)errorStatus);
        }
    }

    public synchronized void logInfo(String message) {
        this.logInfo(message, null);
    }

    public synchronized void logInfo(String message, Throwable ex) {
        if (this.debug_level >= 2) {
            if (message == null) {
                message = "";
            }
            Status infoStatus = new Status(1, this.pluginId, 0, message, ex);
            this.systemsPluginLog.log((IStatus)infoStatus);
        }
    }

    public synchronized void logWarning(String message) {
        this.logWarning(message, null);
    }

    public synchronized void logWarning(String message, Throwable ex) {
        if (this.debug_level >= 1) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, this.pluginId, 0, message, ex);
            this.systemsPluginLog.log((IStatus)warningStatus);
        }
    }

    public synchronized void propertyChange(Preferences.PropertyChangeEvent event) {
        Preferences prefs = this.systemPlugin.getPluginPreferences();
        this.debug_level = prefs.getInt(LOGGING_LEVEL);
    }

    public synchronized void setDebugLevel(int level) {
        this.debug_level = level;
    }

    private void initialize() {
        this.systemsPluginLog = this.systemPlugin.getLog();
        this.logListener = new LogListener(this.systemPlugin);
        this.systemsPluginLog.addLogListener((ILogListener)this.logListener);
        Preferences store = this.systemPlugin.getPluginPreferences();
        this.debug_level = store.getInt(LOGGING_LEVEL);
        store.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        store.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.logListener);
    }
}

