/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.jaxws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.jaxws.AbstractWebServiceNewOperation;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.operation.jaxws.FactoryPathGenerator;
import org.eclipse.scout.sdk.s2e.operation.jaxws.JaxWsModuleNewOperation;
import org.eclipse.scout.sdk.s2e.operation.jaxws.RebuildArtifactsOperation;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.osgi.service.prefs.BackingStoreException;

public class WebServiceNewOperation
extends AbstractWebServiceNewOperation {
    public static final String FACTORY_PATH_FILE_NAME = ".factorypath";
    public static final String JDT_APT_SETTINGS_NODE = "org.eclipse.jdt.apt.core";
    public static final String APT_GEN_SRC_DIR_KEY = "org.eclipse.jdt.apt.genSrcDir";
    public static final String APT_RECONCILE_ENABLED_KEY = "org.eclipse.jdt.apt.reconcileEnabled";
    public static final boolean APT_RECONCILE_ENABLED_VALUE = true;
    public static final String APT_ENABLED_KEY = "org.eclipse.jdt.apt.aptEnabled";
    public static final boolean APT_ENABLED_VALUE = true;
    public static final String PROCESS_ANNOTATIONS_KEY = "org.eclipse.jdt.core.compiler.processAnnotations";
    public static final String PROCESS_ANNOTATIONS_VALUE = "enabled";
    private IJavaProject m_serverModule;
    private IJavaProject m_jaxWsProject;
    private String m_artifactId;

    public void accept(IEnvironment env, IProgress progress) {
        IJavaProject jaxWsProject = this.getJaxWsProject();
        if (JdtUtils.exists((IJavaElement)jaxWsProject)) {
            this.setProjectRoot(jaxWsProject.getProject().getLocation().toFile().toPath());
            this.setSourceFolder((IClasspathEntry)EclipseEnvironment.narrow(env).toScoutJavaEnvironment(jaxWsProject).primarySourceFolder().orElseThrow(() -> Ensure.newFail((CharSequence)"Project {} does not contain a source folder.", (Object[])new Object[]{jaxWsProject.getElementName()})));
        }
        super.accept(env, progress);
        EclipseProgress postProcess = EclipseEnvironment.toScoutProgress(progress).newChild(2);
        if (this.isCreateNewModule()) {
            this.setIgnoreOptionalProblems("target/generated-sources/wsimport", (IProgressMonitor)postProcess.monitor());
        } else {
            S2eUtils.mavenUpdate(Collections.singleton(this.getJaxWsProject().getProject()), false, true, false, false, (IProgressMonitor)postProcess.monitor());
        }
    }

    protected java.nio.file.Path createNewJaxWsModule(IEnvironment env, IProgress progress) {
        Ensure.notNull((Object)this.getServerModule(), (CharSequence)"Target module pom file could not be found.", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getArtifactId(), (CharSequence)"ArtifactId cannot be empty when creating a new jaxws module.", (Object[])new Object[0]);
        JaxWsModuleNewOperation op = new JaxWsModuleNewOperation();
        op.setArtifactId(this.getArtifactId());
        op.setServerModule(this.getServerModule());
        op.accept(EclipseEnvironment.narrow(env), EclipseEnvironment.toScoutProgress(progress));
        IProject createdProject = op.getCreatedProject();
        this.setJaxWsProject(JavaCore.create((IProject)createdProject));
        return createdProject.getLocation().toFile().toPath();
    }

    protected void createEntryPointDefinitions(IEnvironment env, IProgress progress) {
        this.enableApt(env, progress);
        super.createEntryPointDefinitions(env, progress);
    }

    protected void enableApt(IEnvironment env, IProgress progress) {
        this.getJaxWsProject().setOption(PROCESS_ANNOTATIONS_KEY, PROCESS_ANNOTATIONS_VALUE);
        IEclipsePreferences aptPluginPreferenceNode = new ProjectScope(this.getJaxWsProject().getProject()).getNode(JDT_APT_SETTINGS_NODE);
        aptPluginPreferenceNode.putBoolean(APT_ENABLED_KEY, true);
        aptPluginPreferenceNode.put(APT_GEN_SRC_DIR_KEY, "target/generated-sources/annotations");
        aptPluginPreferenceNode.putBoolean(APT_RECONCILE_ENABLED_KEY, true);
        try {
            aptPluginPreferenceNode.flush();
        }
        catch (BackingStoreException e) {
            SdkLog.info((CharSequence)"Unable to save the APT preferences of project '{}'.", (Object[])new Object[]{this.getJaxWsProject().getElementName(), e});
        }
        this.createFactoryPath(env, progress);
    }

    protected void createFactoryPath(IEnvironment env, IProgress progress) {
        java.nio.file.Path factoryPathFile = this.getProjectRoot().resolve(FACTORY_PATH_FILE_NAME);
        env.writeResource((ISourceGenerator)new FactoryPathGenerator().withRtVersion(this.getScoutVersion()), factoryPathFile, progress);
    }

    protected String getScoutVersion() {
        String prefix = "org.eclipse.scout.rt.platform-";
        String suffix = ".jar";
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getJaxWsProject().getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                String fileName = root.getPath().lastSegment();
                String fileNameLower = fileName.toLowerCase(Locale.ENGLISH);
                if (fileNameLower.startsWith(prefix) && fileNameLower.endsWith(suffix)) {
                    return fileName.substring(prefix.length(), fileName.length() - suffix.length());
                }
                ++n2;
            }
            SdkLog.info((CharSequence)"Unable to calculate Scout version of project {}. Fallback to default.", (Object[])new Object[]{this.getJaxWsProject().getElementName()});
        }
        catch (RuntimeException | JavaModelException e) {
            SdkLog.warning((CharSequence)"Cannot calculate Scout version for .factorypath file.", (Object[])new Object[]{e});
        }
        return "10.0.42";
    }

    protected void setIgnoreOptionalProblems(String entryPath, IProgressMonitor monitor) {
        try {
            IJavaProject jaxWsProject = this.getJaxWsProject();
            org.eclipse.jdt.core.IClasspathEntry[] rawClasspathEntries = jaxWsProject.getRawClasspath();
            ArrayList<org.eclipse.jdt.core.IClasspathEntry> newEntries = new ArrayList<org.eclipse.jdt.core.IClasspathEntry>(rawClasspathEntries.length);
            Path entryPathToSearch = new Path(String.valueOf('/') + jaxWsProject.getElementName() + '/' + entryPath);
            org.eclipse.jdt.core.IClasspathEntry[] iClasspathEntryArray = rawClasspathEntries;
            int n = rawClasspathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.jdt.core.IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)entryPathToSearch)) {
                    IClasspathAttribute[] origAttributes = entry.getExtraAttributes();
                    ArrayList<IClasspathAttribute> newAttributes = new ArrayList<IClasspathAttribute>(origAttributes.length + 1);
                    IClasspathAttribute[] iClasspathAttributeArray = origAttributes;
                    int n3 = origAttributes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathAttribute attrib = iClasspathAttributeArray[n4];
                        if (!"ignore_optional_problems".equals(attrib.getName())) {
                            newAttributes.add(attrib);
                        }
                        ++n4;
                    }
                    newAttributes.add(JavaCore.newClasspathAttribute((String)"ignore_optional_problems", (String)Boolean.TRUE.toString()));
                    newEntries.add(JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])newAttributes.toArray(new IClasspathAttribute[0])));
                } else {
                    newEntries.add(entry);
                }
                ++n2;
            }
            jaxWsProject.setRawClasspath(newEntries.toArray(new org.eclipse.jdt.core.IClasspathEntry[0]), monitor);
        }
        catch (JavaModelException e) {
            SdkLog.warning((CharSequence)"'Ignore Optional Problems' could not be enabled.", (Object[])new Object[]{e});
        }
    }

    protected void createDerivedResources(IEnvironment env, IProgress progress) {
        new RebuildArtifactsOperation(this.getJaxWsProject()).accept(env, progress);
    }

    public String getArtifactId() {
        return this.m_artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.m_artifactId = artifactId;
    }

    public IJavaProject getServerModule() {
        return this.m_serverModule;
    }

    public void setServerModule(IJavaProject targetModule) {
        this.m_serverModule = targetModule;
    }

    public IJavaProject getJaxWsProject() {
        return this.m_jaxWsProject;
    }

    public void setJaxWsProject(IJavaProject jaxWsProject) {
        this.m_jaxWsProject = jaxWsProject;
    }
}

