/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.tools.internal.export.csv;

import org.eclipse.sirius.table.business.api.query.DCellQuery;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;

public class TableFiller {
    private static final char QUOTE_CHARACTER = '\'';
    private static final String WINDOWS_CR_CHARACTER = "\r\n";
    private char delimiter;
    private char replacementDelimiter;

    public TableFiller(char delimiter, char replacementDelimiter) {
        this.delimiter = delimiter;
        this.replacementDelimiter = replacementDelimiter;
    }

    public String getContent(DLine line) {
        return this.replaceDelimiter(this.getDelimiter(), this.getReplacementDelimiter(), this.notNullLabel(line.getLabel()));
    }

    public String getContent(DColumn column) {
        return this.replaceDelimiter(this.getDelimiter(), this.getReplacementDelimiter(), this.notNullLabel(column.getLabel()));
    }

    private String notNullLabel(String label) {
        return label != null ? label : "";
    }

    public String getContent(DCell cell) {
        String label = new DCellQuery(cell).getExportableLabel();
        if (label != null) {
            label = this.replaceDelimiter(this.getDelimiter(), this.getReplacementDelimiter(), label);
            if (label.contains(WINDOWS_CR_CHARACTER)) {
                label = this.replaceDelimiter(WINDOWS_CR_CHARACTER, "\n", label);
            }
            if (label.contains("\n")) {
                label = this.replaceDelimiter(String.valueOf('\''), String.valueOf(String.valueOf('\'')) + String.valueOf('\''), label);
                label = String.valueOf('\'') + label + '\'';
            }
        } else {
            label = "";
        }
        return label;
    }

    protected String replaceDelimiter(String delimiter2, String newDelimiter, String content) {
        return content.replaceAll(delimiter2, newDelimiter);
    }

    protected String getDelimiter() {
        return "" + this.delimiter;
    }

    protected String getReplacementDelimiter() {
        return "" + this.replacementDelimiter;
    }
}

