/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence.delegates;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IVariableDelegate;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;

public class GsonMapPersistenceDelegate
extends ExecutableExtension
implements IPersistenceDelegate {
    private final String defaultFileExtension;
    protected static final String VARIABLES = "__VariablesMap__";
    private final Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();

    public GsonMapPersistenceDelegate() {
        this("json");
    }

    public GsonMapPersistenceDelegate(String defaultFileExtension) {
        Assert.isNotNull((Object)defaultFileExtension);
        this.defaultFileExtension = defaultFileExtension;
    }

    @Override
    public Class<?> getPersistedClass(Object context) {
        return Map.class;
    }

    protected String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    @Override
    public Object writeList(Object[] context, Object container) throws IOException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)container);
        return this.write(context, container, true);
    }

    @Override
    public final Object write(Object context, Object container) throws IOException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)container);
        return this.write(context, container, false);
    }

    private Object write(Object context, Object container, boolean isList) throws IOException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)container);
        if (container instanceof URI) {
            URI uri = (URI)container;
            if (!"file".equalsIgnoreCase(uri.getScheme())) {
                throw new IOException("Unsupported URI schema '" + uri.getScheme() + "'");
            }
            File file = new File(uri.normalize());
            if (!file.isAbsolute()) {
                throw new IOException("URI must denote an absolute file path.");
            }
            Path path = new Path(file.getCanonicalPath());
            if (path.getFileExtension() == null) {
                file = path.addFileExtension(this.getDefaultFileExtension()).toFile();
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            if (!isList) {
                try {
                    this.gson.toJson(this.internalToMap(context), Map.class, (Appendable)writer);
                }
                finally {
                    ((Writer)writer).close();
                }
            } else {
                ArrayList<String> encoded = new ArrayList<String>();
                Object[] objectArray = (Object[])context;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object entry = objectArray[n2];
                    encoded.add(this.gson.toJson(this.internalToMap(entry)));
                    ++n2;
                }
                try {
                    this.gson.toJson(encoded, List.class, (Appendable)writer);
                }
                finally {
                    ((Writer)writer).close();
                }
            }
        } else if (String.class.equals(container)) {
            if (!isList) {
                container = this.gson.toJson(this.internalToMap(context));
            } else {
                ArrayList<String> encoded = new ArrayList<String>();
                Object[] objectArray = (Object[])context;
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object entry = objectArray[n3];
                    encoded.add(this.gson.toJson(this.internalToMap(entry)));
                    ++n3;
                }
                container = this.gson.toJson(encoded);
            }
        }
        return container;
    }

    private Map<String, Object> internalToMap(Object context) {
        try {
            Map<String, Object> data = this.toMap(context);
            if (data != null) {
                IVariableDelegate[] delegates;
                Map<String, String> variables = null;
                IVariableDelegate[] iVariableDelegateArray = delegates = PersistenceManager.getInstance().getVariableDelegates(this);
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariableDelegate delegate = iVariableDelegateArray[n2];
                    variables = delegate.getVariables(data);
                    ++n2;
                }
                if (variables != null && !variables.isEmpty()) {
                    data.put(VARIABLES, variables);
                }
            }
            TreeMap<String, Object> sorted = new TreeMap<String, Object>(data);
            return sorted;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object[] readList(Class<?> contextClass, Object container) throws IOException {
        Assert.isNotNull((Object)container);
        return (Object[])this.read(contextClass, container, true);
    }

    @Override
    public final Object read(Object context, Object container) throws IOException {
        Assert.isNotNull((Object)container);
        return this.read(context, container, false);
    }

    /*
     * WARNING - void declaration
     */
    private Object read(Object context, Object container, boolean isList) throws IOException {
        Assert.isNotNull((Object)container);
        ArrayList<Map> data = new ArrayList<Map>();
        if (container instanceof URI) {
            Path path;
            URI uRI = (URI)container;
            if (!"file".equalsIgnoreCase(uRI.getScheme())) {
                throw new IOException("Unsupported URI schema '" + uRI.getScheme() + "'");
            }
            File file = new File(uRI.normalize());
            if (!file.isAbsolute()) {
                throw new IOException("URI must denote an absolute file path.");
            }
            if (!file.exists() && (path = new Path(file.getCanonicalPath())).getFileExtension() == null) {
                file = path.addFileExtension(this.getDefaultFileExtension()).toFile();
            }
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            if (!isList) {
                try {
                    Map read = (Map)this.gson.fromJson((Reader)reader, Map.class);
                    data.add(read);
                }
                finally {
                    ((Reader)reader).close();
                }
            } else {
                try {
                    List strings = (List)this.gson.fromJson((Reader)reader, List.class);
                    for (String string : strings) {
                        Map read = (Map)this.gson.fromJson(string, Map.class);
                        data.add(read);
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
        } else if (container instanceof String) {
            if (!isList) {
                data.add((Map)this.gson.fromJson((String)container, Map.class));
            } else {
                List list = (List)this.gson.fromJson((String)container, List.class);
                for (Object string : list) {
                    data.add((Map)this.gson.fromJson((String)string, Map.class));
                }
            }
        }
        for (Map map : data) {
            IVariableDelegate[] delegates;
            if (map == null) continue;
            HashMap<String, String> variables = new HashMap();
            if (map.containsKey(VARIABLES)) {
                variables = (Map)map.remove(VARIABLES);
            }
            IVariableDelegate[] iVariableDelegateArray = delegates = PersistenceManager.getInstance().getVariableDelegates(this);
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                void var5_10;
                IVariableDelegate delegate = iVariableDelegateArray[n2];
                Map<String, Object> map2 = delegate.putVariables((Map<String, Object>)var5_10, variables);
                ++n2;
            }
        }
        if (!isList) {
            return !data.isEmpty() && data.get(0) != null ? this.fromMap((Map)data.get(0), context) : context;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map entry : data) {
            arrayList.add(this.fromMap(entry, context));
        }
        return arrayList.toArray();
    }

    @Override
    public boolean delete(Object context, Object container) throws IOException {
        Assert.isNotNull((Object)container);
        if (container instanceof URI) {
            Path path;
            URI uri = (URI)container;
            if (!"file".equalsIgnoreCase(uri.getScheme())) {
                throw new IOException("Unsupported URI schema '" + uri.getScheme() + "'");
            }
            File file = new File(uri.normalize());
            if (!file.isAbsolute()) {
                throw new IOException("URI must denote an absolute file path.");
            }
            if (!file.exists() && (path = new Path(file.getCanonicalPath())).getFileExtension() == null) {
                file = path.addFileExtension(this.getDefaultFileExtension()).toFile();
            }
            if ((path = new Path(file.getCanonicalPath())).getFileExtension() == null) {
                file = path.addFileExtension(this.getDefaultFileExtension()).toFile();
            }
            return file.delete();
        }
        return false;
    }

    protected Map<String, Object> toMap(Object context) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap attrs = null;
        if (context instanceof Map) {
            attrs = (HashMap)context;
        } else if (context instanceof IPropertiesContainer) {
            IPropertiesContainer container = (IPropertiesContainer)context;
            attrs = new HashMap(container.getProperties());
        }
        if (attrs != null) {
            for (Map.Entry entry : attrs.entrySet()) {
                if (((String)entry.getKey()).endsWith(".transient")) continue;
                result.put((String)entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    protected Object fromMap(Map<String, Object> map, Object context) throws IOException {
        if (context == null || Map.class.equals(context)) {
            return map;
        }
        if (context instanceof Map) {
            HashMap<String, Object> newMap = new HashMap<String, Object>((Map)context);
            newMap.putAll(map);
            return newMap;
        }
        if (IPropertiesContainer.class.equals(context)) {
            PropertiesContainer container = new PropertiesContainer();
            container.setProperties(map);
            return container;
        }
        if (context instanceof IPropertiesContainer) {
            IPropertiesContainer container = (IPropertiesContainer)context;
            container.setProperties(map);
            return container;
        }
        return null;
    }
}

