/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class AdminKSubstListener
extends CommandOutputListener {
    private Command.KSubstOption ksubstMode;

    public AdminKSubstListener(Command.KSubstOption ksubstMode) {
        this.ksubstMode = ksubstMode;
    }

    @Override
    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (line.startsWith("RCS file:")) {
            String rcsFile = line.substring(10).trim();
            if (!rcsFile.endsWith(",v")) {
                return new CVSStatus(4, NLS.bind((String)CVSMessages.AdminKSubstListener_expectedRCSFile, (Object[])new String[]{rcsFile}));
            }
            Path rcsFilePath = new Path(null, Util.removeAtticSegment(rcsFile.substring(0, rcsFile.length() - 2)));
            try {
                ICVSFile file = this.findLocalFileFor(commandRoot, (IPath)rcsFilePath);
                byte[] syncBytes = file.getSyncBytes();
                if (syncBytes != null) {
                    file.setSyncBytes(ResourceSyncInfo.setKeywordMode(syncBytes, this.ksubstMode), 0);
                }
            }
            catch (CVSException e) {
                return e.getStatus();
            }
        }
        return OK;
    }

    private ICVSFile findLocalFileFor(ICVSFolder commandRoot, IPath rcsFilePath) throws CVSException {
        IPath relativeFilePath;
        ICVSFile file;
        FolderSyncInfo info = commandRoot.getFolderSyncInfo();
        String remoteRootLocation = info.getRemoteLocation();
        if (remoteRootLocation == null) {
            throw new CVSException((IStatus)new CVSStatus(4, CVSMessages.AdminKSubstListener_commandRootNotManaged));
        }
        Path remoteRootPath = new Path(null, remoteRootLocation);
        if (remoteRootPath.isPrefixOf(rcsFilePath) && (file = commandRoot.getFile((relativeFilePath = rcsFilePath.removeFirstSegments(remoteRootPath.segmentCount())).toString())).isManaged() && this.isMatchingPath(file, rcsFilePath)) {
            return file;
        }
        ICVSFolder parent = this.findFolder(commandRoot, rcsFilePath.removeLastSegments(1));
        if (parent != null && (file = parent.getFile(rcsFilePath.lastSegment())).isManaged()) {
            return file;
        }
        throw new CVSException((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.AdminKSubstListener_expectedChildOfCommandRoot, (Object[])new String[]{rcsFilePath.toString(), remoteRootPath.toString()})));
    }

    private ICVSFolder findFolder(ICVSFolder commandRoot, IPath path) throws CVSException {
        final String remotePath = path.toString();
        final ICVSFolder[] result = new ICVSFolder[1];
        commandRoot.accept(new ICVSResourceVisitor(){

            @Override
            public void visitFile(ICVSFile file) throws CVSException {
            }

            @Override
            public void visitFolder(ICVSFolder folder) throws CVSException {
                FolderSyncInfo info = folder.getFolderSyncInfo();
                if (info != null && info.getRemoteLocation().equals(remotePath)) {
                    result[0] = folder;
                }
                if (result[0] == null) {
                    folder.acceptChildren(this);
                }
            }
        });
        return result[0];
    }

    private boolean isMatchingPath(ICVSFile file, IPath rcsFilePath) throws CVSException {
        FolderSyncInfo info = file.getParent().getFolderSyncInfo();
        return info != null && info.getRemoteLocation().equals(rcsFilePath.removeLastSegments(1).toString());
    }
}

