/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantTree;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class CVSResourceVariantTree
extends ResourceVariantTree {
    private CVSTag tag;
    private boolean cacheFileContentsHint;
    private CVSSyncTreeSubscriber subscriber;

    public CVSResourceVariantTree(ResourceVariantByteStore cache, CVSTag tag, boolean cacheFileContentsHint) {
        super(cache);
        this.tag = tag;
        this.cacheFileContentsHint = cacheFileContentsHint;
    }

    public ResourceVariantByteStore getByteStore() {
        return super.getByteStore();
    }

    protected byte[] getBytes(IResource local, IResourceVariant remote) throws TeamException {
        if (remote != null) {
            return super.getBytes(local, remote);
        }
        if (local.getType() == 2) {
            return this.getBaseBytes((IContainer)local, this.getTag(local));
        }
        return null;
    }

    protected IResourceVariant[] fetchMembers(IResourceVariant remote, IProgressMonitor progress) throws TeamException {
        ICVSRemoteResource[] children = remote != null ? ((RemoteResource)remote).members(progress) : new ICVSRemoteResource[]{};
        IResourceVariant[] result = new IResourceVariant[children.length];
        int i = 0;
        while (i < children.length) {
            result[i] = (IResourceVariant)children[i];
            ++i;
        }
        return result;
    }

    protected IResourceVariant fetchVariant(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        return (IResourceVariant)CVSWorkspaceRoot.getRemoteTree(resource, this.getTag(resource), this.isCacheFileContentsHint(), depth, monitor);
    }

    public IResource[] collectChanges(IResource local, IResourceVariant remote, int depth, IProgressMonitor monitor) throws TeamException {
        return super.collectChanges(local, remote, depth, monitor);
    }

    public IResource[] members(IResource resource) throws TeamException {
        if (resource.getType() == 1) {
            return new IResource[0];
        }
        HashSet<IResource> members = new HashSet<IResource>();
        members.addAll(Arrays.asList(super.members(resource)));
        try {
            IResource[] localMembers;
            IResource[] iResourceArray = localMembers = EclipseSynchronizer.getInstance().members((IContainer)resource);
            int n = localMembers.length;
            int n2 = 0;
            while (n2 < n) {
                ICVSFolder folder;
                IResource local = iResourceArray[n2];
                if (local.getType() != 1 && (folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)local)).isCVSFolder()) {
                    members.add(local);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
        return members.toArray(new IResource[members.size()]);
    }

    public IResource[] roots() {
        return this.subscriber.roots();
    }

    public IResourceVariant getResourceVariant(IResource resource) throws TeamException {
        byte[] remoteBytes = this.getByteStore().getBytes(resource);
        if (remoteBytes == null) {
            return null;
        }
        if (resource.getType() == 1) {
            byte[] parentBytes = this.getParentBytes(resource);
            if (parentBytes == null) {
                IProject project = resource.getProject();
                if (project.exists() && RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId()) != null) {
                    CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSMessages.ResourceSynchronizer_missingParentBytesOnGet, (Object[])new String[]{this.getSyncName(this.getByteStore()).toString(), resource.getFullPath().toString()}), resource);
                    CVSProviderPlugin.log((IStatus)status);
                }
                return null;
            }
            return RemoteFile.fromBytes(resource, remoteBytes, parentBytes);
        }
        return RemoteFolder.fromBytes(resource, remoteBytes);
    }

    private String getSyncName(ResourceVariantByteStore cache) {
        if (cache instanceof PersistantResourceVariantByteStore) {
            return ((PersistantResourceVariantByteStore)cache).getSyncName().toString();
        }
        return cache.getClass().getName();
    }

    private byte[] getParentBytes(IResource resource) throws TeamException {
        IContainer parent = resource.getParent();
        byte[] bytes = this.getByteStore().getBytes((IResource)parent);
        if (bytes == null) {
            bytes = this.getBaseBytes(parent, this.getTag(resource));
        }
        return bytes;
    }

    private byte[] getBaseBytes(IContainer parent, CVSTag tag) throws CVSException {
        byte[] bytes;
        ICVSFolder local = CVSWorkspaceRoot.getCVSFolderFor(parent);
        FolderSyncInfo info = local.getFolderSyncInfo();
        if (info == null) {
            bytes = null;
        } else {
            MutableFolderSyncInfo newInfo = info.cloneMutable();
            newInfo.setTag(tag);
            newInfo.setStatic(false);
            bytes = newInfo.getBytes();
        }
        return bytes;
    }

    private boolean hasLocalSyncInfo(IContainer folder) {
        ICVSFolder local = CVSWorkspaceRoot.getCVSFolderFor(folder);
        try {
            return local.getFolderSyncInfo() != null;
        }
        catch (CVSException cVSException) {
            return true;
        }
    }

    public CVSTag getTag(IResource resource) {
        return this.tag;
    }

    public void dispose() {
        this.getByteStore().dispose();
    }

    protected boolean setVariant(IResource local, IResourceVariant remote) throws TeamException {
        if (local.getType() == 2 && remote != null && !this.hasLocalSyncInfo((IContainer)((IFolder)local)) && this.hasLocalSyncInfo(local.getParent())) {
            CVSEntryLineTag tag = CVSWorkspaceRoot.getCVSFolderFor(local.getParent()).getFolderSyncInfo().getTag();
            FolderSyncInfo info = null;
            try {
                info = FolderSyncInfo.getFolderSyncInfo(remote.asBytes());
            }
            catch (CVSException e) {
                Status status = new Status(4, "org.eclipse.team.cvs.core", NLS.bind((String)CVSMessages.CVSResourceVariantTree_GettingSyncInfoError, (Object)local.getProjectRelativePath().toString()), (Throwable)((Object)e));
                throw new CVSException((IStatus)status);
            }
            MutableFolderSyncInfo newInfo = info.cloneMutable();
            newInfo.setTag(tag);
            ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IFolder)local));
            cvsFolder.setFolderSyncInfo(newInfo);
        }
        if (remote == null && !this.isManaged(local)) {
            boolean changed = this.getByteStore().getBytes(local) != null;
            this.flushVariants(local, 0);
            return changed;
        }
        boolean changed = super.setVariant(local, remote);
        if (local.getType() == 1 && this.getByteStore().getBytes(local) != null && !this.parentHasSyncBytes(local)) {
            CVSProviderPlugin.log((CoreException)((Object)new TeamException(NLS.bind((String)CVSMessages.ResourceSynchronizer_missingParentBytesOnSet, (Object[])new String[]{this.getSyncName(this.getByteStore()), local.getFullPath().toString()}))));
        }
        return changed;
    }

    private boolean isManaged(IResource local) {
        try {
            return CVSWorkspaceRoot.getCVSResourceFor(local).isManaged();
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    private boolean parentHasSyncBytes(IResource resource) throws TeamException {
        if (resource.getType() == 4) {
            return true;
        }
        return this.getParentBytes(resource) != null;
    }

    protected IResource[] collectedMembers(IResource local, IResource[] members) throws TeamException {
        IResource[] resources = this.getStoredMembers(local);
        ArrayList<IResource> children = new ArrayList<IResource>();
        ArrayList<IResource> changedResources = new ArrayList<IResource>();
        children.addAll(Arrays.asList(members));
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!children.contains(resource)) {
                this.flushVariants(resource, 2);
                changedResources.add(resource);
            }
            ++n2;
        }
        return changedResources.toArray(new IResource[changedResources.size()]);
    }

    private IResource[] getStoredMembers(IResource local) throws TeamException {
        try {
            if (local.getType() != 1 && (local.exists() || local.isPhantom())) {
                IResource[] allChildren = ((IContainer)local).members(true);
                ArrayList<IResource> childrenWithSyncBytes = new ArrayList<IResource>();
                IResource[] iResourceArray = allChildren;
                int n = allChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (this.getByteStore().getBytes(resource) != null) {
                        childrenWithSyncBytes.add(resource);
                    }
                    ++n2;
                }
                return childrenWithSyncBytes.toArray(new IResource[childrenWithSyncBytes.size()]);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
        return new IResource[0];
    }

    protected IResource[] refresh(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[] changedResources = null;
        monitor.beginTask(null, 100);
        int count = 0;
        int waitTime = 10;
        while (count < 15 && (this.isJobInFamilyRunning(ResourcesPlugin.FAMILY_AUTO_BUILD) || this.isJobInFamilyRunning(ResourcesPlugin.FAMILY_MANUAL_BUILD))) {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException interruptedException) {}
            if (++count >= 10) {
                waitTime = 1000;
            } else if (count >= 5) {
                waitTime = 100;
            }
            Policy.checkCanceled(monitor);
        }
        try {
            try {
                changedResources = super.refresh(resource, depth, Policy.subMonitorFor(monitor, 99));
            }
            catch (TeamException e) {
                if (!resource.getProject().isAccessible()) {
                    IResource[] iResourceArray = new IResource[]{};
                    monitor.done();
                    return iResourceArray;
                }
                throw e;
            }
        }
        finally {
            monitor.done();
        }
        if (changedResources == null) {
            return new IResource[0];
        }
        return changedResources;
    }

    private boolean isJobInFamilyRunning(Object family) {
        Job[] jobs = Job.getJobManager().find(family);
        if (jobs != null && jobs.length > 0) {
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getState() != 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public ICVSRemoteResource buildTree(RemoteFolderTree parent, IResource resource, boolean immutable, IProgressMonitor monitor) throws TeamException {
        Policy.checkCanceled(monitor);
        byte[] remoteBytes = this.getByteStore().getBytes(resource);
        if (remoteBytes == null) {
            return null;
        }
        if (resource.getType() == 1) {
            if (immutable) {
                remoteBytes = ResourceSyncInfo.setTag(remoteBytes, new CVSTag(ResourceSyncInfo.getRevision(remoteBytes), 2));
            }
            if (parent == null) {
                return (ICVSRemoteResource)this.getResourceVariant(resource);
            }
            return new RemoteFile((RemoteFolder)parent, remoteBytes);
        }
        RemoteFolderTree remote = RemoteFolderTree.fromBytes(parent, resource, remoteBytes);
        IResource[] members = this.members(resource);
        ArrayList<ICVSRemoteResource> children = new ArrayList<ICVSRemoteResource>();
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            ICVSRemoteResource child = this.buildTree(remote, member, immutable, monitor);
            if (child != null) {
                children.add(child);
            }
            ++n2;
        }
        remote.setChildren(children.toArray(new ICVSRemoteResource[children.size()]));
        return remote;
    }

    public boolean isCacheFileContentsHint() {
        return this.cacheFileContentsHint;
    }
}

