/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation;

import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.aggregation.AbstractColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.network.PosetAwareReceiver;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timeless.RecursiveCommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.BehaviorChangingMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.PosetAwareMailbox;

public class ColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends AbstractColumnAggregatorNode<Domain, Accumulator, AggregateResult>
implements RederivableNode,
PosetAwareReceiver {
    protected final IPosetComparator posetComparator;
    protected final boolean deleteRederiveEvaluation;
    protected final Map<Tuple, Accumulator> memory = CollectionsFactory.createMap();
    protected final Map<Tuple, Accumulator> rederivableMemory = CollectionsFactory.createMap();
    protected CommunicationGroup currentGroup;

    public ColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, boolean deleteRederiveEvaluation, TupleMask groupMask, TupleMask columnMask, IPosetComparator posetComparator) {
        super(reteContainer, operator, groupMask, columnMask);
        this.deleteRederiveEvaluation = deleteRederiveEvaluation;
        this.posetComparator = posetComparator;
        this.mailbox = this.instantiateMailbox();
    }

    public ColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, int aggregatedColumn) {
        this(reteContainer, operator, false, groupMask, TupleMask.selectSingle((int)aggregatedColumn, (int)groupMask.sourceWidth), null);
    }

    @Override
    public boolean isInDRedMode() {
        return this.deleteRederiveEvaluation;
    }

    @Override
    protected Mailbox instantiateMailbox() {
        if (this.groupMask != null && this.columnMask != null && this.posetComparator != null) {
            return new PosetAwareMailbox(this, this.reteContainer);
        }
        return new BehaviorChangingMailbox(this, this.reteContainer);
    }

    @Override
    public TupleMask getCoreMask() {
        return this.groupMask;
    }

    @Override
    public TupleMask getPosetMask() {
        return this.columnMask;
    }

    @Override
    public IPosetComparator getPosetComparator() {
        return this.posetComparator;
    }

    @Override
    public void rederiveOne() {
        Map.Entry<Tuple, Accumulator> entry = this.rederivableMemory.entrySet().iterator().next();
        Tuple group = entry.getKey();
        Accumulator accumulator = entry.getValue();
        this.rederivableMemory.remove(group);
        this.memory.put(group, accumulator);
        if (this.rederivableMemory.isEmpty()) {
            ((RecursiveCommunicationGroup)this.currentGroup).removeRederivable(this);
        }
        Object value = this.operator.getAggregate(accumulator);
        this.propagateAggregateResultUpdate(group, this.NEUTRAL, value, Timestamp.ZERO);
    }

    @Override
    public void updateWithPosetInfo(Direction direction, Tuple update, boolean monotone) {
        if (this.deleteRederiveEvaluation) {
            this.updateWithDeleteAndRederive(direction, update, monotone);
        } else {
            this.updateDefault(direction, update, Timestamp.ZERO);
        }
    }

    @Override
    public void update(Direction direction, Tuple update, Timestamp timestamp) {
        this.updateWithPosetInfo(direction, update, false);
    }

    protected void updateDefault(Direction direction, Tuple update, Timestamp timestamp) {
        Tuple key = this.groupMask.transform((ITuple)update);
        Tuple value = this.columnMask.transform((ITuple)update);
        Object aggregableValue = this.runtimeContext.unwrapElement(value.get(0));
        boolean isInsertion = direction == Direction.INSERT;
        Accumulator oldMainAccumulator = this.getMainAccumulator(key);
        Object oldValue = this.operator.getAggregate(oldMainAccumulator);
        Object newMainAccumulator = this.operator.update(oldMainAccumulator, aggregableValue, isInsertion);
        this.storeIfNotNeutral(key, newMainAccumulator, this.memory);
        Object newValue = this.operator.getAggregate(newMainAccumulator);
        this.propagateAggregateResultUpdate(key, oldValue, newValue, timestamp);
    }

    protected void updateWithDeleteAndRederive(Direction direction, Tuple update, boolean monotone) {
        Tuple group = this.groupMask.transform((ITuple)update);
        Tuple value = this.columnMask.transform((ITuple)update);
        Object aggregableValue = this.runtimeContext.unwrapElement(value.get(0));
        boolean isInsertion = direction == Direction.INSERT;
        Object oldMainAccumulator = this.memory.get(group);
        Accumulator oldRederivableAccumulator = this.rederivableMemory.get(group);
        if (direction == Direction.INSERT) {
            if (oldRederivableAccumulator != null) {
                Object newRederivableAccumulator = this.operator.update(oldRederivableAccumulator, aggregableValue, isInsertion);
                this.storeIfNotNeutral(group, newRederivableAccumulator, this.rederivableMemory);
                if (this.rederivableMemory.isEmpty()) {
                    ((RecursiveCommunicationGroup)this.currentGroup).removeRederivable(this);
                }
            } else {
                if (oldMainAccumulator == null) {
                    oldMainAccumulator = this.operator.createNeutral();
                }
                Object oldValue = this.operator.getAggregate(oldMainAccumulator);
                Object newMainAccumulator = this.operator.update(oldMainAccumulator, aggregableValue, isInsertion);
                this.storeIfNotNeutral(group, newMainAccumulator, this.memory);
                Object newValue = this.operator.getAggregate(newMainAccumulator);
                this.propagateAggregateResultUpdate(group, oldValue, newValue, Timestamp.ZERO);
            }
        } else if (oldRederivableAccumulator != null) {
            if (oldMainAccumulator != null) {
                this.issueError("[INTERNAL ERROR] Inconsistent state for " + update + " because it is present both in the main and re-derivable memory in the ColumnAggregatorNode " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), null);
            }
            try {
                Object newRederivableAccumulator = this.operator.update(oldRederivableAccumulator, aggregableValue, isInsertion);
                this.storeIfNotNeutral(group, newRederivableAccumulator, this.rederivableMemory);
                if (this.rederivableMemory.isEmpty()) {
                    ((RecursiveCommunicationGroup)this.currentGroup).removeRederivable(this);
                }
            }
            catch (NullPointerException ex) {
                this.issueError("[INTERNAL ERROR] Deleting a domain element in " + update + " which did not exist before in ColumnAggregatorNode " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), ex);
            }
        } else {
            if (oldMainAccumulator == null) {
                oldMainAccumulator = this.operator.createNeutral();
            }
            Object oldValue = this.operator.getAggregate(oldMainAccumulator);
            Object newMainAccumulator = this.operator.update(oldMainAccumulator, aggregableValue, isInsertion);
            Object newValue = this.operator.getAggregate(newMainAccumulator);
            if (monotone) {
                this.storeIfNotNeutral(group, newMainAccumulator, this.memory);
                this.propagateAggregateResultUpdate(group, oldValue, newValue, Timestamp.ZERO);
            } else {
                boolean wasEmpty = this.rederivableMemory.isEmpty();
                if (this.storeIfNotNeutral(group, newMainAccumulator, this.rederivableMemory) && wasEmpty) {
                    ((RecursiveCommunicationGroup)this.currentGroup).addRederivable(this);
                }
                this.memory.remove(group);
                this.propagateAggregateResultUpdate(group, oldValue, this.NEUTRAL, Timestamp.ZERO);
            }
        }
    }

    public void clear() {
        this.memory.clear();
        this.rederivableMemory.clear();
        this.childMailboxes.clear();
    }

    protected boolean storeIfNotNeutral(Tuple key, Accumulator accumulator, Map<Tuple, Accumulator> memory) {
        if (this.operator.isNeutral(accumulator)) {
            memory.remove(key);
            return false;
        }
        memory.put(key, accumulator);
        return true;
    }

    @Override
    public Tuple getAggregateTuple(Tuple group) {
        Accumulator accumulator = this.getMainAccumulator(group);
        Object result = this.operator.getAggregate(accumulator);
        return this.tupleFromAggregateResult(group, result);
    }

    @Override
    public AggregateResult getAggregateResult(Tuple group) {
        Accumulator accumulator = this.getMainAccumulator(group);
        return (AggregateResult)this.operator.getAggregate(accumulator);
    }

    @Override
    public Map<AggregateResult, Timeline<Timestamp>> getAggregateResultTimeline(Tuple key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Tuple, Timeline<Timestamp>> getAggregateTupleTimeline(Tuple key) {
        throw new UnsupportedOperationException();
    }

    protected Accumulator getMainAccumulator(Tuple key) {
        return this.getAccumulator(key, this.memory);
    }

    protected Accumulator getRederivableAccumulator(Tuple key) {
        return this.getAccumulator(key, this.rederivableMemory);
    }

    protected Accumulator getAccumulator(Tuple key, Map<Tuple, Accumulator> memory) {
        Accumulator accumulator = memory.get(key);
        if (accumulator == null) {
            return (Accumulator)this.operator.createNeutral();
        }
        return accumulator;
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.currentGroup;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup currentGroup) {
        this.currentGroup = currentGroup;
    }
}

