/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ide.authoring;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.core.resources.IProject;

public class AcceleoProjectState {
    private String projectName;
    private long lastStructuralBuildTime;

    public long getLaststructuralBuildTime() {
        return this.lastStructuralBuildTime;
    }

    public void setLastStructuralBuildTime(long lastStructuralBuildTime) {
        this.lastStructuralBuildTime = lastStructuralBuildTime;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.projectName);
        out.writeLong(this.lastStructuralBuildTime);
    }

    public static AcceleoProjectState read(IProject project, DataInputStream in) throws IOException {
        AcceleoProjectState newState = new AcceleoProjectState();
        newState.projectName = in.readUTF();
        if (!project.getName().equals(newState.projectName)) {
            AcceleoLogger.log((String)AcceleoCommonMessages.getString((String)"AcceleoProjectState.ProjectDoesNotMatch"), (boolean)false);
            return null;
        }
        newState.lastStructuralBuildTime = in.readLong();
        return newState;
    }
}

