/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core;

import org.eclipse.cdt.codan.internal.core.CheckersTimeStats;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class CodanCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.codan.core";
    public static final String NATURE_ID = "org.eclipse.cdt.codan.core.codanNature";
    private static CodanCorePlugin plugin;
    private static DebugTrace trace;
    private static DebugOptions debugOptions;
    private static final DebugTrace NULL_TRACE;

    static {
        NULL_TRACE = new DebugTrace(){

            public void trace(String option, String message) {
            }

            public void trace(String option, String message, Throwable error) {
            }

            public void traceDumpStack(String option) {
            }

            public void traceEntry(String option) {
            }

            public void traceEntry(String option, Object methodArgument) {
            }

            public void traceEntry(String option, Object[] methodArguments) {
            }

            public void traceExit(String option) {
            }

            public void traceExit(String option, Object result) {
            }
        };
    }

    public IEclipsePreferences getStorePreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (this.isDebuggingEnabled("/debug/performance")) {
            CheckersTimeStats.getInstance().setEnabled(true);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CodanCorePlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        CodanCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (Boolean.valueOf(System.getProperty("codan.rethrow")).booleanValue()) {
            throw new RuntimeException(e);
        }
        CodanCorePlugin.log("Internal Error", e);
    }

    public static void log(String message, Throwable e) {
        CodanCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, message, e));
    }

    public static void log(String message) {
        CodanCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, message, null));
    }

    private final boolean isDebuggingEnabled(String optionPath) {
        if (optionPath == null) {
            return true;
        }
        if (debugOptions == null) {
            CodanCorePlugin.getTrace();
        }
        if (debugOptions == null) {
            return false;
        }
        boolean debugEnabled = false;
        if (debugOptions.isDebugEnabled()) {
            String option = String.valueOf(CodanCorePlugin.getDefault().getBundle().getSymbolicName()) + optionPath;
            debugEnabled = debugOptions.getBooleanOption(option, false);
        }
        return debugEnabled;
    }

    private static synchronized DebugTrace getTrace() {
        BundleContext context;
        Bundle bundle;
        CodanCorePlugin plugin;
        if (trace == null && (plugin = CodanCorePlugin.getDefault()) != null && (bundle = plugin.getBundle()) != null && (context = bundle.getBundleContext()) != null) {
            try (ServiceTracker tracker = new ServiceTracker(context, DebugOptions.class.getName(), null);){
                tracker.open();
                debugOptions = (DebugOptions)tracker.getService();
                if (debugOptions != null) {
                    trace = debugOptions.newDebugTrace(bundle.getSymbolicName());
                }
            }
        }
        return trace != null ? trace : NULL_TRACE;
    }
}

