/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.dap;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.eclipse.cdt.debug.dap.CDTDebugElement;
import org.eclipse.cdt.debug.dap.CDTDebugProtocol;
import org.eclipse.cdt.debug.dap.DapDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;

public class MemoryBlock
extends CDTDebugElement
implements IMemoryBlockExtension {
    private ArrayList<Object> connections = new ArrayList();
    private boolean isEnabled;
    private Object context;
    private DapDebugTarget debugTarget;
    private BigInteger bigBaseAddress;
    private String expression;

    public MemoryBlock(DapDebugTarget debugTarget, String expression, BigInteger bigBaseAddress, Object context) {
        super(debugTarget);
        this.debugTarget = debugTarget;
        this.expression = expression;
        this.bigBaseAddress = bigBaseAddress;
        this.context = context;
    }

    public long getStartAddress() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public byte[] getBytes() throws DebugException {
        return new byte[0];
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
    }

    public String getExpression() {
        return this.expression;
    }

    public BigInteger getBigBaseAddress() throws DebugException {
        return this.bigBaseAddress;
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return null;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return null;
    }

    public BigInteger getBigLength() throws DebugException {
        return BigInteger.valueOf(-1L);
    }

    public int getAddressSize() throws DebugException {
        return 8;
    }

    public int getAddressableSize() throws DebugException {
        return 1;
    }

    public boolean supportBaseAddressModification() throws DebugException {
        return false;
    }

    public boolean supportsChangeManagement() {
        return false;
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
    }

    public MemoryByte[] getBytesFromOffset(BigInteger offset, long units) throws DebugException {
        return this.getBytesFromAddress(this.getBigBaseAddress().add(offset), units);
    }

    public MemoryByte[] getBytesFromAddress(BigInteger address, long units) throws DebugException {
        BigInteger bigResultAddress;
        CDTDebugProtocol.MemoryRequestArguments memoryRequestArguments = new CDTDebugProtocol.MemoryRequestArguments();
        memoryRequestArguments.setAddress("0x" + address.toString(16));
        memoryRequestArguments.setLength(units);
        CompletableFuture<CDTDebugProtocol.MemoryContents> memory = this.getDebugProtocolServer().memory(memoryRequestArguments);
        CDTDebugProtocol.MemoryContents body = (CDTDebugProtocol.MemoryContents)MemoryBlock.complete(memory);
        String resultAddress = body.getAddress();
        String contents = body.getData();
        BigInteger.valueOf(Long.decode(resultAddress));
        try {
            bigResultAddress = BigInteger.valueOf(Long.decode(resultAddress));
        }
        catch (NumberFormatException nfexc) {
            bigResultAddress = address;
        }
        int numRequestedBytes = (int)(units * (long)this.getAddressableSize());
        MemoryByte[] bytes = new MemoryByte[numRequestedBytes];
        int resultOffsetFromRequest = bigResultAddress.subtract(address).intValue();
        int i = 0;
        while (i < resultOffsetFromRequest) {
            bytes[i] = new MemoryByte(0, 0);
            ++i;
        }
        i = resultOffsetFromRequest;
        int k = 0;
        while (i < resultOffsetFromRequest + contents.length() / 2 && i < numRequestedBytes) {
            byte b = (byte)Integer.parseInt(contents.substring(k, k + 2), 16);
            bytes[i] = new MemoryByte(b);
            ++i;
            k += 2;
        }
        i = resultOffsetFromRequest + contents.length() / 2;
        while (i < numRequestedBytes) {
            bytes[i] = new MemoryByte(0, 0);
            ++i;
        }
        return bytes;
    }

    public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
    }

    public void dispose() throws DebugException {
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.debugTarget;
    }

    public void connect(Object client) {
        if (!this.connections.contains(client)) {
            this.connections.add(client);
        }
        if (this.connections.size() == 1) {
            this.enable();
        }
    }

    public void disconnect(Object client) {
        if (this.connections.contains(client)) {
            this.connections.remove(client);
        }
        if (this.connections.size() == 0) {
            this.disable();
        }
    }

    public Object[] getConnections() {
        return this.connections.toArray();
    }

    private void enable() {
        this.isEnabled = true;
    }

    private void disable() {
        this.isEnabled = false;
    }
}

