/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.id.CDOIdentifiable;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOOriginSizeProvider;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOFileResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.internal.common.commit.FailureCommitInfo;
import org.eclipse.emf.cdo.internal.common.revision.CDOListWithElementProxiesImpl;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.lock.InternalCDOLockState;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver2;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver3;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOStaleReferenceCleaner;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler3;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.transaction.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.transaction.CDOUndoDetector;
import org.eclipse.emf.cdo.transaction.CDOUserSavepoint;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.util.DanglingIntegrityException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDONotificationBuilder;
import org.eclipse.emf.internal.cdo.object.CDOObjectMerger;
import org.eclipse.emf.internal.cdo.object.CDOObjectReferenceImpl;
import org.eclipse.emf.internal.cdo.object.CDOObjectWrapper;
import org.eclipse.emf.internal.cdo.query.CDOQueryImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOSavepointImpl;
import org.eclipse.emf.internal.cdo.util.CommitIntegrityCheck;
import org.eclipse.emf.internal.cdo.util.CompletePackageClosure;
import org.eclipse.emf.internal.cdo.view.AbstractCDOView;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.Predicate;
import org.eclipse.net4j.util.Predicates;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.AbstractCloseableIterator;
import org.eclipse.net4j.util.collection.ByteArrayWrapper;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.collection.ComposedIterator;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.collection.DelegatingCloseableIterator;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.transaction.TransactionException;

public class CDOTransactionImpl
extends CDOViewImpl
implements InternalCDOTransaction {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, CDOTransactionImpl.class);
    private static final boolean X_COMPRESSION = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.transaction.X_COMPRESSION");
    private static final Method COPY_OBJECT_METHOD;
    private Object transactionHandlersLock = new Object();
    private ConcurrentArray<CDOTransactionHandler1> transactionHandlers1 = new ConcurrentArray<CDOTransactionHandler1>(){

        protected CDOTransactionHandler1[] newArray(int length) {
            return new CDOTransactionHandler1[length];
        }
    };
    private ConcurrentArray<CDOTransactionHandler2> transactionHandlers2 = new ConcurrentArray<CDOTransactionHandler2>(){

        protected CDOTransactionHandler2[] newArray(int length) {
            return new CDOTransactionHandler2[length];
        }
    };
    private InternalCDOSavepoint lastSavepoint;
    private InternalCDOSavepoint firstSavepoint = this.lastSavepoint = this.createSavepoint(null);
    private boolean dirty;
    private int conflict;
    private CDOTransactionStrategy transactionStrategy;
    private CDOIDGenerator idGenerator;
    private volatile long lastCommitTime = 0L;
    private String commitComment;
    private InternalCDOSession.CommitToken commitToken;
    private CDOBranchPoint commitMergeSource;
    private final ThreadLocal<Boolean> providingCDOID = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Set<? extends EObject> committables;
    private Map<InternalCDOObject, InternalCDORevision> cleanRevisions = new CleanRevisionsMap();

    static {
        Method cdoInternalCopyTo = null;
        try {
            cdoInternalCopyTo = ReflectUtil.getMethod(CDOObjectImpl.class, (String)"cdoInternalCopyTo", (Class[])new Class[]{CDOObjectImpl.class});
        }
        catch (Throwable ex) {
            OM.LOG.error(ex);
        }
        COPY_OBJECT_METHOD = cdoInternalCopyTo;
    }

    public CDOTransactionImpl(CDOSession session, CDOBranch branch) {
        super(session, branch, 0L);
    }

    public CDOTransactionImpl(CDOSession session, String durableLockingID) {
        super(session, durableLockingID);
    }

    @Override
    public OptionsImpl options() {
        return (OptionsImpl)super.options();
    }

    @Override
    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean setBranchPoint(CDOBranchPoint branchPoint) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            boolean bl;
            this.lockView();
            try {
                if (branchPoint.getTimeStamp() != 0L) {
                    throw new IllegalArgumentException("Changing the target time is not supported by transactions");
                }
                if (this.isDirty() && !this.getBranch().equals(branchPoint.getBranch())) {
                    throw new IllegalStateException("Changing the target branch is impossible while transaction is dirty");
                }
                bl = super.setBranchPoint(branchPoint);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactionHandler(CDOTransactionHandlerBase handler) {
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            if (handler instanceof CDOTransactionHandler1) {
                this.transactionHandlers1.add((Object)((CDOTransactionHandler1)handler));
            }
            if (handler instanceof CDOTransactionHandler2) {
                this.transactionHandlers2.add((Object)((CDOTransactionHandler2)handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionHandler(CDOTransactionHandlerBase handler) {
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            if (handler instanceof CDOTransactionHandler1) {
                this.transactionHandlers1.remove((Object)((CDOTransactionHandler1)handler));
            }
            if (handler instanceof CDOTransactionHandler2) {
                this.transactionHandlers2.remove((Object)((CDOTransactionHandler2)handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTransactionHandler[] getTransactionHandlers() {
        HashSet<CDOTransactionHandler> result = new HashSet<CDOTransactionHandler>();
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            CDOTransactionHandler2[] handlers2;
            int n;
            CDOTransactionHandler1[] handlers1 = (CDOTransactionHandler1[])this.transactionHandlers1.get();
            if (handlers1 != null) {
                CDOTransactionHandler1[] cDOTransactionHandler1Array = handlers1;
                n = handlers1.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOTransactionHandler1 handler = cDOTransactionHandler1Array[n2];
                    if (handler instanceof CDOTransactionHandler) {
                        result.add((CDOTransactionHandler)handler);
                    }
                    ++n2;
                }
            }
            if ((handlers2 = (CDOTransactionHandler2[])this.transactionHandlers2.get()) != null) {
                CDOTransactionHandler2[] cDOTransactionHandler2Array = handlers2;
                int n3 = handlers2.length;
                n = 0;
                while (n < n3) {
                    CDOTransactionHandler2 handler = cDOTransactionHandler2Array[n];
                    if (handler instanceof CDOTransactionHandler) {
                        result.add((CDOTransactionHandler)handler);
                    }
                    ++n;
                }
            }
        }
        return result.toArray(new CDOTransactionHandler[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTransactionHandler1[] getTransactionHandlers1() {
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            return (CDOTransactionHandler1[])this.transactionHandlers1.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTransactionHandler2[] getTransactionHandlers2() {
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            return (CDOTransactionHandler2[])this.transactionHandlers2.get();
        }
    }

    @Override
    public boolean isDirty() {
        if (this.isClosed()) {
            return false;
        }
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                AbstractCDOView.Event event = dirty ? new StartedEvent() : new FinishedEvent(false);
                this.fireEvent(event, listeners);
            }
        }
    }

    @Override
    public boolean hasConflict() {
        this.checkActive();
        return this.conflict > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConflict(InternalCDOObject object) {
        ConflictEvent event = null;
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                event = new ConflictEvent(object, this.conflict == 0);
                ++this.conflict;
            }
            finally {
                this.unlockView();
            }
        }
        this.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConflict(InternalCDOObject object) {
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                if (this.conflict > 0) {
                    --this.conflict;
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public Set<CDOObject> getConflicts() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            HashSet<CDOObject> hashSet;
            this.lockView();
            try {
                HashSet<CDOObject> conflicts = new HashSet<CDOObject>();
                for (CDOObject object2 : this.getDirtyObjects().values()) {
                    if (!object2.cdoConflict()) continue;
                    conflicts.add(object2);
                }
                for (CDOObject object2 : this.getDetachedObjects().values()) {
                    if (!object2.cdoConflict()) continue;
                    conflicts.add(object2);
                }
                hashSet = conflicts;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return hashSet;
        }
    }

    public CDOChangeSetData getChangeSetData() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOChangeSetData cDOChangeSetData;
            this.lockView();
            try {
                cDOChangeSetData = this.lastSavepoint.getAllChangeSetData();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOChangeSetData;
        }
    }

    @Override
    public CDOChangeSetData merge(CDOBranch source, CDOMerger merger) {
        return this.merge(source.getHead(), merger);
    }

    @Override
    public CDOChangeSetData merge(CDOBranchPoint source, CDOMerger merger) {
        return this.merge(source, CDOBranchUtil.AUTO_BRANCH_POINT, merger);
    }

    @Override
    public CDOChangeSetData merge(CDOBranchPoint source, CDOBranchPoint sourceBase, CDOMerger merger) {
        return this.merge(source, sourceBase, null, merger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOChangeSetData merge(CDOBranchPoint source, CDOBranchPoint sourceBase, CDOBranchPoint targetBase, CDOMerger merger) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOChangeSet sourceChanges;
                InternalCDOSession session;
                InternalCDOSession.MergeData mergeData;
                CDOChangeSet targetChanges;
                CDOChangeSetData result;
                if (this.isDirty()) {
                    throw new IllegalStateException("Merging into dirty transactions not yet supported");
                }
                long now = this.getLastUpdateTime();
                CDOBranchPoint target = this.getBranch().getPoint(now);
                if (source.getTimeStamp() == 0L) {
                    source = source.getBranch().getPoint(now);
                }
                if (CDOBranchUtil.isContainedBy((CDOBranchPoint)source, (CDOBranchPoint)target)) {
                    throw new IllegalArgumentException("Source is already contained in " + target);
                }
                if (sourceBase != CDOBranchUtil.AUTO_BRANCH_POINT) {
                    if (sourceBase != null && !CDOBranchUtil.isContainedBy((CDOBranchPoint)sourceBase, (CDOBranchPoint)source)) {
                        throw new IllegalArgumentException("Source base is not contained in " + source);
                    }
                    if (targetBase != null && !CDOBranchUtil.isContainedBy((CDOBranchPoint)targetBase, (CDOBranchPoint)target)) {
                        throw new IllegalArgumentException("Target base is not contained in " + target);
                    }
                }
                if ((result = merger.merge(targetChanges = (mergeData = (session = this.getSession()).getMergeData(target, source, targetBase, sourceBase, true)).getTargetChanges(), sourceChanges = mergeData.getSourceChanges())) == null) {
                    return null;
                }
                CDORevisionAvailabilityInfo targetProvider = mergeData.getTargetInfo();
                InternalCDORevisionManager revisionManager = session.getRevisionManager();
                CDOBranchPoint resultBase = mergeData.getResultBase();
                Object resultBaseProvider = resultBase != null ? new ManagedRevisionProvider((CDORevisionManager)revisionManager, resultBase) : mergeData.getTargetBaseInfo();
                InternalCDOTransaction.ApplyChangeSetResult changeSet = this.applyChangeSet(result, (CDORevisionProvider)resultBaseProvider, (CDORevisionProvider)targetProvider, source, false);
                this.commitMergeSource = source;
                CDOChangeSetData cDOChangeSetData = changeSet.getChangeSetData();
                return cDOChangeSetData;
            }
            finally {
                this.unlockView();
            }
        }
    }

    public CDOChangeSetData remerge(CDOBranchPoint source, CDOMerger merger) {
        return this.merge(source, CDOBranchUtil.AUTO_BRANCH_POINT, merger);
    }

    @Override
    @Deprecated
    public Pair<CDOChangeSetData, Pair<Map<CDOID, CDOID>, List<CDOID>>> applyChangeSetData(CDOChangeSetData changeSetData, CDORevisionProvider targetBaseProvider, CDORevisionProvider targetProvider, CDOBranchPoint source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalCDOTransaction.ApplyChangeSetResult applyChangeSet(CDOChangeSetData changeSetData, CDORevisionProvider resultBaseProvider, CDORevisionProvider targetProvider, CDOBranchPoint source, boolean keepVersions) throws InternalCDOTransaction.ChangeSetOutdatedException {
        Object object = this.getViewMonitor();
        synchronized (object) {
            InternalCDOTransaction.ApplyChangeSetResult applyChangeSetResult;
            this.lockView();
            try {
                InternalCDOTransaction.ApplyChangeSetResult result = new InternalCDOTransaction.ApplyChangeSetResult();
                if (source != null && source.getBranch().isLocal() && this.getSession().getRepositoryInfo().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
                    this.applyLocalIDMapping(changeSetData, result);
                }
                CDOChangeSetData resultData = result.getChangeSetData();
                this.applyNewObjects(changeSetData.getNewObjects(), resultData.getNewObjects());
                Set<CDOObject> detachedSet = this.applyDetachedObjects(changeSetData.getDetachedObjects(), resultData.getDetachedObjects());
                Map<CDOID, InternalCDORevision> oldRevisions = this.applyChangedObjects(changeSetData.getChangedObjects(), resultBaseProvider, targetProvider, keepVersions, resultData.getChangedObjects());
                Collection<CDORevisionDelta> notificationDeltas = this.lastSavepoint.getRevisionDeltas2().values();
                if (!notificationDeltas.isEmpty() || !detachedSet.isEmpty()) {
                    this.sendDeltaNotifications(notificationDeltas, detachedSet, oldRevisions);
                }
                applyChangeSetResult = result;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return applyChangeSetResult;
        }
    }

    private void applyLocalIDMapping(CDOChangeSetData changeSetData, InternalCDOTransaction.ApplyChangeSetResult result) {
        Map<CDOID, CDOID> idMappings = result.getIDMappings();
        for (CDOIDAndVersion key : changeSetData.getNewObjects()) {
            InternalCDORevision revision = (InternalCDORevision)key;
            if (!revision.getBranch().isLocal()) continue;
            CDOID oldID = revision.getID();
            CDOID newID = this.createIDForNewObject(null);
            idMappings.put(oldID, newID);
            revision.setID(newID);
            revision.setVersion(0);
        }
        if (!idMappings.isEmpty()) {
            CDOIDMapper idMapper = new CDOIDMapper(idMappings);
            idMapper.setAllowUnmappedTempIDs(true);
            for (CDOIDAndVersion key : changeSetData.getNewObjects()) {
                InternalCDORevision revision = (InternalCDORevision)key;
                revision.adjustReferences((CDOReferenceAdjuster)idMapper);
            }
            for (CDOIDAndVersion key : changeSetData.getChangedObjects()) {
                InternalCDORevisionDelta revisionDelta = (InternalCDORevisionDelta)key;
                if (!revisionDelta.adjustReferences((CDOReferenceAdjuster)idMapper)) continue;
                result.getAdjustedObjects().add(revisionDelta.getID());
            }
        }
    }

    private void applyNewObjects(List<CDOIDAndVersion> newObjects, List<CDOIDAndVersion> result) {
        ArrayList<InternalCDOObject> objects = new ArrayList<InternalCDOObject>();
        for (CDOIDAndVersion key : newObjects) {
            InternalCDORevision revision = (InternalCDORevision)key;
            CDOID id = revision.getID();
            if (this.getObjectIfExists(id) != null) continue;
            revision = revision.copy();
            revision.setBranchPoint(this.getBranchPoint());
            revision.setVersion(0);
            InternalCDOObject object = this.newInstance(revision.getEClass());
            object.cdoInternalSetView(this);
            object.cdoInternalSetRevision((CDORevision)revision);
            object.cdoInternalSetState(CDOState.NEW);
            objects.add(object);
            this.registerObject(object);
            result.add((CDOIDAndVersion)revision);
        }
        if (!objects.isEmpty()) {
            for (InternalCDOObject object : objects) {
                object.cdoInternalPostLoad();
                this.registerAttached(object, true);
            }
            this.setDirty(true);
        }
    }

    private Set<CDOObject> applyDetachedObjects(List<CDOIDAndVersion> detachedObjects, List<CDOIDAndVersion> result) {
        HashSet<CDOObject> detachedSet = new HashSet<CDOObject>();
        for (CDOIDAndVersion key : detachedObjects) {
            CDOID id = key.getID();
            InternalCDOObject object = this.getObjectIfExists(id);
            if (object == null) continue;
            result.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
            CDOStateMachine.INSTANCE.detach(object);
            detachedSet.add(object);
            this.setDirty(true);
        }
        return detachedSet;
    }

    private Map<CDOID, InternalCDORevision> applyChangedObjects(List<CDORevisionKey> changedObjects, CDORevisionProvider resultBaseProvider, CDORevisionProvider targetProvider, boolean keepVersions, List<CDORevisionKey> result) throws InternalCDOTransaction.ChangeSetOutdatedException {
        Map oldRevisions = CDOIDUtil.createMap();
        Map<CDOID, CDOObject> detachedObjects = this.lastSavepoint.getDetachedObjects();
        Map<CDOID, CDOObject> dirtyObjects = this.lastSavepoint.getDirtyObjects();
        Map<CDOID, CDORevisionDelta> revisionDeltas = this.lastSavepoint.getRevisionDeltas2();
        for (CDORevisionKey key : changedObjects) {
            InternalCDORevisionDelta resultBaseGoalDelta = (InternalCDORevisionDelta)key;
            resultBaseGoalDelta.setTarget(null);
            CDOID id = resultBaseGoalDelta.getID();
            InternalCDORevision resultBaseRevision = (InternalCDORevision)resultBaseProvider.getRevision(id);
            InternalCDOObject object = this.getObject(id);
            boolean revisionChanged = false;
            InternalCDORevision targetRevision = object.cdoRevision();
            if (targetRevision == null) {
                targetRevision = (InternalCDORevision)targetProvider.getRevision(id);
                object.cdoInternalSetRevision((CDORevision)targetRevision);
                revisionChanged = true;
            }
            oldRevisions.put(id, targetRevision);
            InternalCDORevision goalRevision = resultBaseRevision.copy();
            goalRevision.setBranchPoint((CDOBranchPoint)this);
            if (!keepVersions) {
                goalRevision.setVersion(targetRevision.getVersion());
            }
            goalRevision.setRevised(0L);
            resultBaseGoalDelta.applyTo((CDORevision)goalRevision);
            InternalCDORevisionDelta targetGoalDelta = goalRevision.compare((CDORevision)targetRevision);
            targetGoalDelta.setTarget(null);
            if (!targetGoalDelta.isEmpty()) {
                if (keepVersions && targetGoalDelta.getVersion() != resultBaseRevision.getVersion()) {
                    throw new InternalCDOTransaction.ChangeSetOutdatedException();
                }
                revisionDeltas.put(id, (CDORevisionDelta)targetGoalDelta);
                result.add((CDORevisionKey)targetGoalDelta);
                if (detachedObjects.containsKey(id)) {
                    CDOStateMachine.INSTANCE.internalReattach(object, this);
                }
                object.cdoInternalSetRevision((CDORevision)goalRevision);
                object.cdoInternalSetState(CDOState.DIRTY);
                revisionChanged = true;
                dirtyObjects.put(id, object);
                this.setDirty(true);
            }
            if (!revisionChanged) continue;
            object.cdoInternalPostLoad();
        }
        return oldRevisions;
    }

    private InternalCDOObject getObjectIfExists(CDOID id) {
        try {
            return this.getObject(id);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handleConflicts(long lastUpdateTime, Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, List<CDORevisionDelta> deltas) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                int resolved;
                block24: {
                    Iterator<CDOObject> iterator;
                    Iterator revision;
                    Iterator state;
                    Exception ex2;
                    CDOConflictResolver[] resolvers = this.options().getConflictResolvers();
                    if (resolvers.length == 0) {
                        return;
                    }
                    if (conflicts == null) {
                        CDOConflictResolver[] cDOConflictResolverArray = resolvers;
                        int n = resolvers.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                return;
                            }
                            CDOConflictResolver resolver = cDOConflictResolverArray[n2];
                            if (resolver instanceof CDOConflictResolver.NonConflictAware) {
                                ((CDOConflictResolver.NonConflictAware)resolver).handleNonConflict(lastUpdateTime);
                            }
                            ++n2;
                        }
                    }
                    ArrayList<CDOState> states = new ArrayList<CDOState>(conflicts.size());
                    ArrayList<CDORevision> revisions = new ArrayList<CDORevision>(conflicts.size());
                    Iterator<CDOObject> iterator2 = conflicts.keySet().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            resolved = 0;
                            try {
                                HashMap<CDOObject, Pair<CDORevision, CDORevisionDelta>> remaining = new HashMap<CDOObject, Pair<CDORevision, CDORevisionDelta>>(conflicts);
                                CDOConflictResolver[] cDOConflictResolverArray = resolvers;
                                int n = resolvers.length;
                                int n3 = 0;
                                block12: while (n3 < n) {
                                    CDOConflictResolver resolver = cDOConflictResolverArray[n3];
                                    if (resolver instanceof CDOConflictResolver2) {
                                        ((CDOConflictResolver2)resolver).resolveConflicts(Collections.unmodifiableMap(remaining), deltas);
                                    } else {
                                        resolver.resolveConflicts(Collections.unmodifiableSet(remaining.keySet()));
                                    }
                                    Iterator it = remaining.keySet().iterator();
                                    while (true) {
                                        if (!it.hasNext()) {
                                            ++n3;
                                            continue block12;
                                        }
                                        CDOObject object2 = (CDOObject)it.next();
                                        if (object2.cdoConflict()) continue;
                                        ++resolved;
                                        it.remove();
                                    }
                                }
                                break block24;
                            }
                            catch (Exception ex2) {
                                state = states.iterator();
                                revision = revisions.iterator();
                                iterator = conflicts.keySet().iterator();
                                break;
                            }
                        }
                        CDOObject conflict = iterator2.next();
                        states.add(conflict.cdoState());
                        revisions.add(conflict.cdoRevision());
                    }
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw WrappedException.wrap((Exception)ex2);
                        }
                        CDOObject object3 = iterator.next();
                        ((InternalCDOObject)object3).cdoInternalSetRevision((CDORevision)revision.next());
                        ((InternalCDOObject)object3).cdoInternalSetState((CDOState)((Object)state.next()));
                    }
                }
                this.conflict -= resolved;
                Map<CDOID, CDOObject> dirtyObjects = this.getDirtyObjects();
                this.setDirty(!dirtyObjects.isEmpty());
            }
            finally {
                this.unlockView();
            }
            return;
        }
    }

    @Override
    @Deprecated
    public CDOIDTemp getNextTemporaryID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOID createIDForNewObject(EObject object) {
        return this.idGenerator.generateCDOID(object);
    }

    @Override
    public CDOResourceFolder createResourceFolder(String path) throws CDOResourceNodeNotFoundException {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOResourceFolder cDOResourceFolder;
            this.lockView();
            try {
                if (path.endsWith(CDOURIUtil.SEGMENT_SEPARATOR)) {
                    path = path.substring(0, path.length() - 1);
                }
                CDOResourceFolder folder = EresourceFactory.eINSTANCE.createCDOResourceFolder();
                int pos = path.lastIndexOf(47);
                if (pos <= 0) {
                    String name = path.substring(pos == 0 ? 1 : 0);
                    folder.setName(name);
                    this.getRootResource().getContents().add((Object)folder);
                } else {
                    String name = path.substring(pos + 1);
                    folder.setName(name);
                    path = path.substring(0, pos);
                    CDOResourceNode parent = null;
                    try {
                        parent = this.getResourceNode(path);
                    }
                    catch (Exception ex) {
                        parent = this.createResourceFolder(path);
                    }
                    if (parent instanceof CDOResourceFolder) {
                        ((CDOResourceFolder)parent).getNodes().add((Object)folder);
                    } else {
                        throw new CDOException("Parent is not a folder: " + parent);
                    }
                }
                cDOResourceFolder = folder;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOResourceFolder;
        }
    }

    @Override
    public CDOResource createResource(String path) {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOResource cDOResource;
            this.lockView();
            try {
                URI uri = CDOURIUtil.createResourceURI(this, path);
                cDOResource = (CDOResource)this.getResourceSet().createResource(uri);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOResource;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOResource getOrCreateResource(String path) {
        this.checkActive();
        var2_2 = this.getViewMonitor();
        synchronized (var2_2) {
            this.lockView();
            try {
                id = this.getResourceNodeID(path);
                if (!CDOIDUtil.isNull((CDOID)id)) {
                    var5_5 = (CDOResource)this.getObject(id);
                    return var5_5;
                }
                ** GOTO lbl-1000
            }
            catch (CDOResourceNodeNotFoundException var3_4) lbl-1000:
            // 2 sources

            {
                var5_6 = this.createResource(path);
            }
            return var5_6;
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOTextResource createTextResource(String path) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOTextResource cDOTextResource;
            this.lockView();
            try {
                CDOTextResource resource = EresourceFactory.eINSTANCE.createCDOTextResource();
                this.createFileResource(path, resource);
                cDOTextResource = resource;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOTextResource;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOTextResource getOrCreateTextResource(String path) {
        var2_2 = this.getViewMonitor();
        synchronized (var2_2) {
            this.lockView();
            try {
                id = this.getResourceNodeID(path);
                if (!CDOIDUtil.isNull((CDOID)id)) {
                    var5_5 = (CDOTextResource)this.getObject(id);
                    return var5_5;
                }
                ** GOTO lbl-1000
            }
            catch (CDOResourceNodeNotFoundException var3_4) lbl-1000:
            // 2 sources

            {
                var5_6 = this.createTextResource(path);
            }
            return var5_6;
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOBinaryResource createBinaryResource(String path) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOBinaryResource cDOBinaryResource;
            this.lockView();
            try {
                CDOBinaryResource resource = EresourceFactory.eINSTANCE.createCDOBinaryResource();
                this.createFileResource(path, resource);
                cDOBinaryResource = resource;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOBinaryResource;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOBinaryResource getOrCreateBinaryResource(String path) {
        var2_2 = this.getViewMonitor();
        synchronized (var2_2) {
            this.lockView();
            try {
                id = this.getResourceNodeID(path);
                if (!CDOIDUtil.isNull((CDOID)id)) {
                    var5_5 = (CDOBinaryResource)this.getObject(id);
                    return var5_5;
                }
                ** GOTO lbl-1000
            }
            catch (CDOResourceNodeNotFoundException var3_4) lbl-1000:
            // 2 sources

            {
                var5_6 = this.createBinaryResource(path);
            }
            return var5_6;
            finally {
                this.unlockView();
            }
        }
    }

    private void createFileResource(String path, CDOFileResource<?> resource) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1) {
            resource.setName(path);
            this.getRootResource().getContents().add(resource);
        } else {
            resource.setName(path.substring(lastSlash + 1));
            CDOResourceFolder folder = this.getOrCreateResourceFolder(path.substring(0, lastSlash));
            folder.getNodes().add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachResource(CDOResourceImpl resource) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (resource.isExisting()) {
                    super.attachResource(resource);
                } else {
                    this.attachNewResource(resource);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    private void attachNewResource(CDOResourceImpl resource) {
        URI uri = resource.getURI();
        List<String> names = CDOURIUtil.analyzePath(uri);
        String resourceName = names.isEmpty() ? null : names.remove(names.size() - 1);
        CDOResourceFolder folder = this.getOrCreateResourceFolder(names);
        this.attachNewResourceNode(folder, resourceName, resource);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOResourceFolder getOrCreateResourceFolder(String path) {
        this.checkActive();
        var2_2 = this.getViewMonitor();
        synchronized (var2_2) {
            this.lockView();
            try {
                id = this.getResourceNodeID(path);
                if (!CDOIDUtil.isNull((CDOID)id)) {
                    var5_5 = (CDOResourceFolder)this.getObject(id);
                    return var5_5;
                }
                ** GOTO lbl-1000
            }
            catch (CDOResourceNodeNotFoundException var3_4) lbl-1000:
            // 2 sources

            {
                var5_6 = this.createResourceFolder(path);
            }
            return var5_6;
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOResourceFolder getOrCreateResourceFolder(List<String> names) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOObject cDOObject;
            this.lockView();
            try {
                CDOObject folder = null;
                for (String name : names) {
                    CDOResourceNode node;
                    try {
                        CDOID folderID = folder == null ? null : folder.cdoID();
                        node = this.getResourceNode(folderID, name);
                    }
                    catch (CDOResourceNodeNotFoundException ex) {
                        node = EresourceFactory.eINSTANCE.createCDOResourceFolder();
                        this.attachNewResourceNode((CDOResourceFolder)folder, name, node);
                    }
                    if (node instanceof CDOResourceFolder) {
                        folder = node;
                        continue;
                    }
                    throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.0"), node));
                }
                cDOObject = folder;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOObject;
        }
    }

    private void attachNewResourceNode(CDOResourceFolder folder, String name, CDOResourceNode newNode) {
        CDOResourceNodeImpl node = (CDOResourceNodeImpl)newNode;
        node.basicSetName(name, false);
        if (folder == null) {
            if (node.isRoot()) {
                CDOStateMachine.INSTANCE.attach(node, this);
            } else {
                this.getRootResource().getContents().add((Object)node);
            }
        } else {
            node.basicSetFolder(folder, false);
        }
    }

    @Override
    public InternalCDOSavepoint getFirstSavepoint() {
        return this.firstSavepoint;
    }

    @Override
    public InternalCDOSavepoint getLastSavepoint() {
        this.checkActive();
        return this.lastSavepoint;
    }

    @Override
    public CDOTransactionStrategy getTransactionStrategy() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOTransactionStrategy cDOTransactionStrategy;
            this.lockView();
            try {
                if (this.transactionStrategy == null) {
                    this.transactionStrategy = CDOTransactionStrategy.DEFAULT;
                    this.transactionStrategy.setTarget(this);
                }
                cDOTransactionStrategy = this.transactionStrategy;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOTransactionStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionStrategy(CDOTransactionStrategy transactionStrategy) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.transactionStrategy != null) {
                    this.transactionStrategy.unsetTarget(this);
                }
                this.transactionStrategy = transactionStrategy;
                if (this.transactionStrategy != null) {
                    this.transactionStrategy.setTarget(this);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected CDOID getRootOrTopLevelResourceNodeID(String name) throws CDOResourceNodeNotFoundException {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOID id;
                if (this.dirty) {
                    CDOResourceNode node = this.getRootResourceNode(name, this.getDirtyObjects().values());
                    if (node != null) {
                        CDOID cDOID = node.cdoID();
                        return cDOID;
                    }
                    node = this.getRootResourceNode(name, this.getNewObjects().values());
                    if (node != null) {
                        CDOID cDOID = node.cdoID();
                        return cDOID;
                    }
                }
                if (this.isObjectDetached(id = super.getRootOrTopLevelResourceNodeID(name)) || this.isObjectDirty(id)) {
                    throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.1"), name));
                }
                CDOID cDOID = id;
                return cDOID;
            }
            finally {
                this.unlockView();
            }
        }
    }

    private CDOResourceNode getRootResourceNode(String name, Collection<? extends CDOObject> objects) {
        for (CDOObject cDOObject : objects) {
            CDOResourceNode node;
            if (!(cDOObject instanceof CDOResourceNode) || (node = (CDOResourceNode)cDOObject).getFolder() != null || !ObjectUtil.equals((Object)name, (Object)node.getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    protected InternalCDOObject getObjectUnsynced(CDOID id, boolean loadOnDemand) {
        if (this.isObjectNew(id) && this.isObjectDetached(id)) {
            throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
        }
        return super.getObjectUnsynced(id, loadOnDemand);
    }

    @Override
    public boolean isObjectNew(CDOID id) {
        return this.lastSavepoint.isNewObject(id);
    }

    private boolean isObjectDirty(CDOID id) {
        return this.lastSavepoint.getDirtyObject(id) != null;
    }

    private boolean isObjectDetached(CDOID id) {
        return this.lastSavepoint.getDetachedObject(id) != null;
    }

    @Override
    public InternalCDOTransaction.InternalCDOCommitContext createCommitContext() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOCommitContextImpl cDOCommitContextImpl;
            this.lockView();
            try {
                cDOCommitContextImpl = new CDOCommitContextImpl(this);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOCommitContextImpl;
        }
    }

    @Override
    public CDOCommitInfo commit() throws CommitException {
        return this.commit(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOCommitInfo commit(IProgressMonitor monitor) throws CommitException {
        CDOCommitInfo info;
        CDOConflictResolver[] conflictResolvers = this.options().getConflictResolvers();
        if (conflictResolvers.length != 0) {
            try {
                this.checkActive();
                CDOConflictResolver[] cDOConflictResolverArray = conflictResolvers;
                int n = conflictResolvers.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOConflictResolver resolver = cDOConflictResolverArray[n2];
                    if (resolver instanceof CDOConflictResolver3 && !((CDOConflictResolver3)resolver).preCommit()) {
                        return null;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                throw new CommitException(ex);
            }
        }
        if ((info = this.commitSynced(monitor)) != null) {
            this.waitForCommitInfo(info.getTimeStamp());
        }
        return info;
    }

    private void waitForCommitInfo(long timeStamp) {
        long timeout = this.options().getCommitInfoTimeout();
        if (!this.waitForUpdate(timeStamp, timeout)) {
            throw new TimeoutRuntimeException("Did not receive an update: " + this);
        }
    }

    protected void waitForBaseline(long timeStamp) {
        this.waitForCommitInfo(timeStamp);
    }

    /*
     * Exception decompiling
     */
    private CDOCommitInfo commitSynced(IProgressMonitor progressMonitor) throws DanglingIntegrityException, CommitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Deprecated
    public <T> CDOTransaction.CommitResult<T> commit(Callable<T> callable, Predicate<Long> retry, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException, Exception {
        return this.commit(callable, (java.util.function.Predicate<Long>)Predicates.toJava8(retry), monitor);
    }

    @Override
    public <T> CDOTransaction.CommitResult<T> commit(final Callable<T> callable, java.util.function.Predicate<Long> retry, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException, Exception {
        final Object[] result = new Object[1];
        final Exception[] exception = new Exception[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = callable.call();
                }
                catch (Exception ex) {
                    exception[0] = ex;
                }
            }
        };
        CDOCommitInfo info = this.commit(runnable, retry, monitor);
        if (exception[0] != null) {
            throw exception[0];
        }
        if (info == null) {
            return null;
        }
        Object r = result[0];
        return new CDOTransaction.CommitResult<Object>(r, info);
    }

    @Override
    public <T> CDOTransaction.CommitResult<T> commit(Callable<T> callable, int attempts, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException, Exception {
        return this.commit(callable, (java.util.function.Predicate<Long>)new CountedRetryPredicate(attempts), monitor);
    }

    @Override
    @Deprecated
    public CDOCommitInfo commit(Runnable runnable, Predicate<Long> retry, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.commit(runnable, (java.util.function.Predicate<Long>)Predicates.toJava8(retry), monitor);
    }

    /*
     * Exception decompiling
     */
    @Override
    public CDOCommitInfo commit(Runnable runnable, java.util.function.Predicate<Long> retry, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CDOCommitInfo commit(Runnable runnable, int attempts, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.commit(runnable, (java.util.function.Predicate<Long>)new CountedRetryPredicate(attempts), monitor);
    }

    @Override
    public InternalCDOSession.CommitToken getCommitToken() {
        return this.commitToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOTransactionStrategy strategy = this.getTransactionStrategy();
                strategy.rollback(this, this.firstSavepoint);
                this.cleanUp(null);
            }
            finally {
                this.unlockView();
            }
        }
    }

    private void removeObject(CDOID id, final CDOObject object) {
        this.removeObject(id);
        if (object instanceof CDOResource) {
            InternalCDOViewSet viewSet = this.getViewSet();
            viewSet.executeWithoutNotificationHandling(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    EList resources = CDOTransactionImpl.this.getResourceSet().getResources();
                    resources.remove((Object)object);
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachObject(InternalCDOObject object) {
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                CDOTransactionHandler1[] handlers = this.getTransactionHandlers1();
                int i = 0;
                while (i < handlers.length) {
                    CDOTransactionHandler1 handler = handlers[i];
                    handler.detachingObject(this, object);
                    ++i;
                }
                CDOID id = object.cdoID();
                if (object.cdoState() == CDOState.NEW) {
                    Map<CDOID, CDOObject> map = this.lastSavepoint.getNewObjects();
                    if (map.containsKey(id)) {
                        map.remove(id);
                    } else {
                        this.lastSavepoint.getDetachedObjects().put(id, object);
                    }
                    this.deregisterObject(object);
                } else {
                    if (!this.cleanRevisions.containsKey(object)) {
                        this.cleanRevisions.put(object, object.cdoRevision());
                    }
                    this.lastSavepoint.getDetachedObjects().put(id, object);
                    this.lastSavepoint.getReattachedObjects().remove(id);
                }
                this.getUnitManager().removeObject(object);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRollback(InternalCDOSavepoint savepoint) {
        if (savepoint == null) {
            throw new IllegalArgumentException(Messages.getString("CDOTransactionImpl.3"));
        }
        if (savepoint.getTransaction() != this) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOTransactionImpl.4"), savepoint));
        }
        if (!savepoint.isValid()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOTransactionImpl.6"), savepoint));
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("handleRollback()");
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                try {
                    HashMap<CDOObject, CDORevision> oldRevisions = new HashMap<CDOObject, CDORevision>();
                    this.collectRevisions(oldRevisions, this.getDirtyObjects());
                    this.collectRevisions(oldRevisions, this.getNewObjects());
                    HashMap<CDOObject, CDORevision> newRevisions = new HashMap<CDOObject, CDORevision>();
                    Set<CDOID> idsOfNewObjectWithDeltas = this.rollbackCompletely(savepoint, newRevisions);
                    this.lastSavepoint = savepoint;
                    this.lastSavepoint.setNextSavepoint(null);
                    this.lastSavepoint.clear();
                    this.loadSavepoint(this.lastSavepoint, idsOfNewObjectWithDeltas);
                    if (this.lastSavepoint == this.firstSavepoint && this.options().isAutoReleaseLocksEnabled()) {
                        CDORepositoryInfo repositoryInfo = this.getSession().getRepositoryInfo();
                        if (this.isDurableView() && repositoryInfo.getState() == CDOCommonRepository.State.ONLINE || repositoryInfo.getType() == CDOCommonRepository.Type.MASTER) {
                            this.unlockObjects(null, null);
                        }
                    }
                    for (Map.Entry entry : oldRevisions.entrySet()) {
                        Set<CDOObject> detachedObjects;
                        CDONotificationBuilder builder;
                        NotificationChain notification;
                        InternalCDORevisionDelta delta;
                        InternalCDOObject object2 = (InternalCDOObject)entry.getKey();
                        InternalCDORevision oldRevision = (InternalCDORevision)entry.getValue();
                        InternalCDORevision newRevision = object2.cdoRevision();
                        if (newRevision == null) {
                            newRevision = (InternalCDORevision)newRevisions.get(object2);
                        }
                        if (newRevision == null && !FSMUtil.isTransient(object2)) {
                            CDOID id = oldRevision.getID();
                            newRevision = this.getRevision(id, true);
                            object2.cdoInternalSetRevision((CDORevision)newRevision);
                            object2.cdoInternalSetState(CDOState.CLEAN);
                        }
                        if (newRevision == null || (delta = newRevision.compare((CDORevision)oldRevision)).isEmpty() || (notification = (builder = new CDONotificationBuilder(this)).buildNotification(object2, oldRevision, (CDORevisionDelta)delta, detachedObjects = Collections.emptySet())) == null) continue;
                        notification.dispatch();
                    }
                    IListener[] listeners = this.getListeners();
                    if (listeners != null) {
                        this.fireEvent(new FinishedEvent(true), listeners);
                    }
                    CDOTransactionHandler2[] handlers = this.getTransactionHandlers2();
                    int i = 0;
                    while (i < handlers.length) {
                        CDOTransactionHandler2 handler = handlers[i];
                        try {
                            handler.rolledBackTransaction(this);
                        }
                        catch (RuntimeException ex) {
                            OM.LOG.error((Throwable)ex);
                        }
                        ++i;
                    }
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    private Set<CDOID> rollbackCompletely(CDOUserSavepoint savepoint, Map<CDOObject, CDORevision> newRevisions) {
        HashSet<CDOID> idsOfNewObjectsWithDeltas = new HashSet<CDOID>();
        HashSet<InternalCDOObject> newObjects = new HashSet<InternalCDOObject>();
        InternalCDOSavepoint itrSavepoint = this.lastSavepoint;
        while (itrSavepoint != null) {
            Map<CDOID, CDOObject> detachedObjectsMap;
            CDOID id;
            HashSet<Object> toBeDetached = new HashSet<Object>();
            Map<CDOID, CDOObject> newObjectsMap = itrSavepoint.getNewObjects();
            for (CDOID id2 : newObjectsMap.keySet()) {
                InternalCDOObject object = (InternalCDOObject)newObjectsMap.get(id2);
                toBeDetached.add(id2);
                toBeDetached.add(object);
                toBeDetached.add(object.cdoInternalInstance());
                this.removeObject(id2, object);
                newObjects.add(object);
            }
            Map<CDOID, CDOObject> reattachedObjectsMap = itrSavepoint.getReattachedObjects();
            Set<CDOID> detachedIDs = itrSavepoint.getDetachedObjects().keySet();
            for (CDOObject reattachedObject : reattachedObjectsMap.values()) {
                CDOID id3 = reattachedObject.cdoID();
                if (detachedIDs.contains(id3)) continue;
                InternalCDOObject internal = (InternalCDOObject)reattachedObject;
                toBeDetached.add(id3);
                toBeDetached.add(internal);
                toBeDetached.add(internal.cdoInternalInstance());
                this.removeObject(id3, internal);
                internal.cdoInternalSetView(null);
                internal.cdoInternalSetID(null);
                internal.cdoInternalSetState(CDOState.TRANSIENT);
            }
            Map<CDOID, CDORevision> attachedRevisions = this.options().getAttachedRevisionsMap();
            for (Object e : toBeDetached) {
                boolean topLevel;
                InternalCDORevision revision = null;
                if (!(e instanceof InternalCDOObject)) continue;
                InternalCDOObject object = (InternalCDOObject)e;
                id = object.cdoID();
                if (attachedRevisions != null) {
                    revision = (InternalCDORevision)attachedRevisions.get(id);
                }
                if (revision == null && (revision = object.cdoRevision()) != null) {
                    revision = revision.copy();
                }
                if (revision != null) {
                    newRevisions.put((CDOObject)e, (CDORevision)revision);
                }
                Resource.Internal directResource = object.eDirectResource();
                EObject container = object.eContainer();
                boolean bl = topLevel = !toBeDetached.contains(directResource) && !toBeDetached.contains(container);
                if (topLevel && revision != null) {
                    revision.setResourceID(null);
                    revision.setContainerID(null);
                    revision.setContainingFeatureID(0);
                }
                if (e instanceof CDOObjectImpl) {
                    CDOObjectImpl impl = (CDOObjectImpl)e;
                    if (revision != null) {
                        impl.cdoInternalSetRevision((CDORevision)revision);
                        continue;
                    }
                    if (!topLevel) continue;
                    impl.cdoInternalSetResource(null);
                    continue;
                }
                if (!(e instanceof CDOObjectWrapper)) continue;
                CDOObjectWrapper wrapper = (CDOObjectWrapper)e;
                if (revision != null) {
                    wrapper.cdoInternalRollback(revision);
                }
                if (!topLevel) continue;
                wrapper.setInstanceResource(null);
                wrapper.setInstanceContainer(null, 0);
            }
            Map<CDOID, CDORevisionDelta> map = itrSavepoint.getRevisionDeltas2();
            if (!map.isEmpty()) {
                for (CDORevisionDelta dirtyObject : map.values()) {
                    CDOID id4 = dirtyObject.getID();
                    if (!this.isObjectNew(id4)) continue;
                    idsOfNewObjectsWithDeltas.add(id4);
                }
            }
            if (!(detachedObjectsMap = itrSavepoint.getDetachedObjects()).isEmpty()) {
                for (Map.Entry<CDOID, CDOObject> detachedObjectEntry : detachedObjectsMap.entrySet()) {
                    id = detachedObjectEntry.getKey();
                    if (this.isObjectNew(id)) {
                        idsOfNewObjectsWithDeltas.add(id);
                        continue;
                    }
                    InternalCDOObject detachedObject = (InternalCDOObject)detachedObjectEntry.getValue();
                    InternalCDORevision cleanRev = this.cleanRevisions.get(detachedObject);
                    this.cleanObject(detachedObject, cleanRev);
                }
            }
            for (Map.Entry<CDOID, CDOObject> entryDirtyObject : itrSavepoint.getDirtyObjects().entrySet()) {
                id = entryDirtyObject.getKey();
                if (this.isObjectNew(id)) continue;
                InternalCDOObject internalDirtyObject = (InternalCDOObject)entryDirtyObject.getValue();
                if (reattachedObjectsMap.values().contains(internalDirtyObject)) continue;
                CDOStateMachine.INSTANCE.rollback(internalDirtyObject, this);
            }
            if (savepoint == itrSavepoint) break;
            itrSavepoint = itrSavepoint.getPreviousSavepoint();
        }
        for (InternalCDOObject internalCDOObject : newObjects) {
            if (!FSMUtil.isNew(internalCDOObject)) continue;
            CDOStateMachine.INSTANCE.rollback(internalCDOObject, this);
            internalCDOObject.cdoInternalSetID(null);
            internalCDOObject.cdoInternalSetView(null);
        }
        return idsOfNewObjectsWithDeltas;
    }

    private void loadSavepoint(CDOSavepoint savepoint, Set<CDOID> idsOfNewObjectWithDeltas) {
        InternalCDOObject object;
        Map<CDOID, CDOObject> dirtyObjects = this.getDirtyObjects();
        Map<CDOID, CDOObject> newObjMaps = this.getNewObjects();
        Map<CDOID, CDORevision> newBaseRevision = this.getBaseNewObjects();
        Map<CDOID, CDOObject> detachedObjects = this.getDetachedObjects();
        for (CDOID cDOID : idsOfNewObjectWithDeltas) {
            if (detachedObjects.containsKey(cDOID)) continue;
            object = (InternalCDOObject)newObjMaps.get(cDOID);
            CDORevision revision = newBaseRevision.get(cDOID);
            if (revision == null) continue;
            object.cdoInternalSetRevision(revision.copy());
            object.cdoInternalSetView(this);
            object.cdoInternalSetState(CDOState.NEW);
            object.cdoInternalPostLoad();
            if (super.getObject(object.cdoID(), false) != null) continue;
            this.registerObject(object);
        }
        for (Map.Entry entry : newObjMaps.entrySet()) {
            object = (InternalCDOObject)entry.getValue();
            this.cleanObject(object, object.cdoRevision());
            object.cdoInternalSetState(CDOState.NEW);
        }
        for (Map.Entry entry : dirtyObjects.entrySet()) {
            if (detachedObjects.containsKey(entry.getKey())) continue;
            InternalCDOObject internalDirtyObject = (InternalCDOObject)entry.getValue();
            this.cleanObject(internalDirtyObject, this.getRevision((CDOID)entry.getKey(), true));
        }
        CDOObjectMerger cDOObjectMerger = new CDOObjectMerger();
        InternalCDOSavepoint itrSavepoint = this.firstSavepoint;
        while (itrSavepoint != savepoint) {
            for (CDORevisionDelta delta : itrSavepoint.getRevisionDeltas2().values()) {
                CDOID id = delta.getID();
                boolean isNew = this.isObjectNew(id);
                if (isNew && !idsOfNewObjectWithDeltas.contains(id) || detachedObjects.containsKey(id)) continue;
                Map<CDOID, CDOObject> map = isNew ? newObjMaps : dirtyObjects;
                InternalCDOObject object2 = (InternalCDOObject)map.get(id);
                cDOObjectMerger.merge(object2, delta);
                object2.cdoInternalPostLoad();
            }
            itrSavepoint = itrSavepoint.getNextSavepoint();
        }
        this.dirty = savepoint.wasDirty();
    }

    private void collectRevisions(Map<CDOObject, CDORevision> revisions, Map<CDOID, CDOObject> objects) {
        for (CDOObject object : objects.values()) {
            CDORevision oldRevision = object.cdoRevision();
            if (oldRevision == null) continue;
            revisions.put(object, oldRevision);
        }
    }

    @Override
    public InternalCDOSavepoint handleSetSavepoint() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            InternalCDOSavepoint internalCDOSavepoint;
            this.lockView();
            try {
                this.addToBase(this.lastSavepoint.getNewObjects());
                internalCDOSavepoint = this.lastSavepoint = this.createSavepoint(this.lastSavepoint);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return internalCDOSavepoint;
        }
    }

    private CDOSavepointImpl createSavepoint(InternalCDOSavepoint lastSavepoint) {
        return new CDOSavepointImpl(this, lastSavepoint);
    }

    @Override
    public InternalCDOSavepoint setSavepoint() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            InternalCDOSavepoint internalCDOSavepoint;
            this.lockView();
            try {
                internalCDOSavepoint = (InternalCDOSavepoint)this.getTransactionStrategy().setSavepoint(this);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return internalCDOSavepoint;
        }
    }

    @Override
    public boolean hasMultipleSavepoints() {
        return this.lastSavepoint != this.firstSavepoint;
    }

    private void addToBase(Map<CDOID, CDOObject> objects) {
        for (CDOObject object : objects.values()) {
            ((InternalCDOObject)object).cdoInternalPreCommit();
            this.lastSavepoint.getBaseNewObjects().put(object.cdoID(), object.cdoRevision().copy());
        }
    }

    @Override
    protected String getClassName() {
        return "CDOTransaction";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAttached(InternalCDOObject object, boolean isNew) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering new object {0}", new Object[]{object});
        }
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                if (isNew) {
                    this.registerNewPackage(object.eClass().getEPackage());
                }
                CDOTransactionHandler1[] handlers = this.getTransactionHandlers1();
                int i = 0;
                while (i < handlers.length) {
                    CDOTransactionHandler1 handler = handlers[i];
                    handler.attachingObject(this, object);
                    ++i;
                }
                if (isNew) {
                    this.registerNew(this.lastSavepoint.getNewObjects(), object);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    private void registerNewPackage(EPackage ePackage) {
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        if (!packageRegistry.containsKey((Object)ePackage.getNsURI())) {
            packageRegistry.putEPackage(ePackage);
        }
    }

    private CDOOriginSizeProvider getOriginSizeProvider(InternalCDOObject object, CDOFeatureDelta featureDelta, InternalCDORevision cleanRevision) {
        EStructuralFeature feature = featureDelta.getFeature();
        if (feature.isMany()) {
            CDOList list;
            if (cleanRevision == null && (cleanRevision = this.cleanRevisions.get(object)) == null) {
                cleanRevision = object.cdoRevision();
            }
            final int originSize = (list = cleanRevision.getListOrNull(feature)) == null ? 0 : list.size();
            return new CDOOriginSizeProvider(){

                public int getOriginSize() {
                    return originSize;
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFeatureDelta(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                this.registerFeatureDelta(object, featureDelta, null);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFeatureDelta(InternalCDOObject object, CDOFeatureDelta featureDelta, InternalCDORevision cleanRevision) {
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                CDOID id = object.cdoID();
                boolean needToSaveFeatureDelta = true;
                if (object.cdoState() == CDOState.NEW) {
                    if (this.lastSavepoint.getPreviousSavepoint() == null || featureDelta == null) {
                        needToSaveFeatureDelta = false;
                    } else {
                        Map<CDOID, CDOObject> map = this.lastSavepoint.getNewObjects();
                        boolean bl = needToSaveFeatureDelta = !map.containsKey(id);
                    }
                }
                if (needToSaveFeatureDelta) {
                    Map<CDOID, CDORevisionDelta> revisionDeltas = this.lastSavepoint.getRevisionDeltas2();
                    InternalCDORevisionDelta revisionDelta = (InternalCDORevisionDelta)revisionDeltas.get(id);
                    if (revisionDelta == null) {
                        InternalCDORevision revision = object.cdoRevision();
                        revisionDelta = (InternalCDORevisionDelta)CDORevisionUtil.createDelta((CDORevision)revision);
                        revisionDeltas.put(id, (CDORevisionDelta)revisionDelta);
                    }
                    CDOOriginSizeProvider originSizeProvider = this.getOriginSizeProvider(object, featureDelta, cleanRevision);
                    revisionDelta.addFeatureDelta(featureDelta, originSizeProvider);
                }
                CDOTransactionHandler1[] handlers = this.getTransactionHandlers1();
                int i = 0;
                while (i < handlers.length) {
                    CDOTransactionHandler1 handler = handlers[i];
                    handler.modifyingObject(this, object, featureDelta);
                    ++i;
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRevisionDelta(CDORevisionDelta revisionDelta) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                Map<CDOID, CDORevisionDelta> revisionDeltas = this.lastSavepoint.getRevisionDeltas2();
                CDOID id = revisionDelta.getID();
                if (!revisionDeltas.containsKey(id)) {
                    revisionDeltas.put(id, revisionDelta);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public void registerDirty(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        this.registerDirty(object, featureDelta, null);
    }

    @Override
    public void registerDirty(InternalCDOObject object, CDOFeatureDelta featureDelta, InternalCDORevision cleanRevision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering dirty object {0}", new Object[]{object});
        }
        if (featureDelta != null) {
            this.registerFeatureDelta(object, featureDelta, cleanRevision);
        }
        this.registerNew(this.lastSavepoint.getDirtyObjects(), object);
    }

    private void registerNew(Map map, InternalCDOObject object) {
        InternalCDOObject old = map.put(object.cdoID(), object);
        if (old != null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOTransactionImpl.10"), object));
        }
        this.setDirty(true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<CDOPackageUnit> analyzeNewPackages() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
            HashSet<EPackage> usedPackages = new HashSet<EPackage>();
            HashSet<EPackage> usedNewPackages = new HashSet<EPackage>();
            for (CDOObject object2 : this.getNewObjects().values()) {
                CDOPackageUnit packageUnit;
                EPackage topLevelPackage;
                EPackage ePackage = object2.eClass().getEPackage();
                if (!usedPackages.add(ePackage) || ePackage != (topLevelPackage = EMFUtil.getTopLevelPackage((EPackage)ePackage)) && !usedPackages.add(topLevelPackage) || (packageUnit = packageRegistry.getPackageUnit(topLevelPackage)).getState() != CDOPackageUnit.State.NEW) continue;
                usedNewPackages.add(topLevelPackage);
            }
            if (usedNewPackages.size() > 0) {
                HashSet<CDOPackageUnit> result = new HashSet<CDOPackageUnit>();
                for (EPackage usedNewPackage : CDOTransactionImpl.analyzeNewPackages(usedNewPackages, (CDOPackageRegistry)packageRegistry)) {
                    CDOPackageUnit packageUnit = packageRegistry.getPackageUnit(usedNewPackage);
                    result.add(packageUnit);
                }
                ArrayList<CDOPackageUnit> arrayList = new ArrayList<CDOPackageUnit>(result);
                return arrayList;
            }
            List<CDOPackageUnit> list = Collections.emptyList();
            return list;
            finally {
                this.unlockView();
            }
        }
    }

    private static List<EPackage> analyzeNewPackages(Collection<EPackage> usedTopLevelPackages, CDOPackageRegistry packageRegistry) {
        ArrayList<EPackage> newPackages = new ArrayList<EPackage>();
        CompletePackageClosure closure = new CompletePackageClosure();
        usedTopLevelPackages = closure.calculate(usedTopLevelPackages);
        for (EPackage usedPackage : usedTopLevelPackages) {
            CDOPackageUnit packageUnit = packageRegistry.getPackageUnit(usedPackage);
            if (packageUnit == null) {
                throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.11"), usedPackage));
            }
            if (packageUnit.getState() != CDOPackageUnit.State.NEW) continue;
            newPackages.add(usedPackage);
        }
        return newPackages;
    }

    private void cleanUp(CDOCommitContext commitContext) {
        Map<CDOObject, CDOLockState> lockStates = this.getLockStates();
        if (commitContext == null || !commitContext.isPartialCommit()) {
            if (commitContext != null) {
                for (CDOObject object : commitContext.getDetachedObjects().values()) {
                    this.cleanUpLockState(lockStates, object);
                }
            }
            this.lastSavepoint = this.firstSavepoint;
            this.firstSavepoint.clear();
            this.firstSavepoint.setNextSavepoint(null);
            this.cleanRevisions.clear();
            Map<CDOID, CDORevision> attachedRevisions = this.options().getAttachedRevisionsMap();
            if (attachedRevisions != null) {
                attachedRevisions.clear();
            }
            this.dirty = false;
            this.conflict = 0;
            this.idGenerator.reset();
        } else {
            this.collapseSavepoints(commitContext);
            for (CDOObject object : commitContext.getDetachedObjects().values()) {
                this.cleanRevisions.remove(object);
                this.cleanUpLockState(lockStates, object);
            }
            for (CDOObject object : commitContext.getDirtyObjects().values()) {
                this.cleanRevisions.remove(object);
            }
        }
        this.committables = null;
    }

    private void cleanUpLockState(Map<CDOObject, CDOLockState> lockStates, CDOObject object) {
        InternalCDOLockState lockState = (InternalCDOLockState)lockStates.remove(object);
        if (lockState != null) {
            lockState.dispose();
        }
    }

    private void collapseSavepoints(CDOCommitContext commitContext) {
        CDOSavepointImpl newSavepoint = this.createSavepoint(null);
        this.copyUncommitted(this.lastSavepoint.getAllNewObjects(), commitContext.getNewObjects(), newSavepoint.getNewObjects());
        this.copyUncommitted(this.lastSavepoint.getAllDirtyObjects(), commitContext.getDirtyObjects(), newSavepoint.getDirtyObjects());
        this.copyUncommitted(this.lastSavepoint.getAllRevisionDeltas(), commitContext.getRevisionDeltas(), newSavepoint.getRevisionDeltas2());
        this.copyUncommitted(this.lastSavepoint.getAllDetachedObjects(), commitContext.getDetachedObjects(), newSavepoint.getDetachedObjects());
        this.firstSavepoint = this.lastSavepoint = newSavepoint;
    }

    private <T> void copyUncommitted(Map<CDOID, T> oldSavepointMap, Map<CDOID, T> commitContextMap, Map<CDOID, T> newSavepointMap) {
        for (Map.Entry<CDOID, T> entry : oldSavepointMap.entrySet()) {
            if (commitContextMap.containsKey(entry.getKey())) continue;
            newSavepointMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public CDOSavepoint[] exportChanges(OutputStream stream) throws IOException {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOSavepoint[] cDOSavepointArray;
            this.lockView();
            try {
                Collection<CDOObject> newObjects;
                CDODataOutputImpl out = new CDODataOutputImpl((ExtendedDataOutput)new ExtendedDataOutputStream(stream)){

                    public CDOIDProvider getIDProvider() {
                        return CDOTransactionImpl.this;
                    }

                    public CDOPackageRegistry getPackageRegistry() {
                        return CDOTransactionImpl.this.getSession().getPackageRegistry();
                    }

                    public CDORevisionUnchunker getRevisionUnchunker() {
                        return CDOTransactionImpl.this.getSession();
                    }

                    protected boolean isXCompression() {
                        return X_COMPRESSION;
                    }
                };
                ArrayList<InternalCDOSavepoint> savepoints = new ArrayList<InternalCDOSavepoint>();
                int totalNewObjects = 0;
                InternalCDOSavepoint savepoint = this.firstSavepoint;
                while (savepoint != null) {
                    newObjects = savepoint.getNewObjects().values();
                    totalNewObjects += newObjects.size();
                    savepoint = savepoint.getNextSavepoint();
                }
                out.writeXInt(totalNewObjects);
                savepoint = this.firstSavepoint;
                while (savepoint != null) {
                    newObjects = savepoint.getNewObjects().values();
                    Collection<CDORevisionDelta> revisionDeltas = savepoint.getRevisionDeltas2().values();
                    if (newObjects.isEmpty() && revisionDeltas.isEmpty()) {
                        savepoint = savepoint.getNextSavepoint();
                        continue;
                    }
                    savepoints.add(savepoint);
                    out.writeBoolean(true);
                    out.writeXInt(newObjects.size());
                    for (CDOObject newObject : newObjects) {
                        out.writeCDORevision(newObject.cdoRevision(), -1);
                    }
                    out.writeXInt(revisionDeltas.size());
                    for (CDORevisionDelta revisionDelta : revisionDeltas) {
                        out.writeCDORevisionDelta(revisionDelta);
                    }
                    savepoint = savepoint.getNextSavepoint();
                }
                out.writeBoolean(false);
                cDOSavepointArray = savepoints.toArray(new CDOSavepoint[savepoints.size()]);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOSavepointArray;
        }
    }

    @Override
    public CDOSavepoint[] importChanges(InputStream stream, boolean reconstructSavepoints) throws IOException {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOSavepoint[] cDOSavepointArray;
            this.lockView();
            try {
                ArrayList<InternalCDOSavepoint> savepoints = new ArrayList<InternalCDOSavepoint>();
                if (stream.available() > 0) {
                    CDODataInputImpl in = new CDODataInputImpl((ExtendedDataInput)new ExtendedDataInputStream(stream)){

                        public CDOPackageRegistry getPackageRegistry() {
                            return CDOTransactionImpl.this.getSession().getPackageRegistry();
                        }

                        protected CDOBranchManager getBranchManager() {
                            return CDOTransactionImpl.this.getSession().getBranchManager();
                        }

                        protected CDOCommitInfoManager getCommitInfoManager() {
                            return CDOTransactionImpl.this.getSession().getCommitInfoManager();
                        }

                        protected CDORevisionFactory getRevisionFactory() {
                            return CDOTransactionImpl.this.getSession().getRevisionManager().getFactory();
                        }

                        protected CDOLobStore getLobStore() {
                            return CDOTransactionImpl.this.getSession().getLobStore();
                        }

                        protected CDOListFactory getListFactory() {
                            return CDOListWithElementProxiesImpl.FACTORY;
                        }

                        protected boolean isXCompression() {
                            return X_COMPRESSION;
                        }
                    };
                    int totalNewObjects = in.readXInt();
                    int i = 0;
                    while (i < totalNewObjects) {
                        this.createIDForNewObject(null);
                        ++i;
                    }
                    Map idMappings = CDOIDUtil.createMap();
                    while (in.readBoolean()) {
                        InternalCDOObject object2;
                        if (reconstructSavepoints) {
                            InternalCDOSavepoint savepoint = this.setSavepoint();
                            savepoints.add(savepoint);
                        }
                        ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>();
                        this.importNewRevisions((CDODataInput)in, revisions, idMappings);
                        List<InternalCDORevisionDelta> revisionDeltas = this.importRevisionDeltas((CDODataInput)in);
                        if (!idMappings.isEmpty()) {
                            CDOIDMapper idMapper = new CDOIDMapper(idMappings);
                            for (InternalCDORevision revision : revisions) {
                                revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                            }
                            for (InternalCDORevisionDelta delta : revisionDeltas) {
                                delta.adjustReferences((CDOReferenceAdjuster)idMapper);
                            }
                        }
                        if (!revisions.isEmpty()) {
                            ArrayList<InternalCDOObject> newObjects = new ArrayList<InternalCDOObject>();
                            for (InternalCDORevision revision : revisions) {
                                object2 = this.newInstance(revision);
                                this.registerObject(object2);
                                this.registerAttached(object2, true);
                                newObjects.add(object2);
                            }
                            for (InternalCDOObject object3 : newObjects) {
                                object3.cdoInternalPostLoad();
                            }
                        }
                        CDOObjectMerger merger = new CDOObjectMerger();
                        for (InternalCDORevisionDelta delta : revisionDeltas) {
                            object2 = this.getObject(delta.getID());
                            int oldVersion = object2.cdoRevision().getVersion();
                            merger.merge(object2, (CDORevisionDelta)delta);
                            this.registerRevisionDelta((CDORevisionDelta)delta);
                            this.registerDirty(object2, null);
                            if (delta.getVersion() >= oldVersion) continue;
                            this.setConflict(object2);
                        }
                    }
                }
                cDOSavepointArray = savepoints.toArray(new CDOSavepoint[savepoints.size()]);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOSavepointArray;
        }
    }

    private void importNewRevisions(CDODataInput in, List<InternalCDORevision> revisions, Map<CDOID, CDOID> idMappings) throws IOException {
        int size = in.readXInt();
        int i = 0;
        while (i < size) {
            InternalCDORevision revision = (InternalCDORevision)in.readCDORevision(false);
            CDOID oldID = revision.getID();
            if (oldID.isTemporary()) {
                CDOID newID = this.createIDForNewObject(null);
                idMappings.put(oldID, newID);
                revision.setID(newID);
            }
            revisions.add(revision);
            ++i;
        }
    }

    private List<InternalCDORevisionDelta> importRevisionDeltas(CDODataInput in) throws IOException {
        int size = in.readXInt();
        ArrayList<InternalCDORevisionDelta> deltas = new ArrayList<InternalCDORevisionDelta>(size);
        int i = 0;
        while (i < size) {
            InternalCDORevisionDelta delta = (InternalCDORevisionDelta)in.readCDORevisionDelta();
            deltas.add(delta);
            ++i;
        }
        return deltas;
    }

    private InternalCDOObject newInstance(InternalCDORevision revision) {
        InternalCDOObject object = this.newInstance(revision.getEClass());
        object.cdoInternalSetRevision((CDORevision)revision);
        object.cdoInternalSetView(this);
        object.cdoInternalSetState(CDOState.NEW);
        return object;
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            Map<CDOID, CDOObject> map;
            this.lockView();
            try {
                map = this.lastSavepoint.getAllDirtyObjects();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return map;
        }
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            Map<CDOID, CDOObject> map;
            this.lockView();
            try {
                map = this.lastSavepoint.getAllNewObjects();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return map;
        }
    }

    public Map<CDOID, CDORevision> getBaseNewObjects() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            Map<CDOID, CDORevision> map;
            this.lockView();
            try {
                map = this.lastSavepoint.getAllBaseNewObjects();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return map;
        }
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            Map<CDOID, CDORevisionDelta> map;
            this.lockView();
            try {
                map = this.lastSavepoint.getAllRevisionDeltas();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return map;
        }
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            Map<CDOID, CDOObject> map;
            this.lockView();
            try {
                map = this.lastSavepoint.getAllDetachedObjects();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return map;
        }
    }

    @Override
    protected CloseableIterator<CDOResourceNode> queryResourcesUnsynced(CDOResourceFolder folder, final String name, final boolean exactMatch) {
        CDOState state;
        if (!this.isDirty()) {
            return super.queryResourcesUnsynced(folder, name, exactMatch);
        }
        CDOList list = null;
        if (folder == null) {
            InternalCDORevision revision;
            CDOResourceImpl rootResource = this.getRootResource();
            state = rootResource.cdoState();
            if (state.isLocal() && (revision = (InternalCDORevision)rootResource.cdoRevision()) != null) {
                list = revision.getListOrNull((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS);
            }
        } else {
            InternalCDORevision revision;
            state = folder.cdoState();
            if (state == CDOState.TRANSIENT) {
                throw new CDOException("Folder " + folder + " is transient");
            }
            if (state.isLocal() && (revision = (InternalCDORevision)folder.cdoRevision()) != null) {
                list = revision.getListOrNull((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES);
            }
        }
        if (state.isRemote()) {
            HashSet<CDOID> validIDs = null;
            ArrayList<CDOResourceNode> addedNodes = null;
            if (list != null) {
                for (Object element : list) {
                    if (element instanceof CDOResourceNode) {
                        CDOResourceNode node = (CDOResourceNode)element;
                        if (addedNodes == null) {
                            addedNodes = new ArrayList<CDOResourceNode>();
                        }
                        addedNodes.add(node);
                        continue;
                    }
                    CDOID id = (CDOID)element;
                    if (this.isObjectNew(id)) {
                        CDOResourceNode node = (CDOResourceNode)((Object)this.getObject(id));
                        addedNodes.add(node);
                        continue;
                    }
                    if (validIDs == null) {
                        validIDs = new HashSet<CDOID>();
                    }
                    validIDs.add(id);
                }
            }
            final HashSet<CDOID> finalValidIDs = validIDs;
            ArrayList<CDOResourceNode> finalAddedNodes = addedNodes;
            final CloseableIterator<CDOResourceNode> delegate = super.queryResourcesUnsynced(folder, name, exactMatch);
            return new AbstractCloseableIterator<CDOResourceNode>(finalAddedNodes){
                private Iterator<CDOResourceNode> addedNodesIterator;
                {
                    this.addedNodesIterator = list == null ? null : list.iterator();
                }

                /*
                 * Unable to fully structure code
                 */
                protected Object computeNextElement() {
                    block4: {
                        if (this.addedNodesIterator == null) break block4;
                        if (!this.isClosed()) ** GOTO lbl7
                        return 9.END_OF_DATA;
lbl-1000:
                        // 1 sources

                        {
                            node = this.addedNodesIterator.next();
                            if (!CDOTransactionImpl.isResourceMatch(node.getName(), name, exactMatch)) continue;
                            return node;
lbl7:
                            // 2 sources

                            ** while (this.addedNodesIterator.hasNext())
                        }
lbl8:
                        // 1 sources

                        this.addedNodesIterator = null;
                    }
                    if (finalValidIDs != null) {
                        while (delegate.hasNext()) {
                            node = (CDOResourceNode)delegate.next();
                            if (!finalValidIDs.contains(node.cdoID())) continue;
                            if (node.cdoState().isLocal()) {
                                if (!CDOTransactionImpl.isResourceMatch(node.getName(), name, exactMatch)) continue;
                                return node;
                            }
                            return node;
                        }
                    }
                    return 9.END_OF_DATA;
                }

                public void close() {
                    delegate.close();
                }

                public boolean isClosed() {
                    return delegate.isClosed();
                }
            };
        }
        CDOList finalList = list;
        return new AbstractCloseableIterator<CDOResourceNode>(finalList){
            private Iterator<Object> listIterator;
            {
                this.listIterator = cDOList == null ? null : cDOList.iterator();
            }

            protected Object computeNextElement() {
                if (this.listIterator != null) {
                    while (this.listIterator.hasNext()) {
                        Object element = this.listIterator.next();
                        CDOResourceNode node = this.getResourceNode(element);
                        if (!CDOTransactionImpl.isResourceMatch(node.getName(), name, exactMatch)) continue;
                        return node;
                    }
                    this.listIterator = null;
                }
                return END_OF_DATA;
            }

            private CDOResourceNode getResourceNode(Object element) {
                if (element instanceof CDOResourceNode) {
                    return (CDOResourceNode)element;
                }
                return (CDOResourceNode)((Object)CDOTransactionImpl.this.getObject((CDOID)element));
            }

            public void close() {
                this.listIterator = null;
            }

            public boolean isClosed() {
                return this.listIterator == null;
            }
        };
    }

    @Override
    protected <T extends EObject> CloseableIterator<T> queryInstancesUnsynced(final EClass type, final boolean exact) {
        if (!this.isDirty()) {
            return super.queryInstancesUnsynced(type, exact);
        }
        Map<CDOID, CDOObject> newObjects = this.lastSavepoint.getAllNewObjects();
        final CloseableIterator delegate = super.queryInstancesUnsynced(type, exact);
        return new AbstractCloseableIterator<T>(newObjects){
            private Iterator<CDOObject> newObjectsIterator;
            {
                this.newObjectsIterator = map.isEmpty() ? null : map.values().iterator();
            }

            /*
             * Unable to fully structure code
             */
            protected Object computeNextElement() {
                block2: {
                    if (this.newObjectsIterator == null) break block2;
                    if (!this.isClosed()) ** GOTO lbl7
                    return 11.END_OF_DATA;
lbl-1000:
                    // 1 sources

                    {
                        newObject = CDOUtil.getEObject(this.newObjectsIterator.next());
                        if (!(exact != false ? type == newObject.eClass() : type.isInstance((Object)newObject) != false)) continue;
                        return newObject;
lbl7:
                        // 2 sources

                        ** while (this.newObjectsIterator.hasNext())
                    }
lbl8:
                    // 1 sources

                    this.newObjectsIterator = null;
                }
                while (delegate.hasNext()) {
                    object = (EObject)delegate.next();
                    cdoObject = CDOUtil.getCDOObject(object);
                    System.out.println(cdoObject);
                    if (FSMUtil.isTransient(cdoObject)) continue;
                    return object;
                }
                return 11.END_OF_DATA;
            }

            public void close() {
                delegate.close();
            }

            public boolean isClosed() {
                return delegate.isClosed();
            }
        };
    }

    @Override
    protected CloseableIterator<CDOObjectReference> queryXRefsUnsynced(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        if (!this.isDirty()) {
            return super.queryXRefsUnsynced(targetObjects, sourceReferences);
        }
        HashSet<CDOID> targetIDs = new HashSet<CDOID>();
        Set<EReference> relevantReferences = CDOTransactionImpl.toSet(sourceReferences);
        CDOQuery query = this.createXRefsQuery(false, targetIDs, targetObjects, sourceReferences);
        if (query.getQueryString() != null) {
            final HashSet<CDOID> localIDs = new HashSet<CDOID>();
            List<CDOObjectReference> localXRefs = this.queryXRefsLocal(localIDs, targetIDs, relevantReferences);
            final CloseableIterator<CDOObjectReference> delegate = query.getResultAsync(CDOObjectReference.class);
            return new AbstractCloseableIterator<CDOObjectReference>(localXRefs){
                private Iterator<CDOObjectReference> localXRefsIterator;
                {
                    this.localXRefsIterator = list == null ? null : list.iterator();
                }

                protected Object computeNextElement() {
                    if (this.localXRefsIterator != null) {
                        if (this.isClosed()) {
                            return END_OF_DATA;
                        }
                        if (this.localXRefsIterator.hasNext()) {
                            return this.localXRefsIterator.next();
                        }
                        this.localXRefsIterator = null;
                    }
                    while (delegate.hasNext()) {
                        CDOObjectReference ref = (CDOObjectReference)delegate.next();
                        if (localIDs.contains(ref.getSourceID())) continue;
                        return ref;
                    }
                    return END_OF_DATA;
                }

                public void close() {
                    delegate.close();
                }

                public boolean isClosed() {
                    return delegate.isClosed();
                }
            };
        }
        List<CDOObjectReference> localXRefs = this.queryXRefsLocal(null, targetIDs, relevantReferences);
        if (localXRefs != null) {
            return new DelegatingCloseableIterator(localXRefs.iterator());
        }
        return AbstractCloseableIterator.emptyCloseable();
    }

    private List<CDOObjectReference> queryXRefsLocal(Set<CDOID> localIDs, Set<CDOID> targetIDs, Set<EReference> relevantReferences) {
        List<CDOObjectReference> refs = null;
        Map<CDOID, CDOObject> newObjects = this.lastSavepoint.getAllNewObjects();
        Map<CDOID, CDOObject> dirtyObjects = this.lastSavepoint.getAllDirtyObjects();
        if (localIDs != null) {
            localIDs.addAll(newObjects.keySet());
            localIDs.addAll(dirtyObjects.keySet());
            localIDs.addAll(this.lastSavepoint.getAllDetachedObjects().keySet());
        }
        ComposedIterator it = new ComposedIterator(new Iterator[]{newObjects.values().iterator(), dirtyObjects.values().iterator()});
        while (it.hasNext()) {
            CDOObject object = (CDOObject)it.next();
            InternalCDORevision revision = (InternalCDORevision)object.cdoRevision();
            EReference[] eReferenceArray = revision.getClassInfo().getAllPersistentReferences();
            int n = eReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                EReference reference = eReferenceArray[n2];
                if (!(reference.isContainer() || reference.isContainment() || relevantReferences != null && !relevantReferences.contains(reference))) {
                    if (reference.isMany()) {
                        CDOList list = revision.getListOrNull((EStructuralFeature)reference);
                        if (list != null) {
                            int index = 0;
                            for (Object value : list) {
                                refs = this.addXRefLocal(refs, targetIDs, object, reference, index, value);
                                ++index;
                            }
                        }
                    } else {
                        Object value = revision.getValue((EStructuralFeature)reference);
                        refs = this.addXRefLocal(refs, targetIDs, object, reference, 0, value);
                    }
                }
                ++n2;
            }
        }
        return refs;
    }

    private List<CDOObjectReference> addXRefLocal(List<CDOObjectReference> refs, Set<CDOID> targetIDs, CDOObject object, EReference reference, int index, Object value) {
        if (value != null && value != CDORevisionData.NIL) {
            CDOID targetID;
            CDOID cDOID = targetID = value instanceof CDOID ? (CDOID)value : this.getXRefID(CDOUtil.getCDOObject((EObject)value));
            if (!CDOIDUtil.isNull((CDOID)targetID) && targetIDs.contains(targetID)) {
                CDOIDReference delegateRef = new CDOIDReference(targetID, object.cdoID(), (EStructuralFeature)reference, index);
                CDOObjectReferenceImpl ref = new CDOObjectReferenceImpl(this, delegateRef);
                if (refs == null) {
                    refs = new ArrayList<CDOObjectReference>();
                }
                refs.add(ref);
            }
        }
        return refs;
    }

    private CDOID getXRefID(CDOObject object) {
        CDORevisionKey key;
        CDOID id = object.cdoID();
        if (id == null && (key = (CDORevisionKey)this.cleanRevisions.get(object)) != null) {
            id = key.getID();
        }
        return id;
    }

    @Override
    protected CDOID getXRefTargetID(CDOObject target) {
        CDORevisionKey key = (CDORevisionKey)this.cleanRevisions.get(target);
        if (key != null) {
            return key.getID();
        }
        return super.getXRefTargetID(target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected CDOID getID(InternalCDOObject object, boolean onlyPersistedID) {
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                CDOID revisionID;
                CDOID id = super.getID(object, onlyPersistedID);
                if (id != null) {
                    CDOID cDOID = id;
                    return cDOID;
                }
                if (this.providingCDOID.get() == Boolean.TRUE) {
                    return null;
                }
                CDORevisionKey revisionKey = (CDORevisionKey)this.cleanRevisions.get(object);
                if (revisionKey != null && this.isObjectDetached(revisionID = revisionKey.getID())) {
                    CDOID cDOID = revisionID;
                    return cDOID;
                }
                return null;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOID provideCDOID(Object idOrObject) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOID cDOID;
                try {
                    this.providingCDOID.set(Boolean.TRUE);
                    cDOID = super.provideCDOID(idOrObject);
                    this.providingCDOID.remove();
                }
                catch (Throwable throwable) {
                    this.providingCDOID.remove();
                    throw throwable;
                }
                return cDOID;
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOQueryImpl createQuery(String language, String queryString, Object context) {
        return this.createQuery(language, queryString, context, false);
    }

    @Override
    public CDOQueryImpl createQuery(String language, String queryString, boolean considerDirtyState) {
        return this.createQuery(language, queryString, null, considerDirtyState);
    }

    @Override
    public CDOQueryImpl createQuery(String language, String queryString, Object context, boolean considerDirtyState) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOQueryImpl cDOQueryImpl;
            this.lockView();
            try {
                CDOQueryImpl query = super.createQuery(language, queryString, context);
                if (considerDirtyState && this.isDirty()) {
                    query.setChangeSetData(this.getChangeSetData());
                }
                cDOQueryImpl = query;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOQueryImpl;
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        InternalCDOSession session = this.getSession();
        if (session.getRepositoryInfo().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            this.idGenerator = new TempIDGenerator();
        } else {
            this.idGenerator = session.getIDGenerator();
            if (this.idGenerator == null) {
                this.idGenerator = CDOIDGenerator.UUID;
            }
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.providingCDOID.remove();
        this.options().disposeConflictResolvers();
        this.lastSavepoint = null;
        this.firstSavepoint = null;
        this.transactionStrategy = null;
        this.idGenerator = null;
        super.doDeactivate();
    }

    @Override
    protected Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> invalidate(List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, List<CDORevisionDelta> deltas, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects, Map<CDOID, InternalCDORevision> oldRevisions) {
        InternalCDOSession session;
        if (!allDetachedObjects.isEmpty()) {
            Set<CDOObject> remotelyDetachedObjects = this.getIdentifiedObjects(allDetachedObjects);
            this.removeCrossReferences(remotelyDetachedObjects, this.getDirtyObjects().values());
            this.removeCrossReferences(remotelyDetachedObjects, this.getNewObjects().values());
            this.invalidateNewChildrenOfRemotelyDetached(remotelyDetachedObjects);
        }
        if ((session = this.getSession()).isSticky()) {
            session.clearCommittedSinceLastRefresh();
        }
        Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts = super.invalidate(allChangedObjects, allDetachedObjects, deltas, revisionDeltas, detachedObjects, oldRevisions);
        if (!allChangedObjects.isEmpty()) {
            Set<CDOObject> remotelyChangedObjects = this.getIdentifiedObjects(allChangedObjects);
            this.removeCrossReferences(this.getDetachedObjects().values(), remotelyChangedObjects);
        }
        return conflicts;
    }

    private void invalidateNewChildrenOfRemotelyDetached(Set<CDOObject> remotelyDetachedObjects) {
        for (CDOObject referencer : this.getNewObjects().values()) {
            CDOObject cdoResource;
            Resource.Internal eDirectResource;
            CDOObject containerCDOObject;
            if (!CDOUtil.isLegacyObject(referencer)) continue;
            InternalEObject referencerInternalEObject = (InternalEObject)referencer;
            InternalEObject eContainer = referencerInternalEObject.eInternalContainer();
            if (eContainer != null && remotelyDetachedObjects.contains(containerCDOObject = CDOUtil.getCDOObject((EObject)eContainer))) {
                CDOStateMachine.INSTANCE.invalidate((InternalCDOObject)referencer, (CDORevisionKey)referencer.cdoRevision());
            }
            if (!((eDirectResource = referencerInternalEObject.eDirectResource()) instanceof CDOResource) || !remotelyDetachedObjects.contains(cdoResource = (CDOObject)eDirectResource)) continue;
            CDOStateMachine.INSTANCE.invalidate((InternalCDOObject)referencer, (CDORevisionKey)referencer.cdoRevision());
        }
    }

    @Override
    protected Map<String, CDOResourceNode> collectNewResourceNodes() {
        HashMap<String, CDOResourceNode> result = new HashMap<String, CDOResourceNode>();
        for (CDOObject object : this.getNewObjects().values()) {
            if (!(object instanceof CDOResourceNode)) continue;
            CDOResourceNode node = (CDOResourceNode)object;
            String path = node.getPath();
            result.put(path, node);
        }
        return result;
    }

    private Set<CDOObject> getIdentifiedObjects(Collection<? extends CDOIdentifiable> identifiables) {
        HashSet<CDOObject> result = new HashSet<CDOObject>();
        for (CDOIdentifiable cDOIdentifiable : identifiables) {
            CDOID id = cDOIdentifiable.getID();
            InternalCDOObject object = this.getObject(id, false);
            if (object == null) continue;
            result.add(object);
        }
        return result;
    }

    private void removeCrossReferences(Collection<CDOObject> possibleTargets, Collection<CDOObject> referencers) {
        CDOStaleReferenceCleaner staleReferenceCleaner = this.options().getStaleReferenceCleaner();
        LinkedList<Pair<EStructuralFeature.Setting, EObject>> staleReferencesToClean = new LinkedList<Pair<EStructuralFeature.Setting, EObject>>();
        for (CDOObject referencer : referencers) {
            InternalCDOObject internalReferencer = (InternalCDOObject)referencer;
            InternalCDOClassInfo referencerClassInfo = internalReferencer.cdoClassInfo();
            EContentsEList.FeatureIterator<EObject> it = this.getChangeableCrossReferences(referencer);
            while (it.hasNext()) {
                EObject referencedObject = (EObject)it.next();
                CDOObject referencedCDOObject = CDOUtil.getCDOObject(referencedObject);
                if (!possibleTargets.contains(referencedCDOObject)) continue;
                EReference reference = (EReference)it.feature();
                if (referencer.cdoState() == CDOState.DIRTY && referencerClassInfo.isPersistent((EStructuralFeature)reference)) {
                    InternalCDORevision cleanRevision = this.cleanRevisions.get(referencer);
                    if (reference.isMany()) {
                        CDOList list = cleanRevision.getListOrNull((EStructuralFeature)reference);
                        if (list != null) {
                            for (Object value : list) {
                                if (value != referencedCDOObject.cdoID() && value != referencedObject) continue;
                            }
                        }
                    } else {
                        Object value = cleanRevision.getValue((EStructuralFeature)reference);
                        if (value == referencedCDOObject.cdoID() || value == referencedObject) continue;
                    }
                }
                EStructuralFeature.Setting setting = internalReferencer.eSetting((EStructuralFeature)reference);
                staleReferencesToClean.add((Pair<EStructuralFeature.Setting, EObject>)Pair.create((Object)setting, (Object)referencedObject));
            }
        }
        if (!staleReferencesToClean.isEmpty()) {
            staleReferenceCleaner.cleanStaleReferences(staleReferencesToClean);
        }
    }

    private EContentsEList.FeatureIterator<EObject> getChangeableCrossReferences(EObject object) {
        EClassImpl.FeatureSubsetSupplier features = (EClassImpl.FeatureSubsetSupplier)object.eClass().getEAllStructuralFeatures();
        EStructuralFeature[] crossReferences = features.crossReferences();
        if (crossReferences != null) {
            ArrayList<EStructuralFeature> changeableReferences = new ArrayList<EStructuralFeature>();
            int i = 0;
            while (i < crossReferences.length) {
                EStructuralFeature reference = crossReferences[i];
                if (!reference.isDerived() && reference.isChangeable()) {
                    changeableReferences.add(reference);
                }
                ++i;
            }
            if (!changeableReferences.isEmpty()) {
                EStructuralFeature[] collectedStructuralFeatures = changeableReferences.toArray(new EStructuralFeature[changeableReferences.size()]);
                return new EContentsEList.ResolvingFeatureIteratorImpl(object, collectedStructuralFeatures);
            }
        }
        return (EContentsEList.FeatureIterator)ECrossReferenceEList.emptyContentsEList().iterator();
    }

    @Override
    public long getLastCommitTime() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            long l;
            this.lockView();
            try {
                l = this.lastCommitTime;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return l;
        }
    }

    @Override
    public String getCommitComment() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            String string;
            this.lockView();
            try {
                string = this.commitComment;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommitComment(String comment) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.commitComment = comment;
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOBranchPoint getCommitMergeSource() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOBranchPoint cDOBranchPoint;
            this.lockView();
            try {
                cDOBranchPoint = this.commitMergeSource;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOBranchPoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommitMergeSource(CDOBranchPoint mergeSource) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.commitMergeSource = mergeSource;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommittables(Set<? extends EObject> committables) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.committables = committables;
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public Set<? extends EObject> getCommittables() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            Set<? extends EObject> set;
            this.lockView();
            try {
                set = this.committables;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return set;
        }
    }

    @Override
    public Map<InternalCDOObject, InternalCDORevision> getCleanRevisions() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            Map<InternalCDOObject, InternalCDORevision> map;
            this.lockView();
            try {
                map = this.cleanRevisions;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return map;
        }
    }

    @Override
    protected InternalCDORevision getViewedRevision(InternalCDOObject object) {
        InternalCDORevision cleanRev;
        InternalCDORevision rev = super.getViewedRevision(object);
        if (rev != null && (cleanRev = this.cleanRevisions.get(object)) != null) {
            return cleanRev;
        }
        return rev;
    }

    @Override
    protected InternalCDORevision getRevision(CDOObject object) {
        if (object.cdoState() == CDOState.TRANSIENT) {
            InternalCDORevision revision = this.cleanRevisions.get(object);
            if (revision == null) {
                throw new IllegalStateException("No revision for transient object " + object);
            }
            return revision;
        }
        return super.getRevision(object);
    }

    @Override
    protected InternalCDOLockState createUpdatedLockStateForNewObject(CDOObject object, IRWLockManager.LockType lockType, boolean on) {
        InternalCDOLockState lockState;
        block13: {
            CDOLockOwner lockOwner;
            block12: {
                CheckUtil.checkState((boolean)FSMUtil.isNew(object), (String)"Object is not in NEW state");
                CheckUtil.checkArg((Object)lockType, (String)"lockType");
                Map<CDOObject, CDOLockState> lockStates = this.getLockStates();
                lockState = (InternalCDOLockState)lockStates.get(object);
                if (lockState == null) {
                    CheckUtil.checkArg((boolean)on, (String)"on != true");
                    Object lockTarget = CDOTransactionImpl.getLockTarget(object);
                    lockState = (InternalCDOLockState)CDOLockUtil.createLockState((Object)lockTarget);
                } else {
                    lockState = (InternalCDOLockState)CDOLockUtil.copyLockState((CDOLockState)lockState);
                }
                lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
                if (!on) break block12;
                switch (lockType) {
                    case READ: {
                        lockState.addReadLockOwner(lockOwner);
                        break block13;
                    }
                    case WRITE: {
                        lockState.setWriteLockOwner(lockOwner);
                        break block13;
                    }
                    case OPTION: {
                        lockState.setWriteOptionOwner(lockOwner);
                        break block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown lock type " + lockType);
                    }
                }
            }
            switch (lockType) {
                case READ: {
                    lockState.removeReadLockOwner(lockOwner);
                    break;
                }
                case WRITE: {
                    lockState.setWriteLockOwner(null);
                    break;
                }
                case OPTION: {
                    lockState.setWriteOptionOwner(null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown lock type " + lockType);
                }
            }
        }
        return lockState;
    }

    protected List<CDOLockState> createUnlockedLockStatesForAllNewObjects() {
        LinkedList<CDOLockState> locksOnNewObjects = new LinkedList<CDOLockState>();
        for (CDOObject object : this.getNewObjects().values()) {
            Object lockTarget = CDOTransactionImpl.getLockTarget(object);
            CDOLockState lockState = CDOLockUtil.createLockState((Object)lockTarget);
            locksOnNewObjects.add(lockState);
        }
        return locksOnNewObjects;
    }

    public static boolean isResourceMatch(String nodeName, String name, boolean exactMatch) {
        boolean useEquals = exactMatch || nodeName == null || name == null;
        return useEquals ? ObjectUtil.equals((Object)nodeName, (Object)name) : nodeName.startsWith(name);
    }

    public static void resurrectObject(CDOObject object, CDOID id) {
        if (object.cdoState() != CDOState.NEW) {
            throw new IllegalStateException("Object is not new: " + object);
        }
        CDOID oldID = object.cdoID();
        if (oldID == id) {
            return;
        }
        InternalCDORevision revision = (InternalCDORevision)object.cdoRevision(false);
        revision.setID(id);
        InternalCDOTransaction transaction = (InternalCDOTransaction)object.cdoView();
        transaction.remapObject(oldID);
        Map<CDOID, CDOObject> newObjects = transaction.getLastSavepoint().getNewObjects();
        newObjects.remove(oldID);
        newObjects.put(id, object);
        CDORevision detachedRevision = CDOTransactionImpl.getDetachedRevision(transaction, id);
        if (detachedRevision != null) {
            revision.setVersion(detachedRevision.getVersion());
        }
    }

    private static CDORevision getDetachedRevision(InternalCDOTransaction transaction, CDOID id) {
        SyntheticCDORevision[] synthetics = new SyntheticCDORevision[1];
        InternalCDORevisionManager revisionManager = transaction.getSession().getRevisionManager();
        InternalCDORevision result = revisionManager.getRevision(id, (CDOBranchPoint)transaction, -1, 0, true, synthetics);
        if (result != null) {
            throw new IllegalStateException("An object with the same id already exists on this branch");
        }
        return synthetics[0];
    }

    @SafeVarargs
    private static <T> Set<T> toSet(T ... objects) {
        HashSet<T> result = null;
        if (objects.length != 0) {
            result = new HashSet<T>();
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                result.add(object);
                ++n2;
            }
        }
        return result;
    }

    private final class CDOCommitContextImpl
    implements InternalCDOTransaction.InternalCDOCommitContext {
        private InternalCDOTransaction transaction;
        private boolean isPartialCommit;
        private CDOCommitData commitData;
        private Map<CDOID, CDOObject> newObjects;
        private Map<CDOID, CDOObject> detachedObjects;
        private Map<CDOID, CDORevisionDelta> revisionDeltas;
        private Map<CDOID, CDOObject> dirtyObjects;
        private Map<ByteArrayWrapper, CDOLob<?>> lobs = new HashMap();
        private List<CDOLockState> locksOnNewObjects = new ArrayList<CDOLockState>();
        private List<CDOID> idsToUnlock = new ArrayList<CDOID>();

        public CDOCommitContextImpl(InternalCDOTransaction transaction) {
            this.transaction = transaction;
            this.calculateCommitData();
        }

        private void calculateCommitData() {
            OptionsImpl options = (OptionsImpl)this.transaction.options();
            List<CDOPackageUnit> newPackageUnits = CDOTransactionImpl.this.analyzeNewPackages();
            this.newObjects = this.filterCommittables(this.transaction.getNewObjects());
            this.revisionDeltas = this.filterCommittables(this.transaction.getRevisionDeltas());
            this.detachedObjects = this.filterCommittables(this.transaction.getDetachedObjects());
            this.dirtyObjects = this.filterCommittables(this.transaction.getDirtyObjects());
            ArrayList<CDORevision> revisions = new ArrayList<CDORevision>(this.newObjects.size());
            ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>(this.revisionDeltas.size());
            ArrayList<Object> detached = new ArrayList<Object>(this.detachedObjects.size());
            Map<CDOObject, CDOLockState> lockStates = CDOTransactionImpl.this.getLockStates();
            for (CDOObject cDOObject : this.newObjects.values()) {
                revisions.add(cDOObject.cdoRevision());
                CDOLockState lockState = lockStates.get(cDOObject);
                if (lockState == null || options.isEffectiveAutoReleaseLock(cDOObject)) continue;
                this.locksOnNewObjects.add(lockState);
            }
            for (CDORevisionDelta cDORevisionDelta : this.revisionDeltas.values()) {
                deltas.add(cDORevisionDelta);
            }
            for (Map.Entry entry : this.detachedObjects.entrySet()) {
                CDOObject object = (CDOObject)entry.getValue();
                InternalCDORevision cleanRevision = (InternalCDORevision)CDOTransactionImpl.this.cleanRevisions.get(object);
                if (cleanRevision == null) {
                    CDORevision revision = object.cdoRevision();
                    if (revision == null) continue;
                    detached.add(CDOIDUtil.createIDAndVersion((CDOIDAndVersion)revision));
                    continue;
                }
                if (cleanRevision.getBranch() == this.getBranch()) {
                    detached.add(CDOIDUtil.createIDAndVersion((CDOIDAndVersion)cleanRevision));
                    continue;
                }
                detached.add(cleanRevision);
            }
            for (CDOObject cDOObject : lockStates.keySet()) {
                if (FSMUtil.isTransient(cDOObject) || !options.isEffectiveAutoReleaseLock(cDOObject)) continue;
                this.idsToUnlock.add(cDOObject.cdoID());
            }
            this.commitData = CDOCommitInfoUtil.createCommitData(newPackageUnits, revisions, deltas, detached);
        }

        private <T> Map<CDOID, T> filterCommittables(Map<CDOID, T> map) {
            if (CDOTransactionImpl.this.committables == null) {
                return map;
            }
            Map newMap = CDOIDUtil.createMap();
            for (Map.Entry<CDOID, T> entry : map.entrySet()) {
                CDOID id = entry.getKey();
                InternalCDOObject o = CDOTransactionImpl.this.getObject(id);
                if (CDOTransactionImpl.this.committables.contains(o)) {
                    newMap.put(id, entry.getValue());
                    continue;
                }
                this.isPartialCommit = true;
            }
            return newMap;
        }

        @Override
        public String getUserID() {
            return this.transaction.getSession().getUserID();
        }

        @Override
        public int getViewID() {
            return this.transaction.getViewID();
        }

        @Override
        public CDOBranch getBranch() {
            return this.transaction.getBranch();
        }

        @Override
        public InternalCDOTransaction getTransaction() {
            return this.transaction;
        }

        @Override
        public boolean isPartialCommit() {
            return this.isPartialCommit;
        }

        @Override
        public String getCommitComment() {
            return this.transaction.getCommitComment();
        }

        @Override
        public CDOBranchPoint getCommitMergeSource() {
            return this.transaction.getCommitMergeSource();
        }

        @Override
        public CDOCommitData getCommitData() {
            return this.commitData;
        }

        @Override
        public Map<CDOID, CDOObject> getDirtyObjects() {
            return this.dirtyObjects;
        }

        @Override
        public Map<CDOID, CDOObject> getNewObjects() {
            return this.newObjects;
        }

        @Override
        public List<CDOPackageUnit> getNewPackageUnits() {
            return this.commitData.getNewPackageUnits();
        }

        @Override
        public Map<CDOID, CDOObject> getDetachedObjects() {
            return this.detachedObjects;
        }

        @Override
        public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
            return this.revisionDeltas;
        }

        @Override
        public Collection<CDOLob<?>> getLobs() {
            return this.lobs.values();
        }

        @Override
        @Deprecated
        public boolean isAutoReleaseLocks() {
            return this.transaction.options().isAutoReleaseLocksEnabled();
        }

        @Override
        public Collection<CDOLockState> getLocksOnNewObjects() {
            return this.locksOnNewObjects;
        }

        public List<CDOID> getIDsToUnlock() {
            return this.idsToUnlock;
        }

        @Override
        public void preCommit() {
            if (CDOTransactionImpl.this.isDirty()) {
                CDOTransactionHandler2[] handlers;
                if (TRACER.isEnabled()) {
                    TRACER.trace("commit()");
                }
                if ((handlers = CDOTransactionImpl.this.getTransactionHandlers2()).length != 0) {
                    final boolean[] modifiedAgain = new boolean[1];
                    CDODefaultTransactionHandler1 modifiedAgainHandler = new CDODefaultTransactionHandler1(){

                        @Override
                        public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureChange) {
                            modifiedAgain[0] = true;
                        }
                    };
                    CDOTransactionImpl.this.addTransactionHandler(modifiedAgainHandler);
                    try {
                        int i = 0;
                        while (i < handlers.length) {
                            modifiedAgain[0] = false;
                            CDOTransactionHandler2 handler = handlers[i];
                            handler.committingTransaction(this.getTransaction(), this);
                            if (modifiedAgain[0]) {
                                this.calculateCommitData();
                            }
                            ++i;
                        }
                    }
                    finally {
                        CDOTransactionImpl.this.removeTransactionHandler(modifiedAgainHandler);
                    }
                }
                try {
                    if (this.isPartialCommit) {
                        new CommitIntegrityCheck(this, CommitIntegrityCheck.Style.EXCEPTION_FAST).check();
                    }
                    this.preCommit(this.getNewObjects(), this.lobs);
                    this.preCommit(this.getDirtyObjects(), this.lobs);
                    if (!this.lobs.isEmpty()) {
                        CDOSessionProtocol sessionProtocol = CDOTransactionImpl.this.getSession().getSessionProtocol();
                        List<byte[]> alreadyKnown = sessionProtocol.queryLobs(ByteArrayWrapper.toByteArray(this.lobs.keySet()));
                        for (byte[] id : alreadyKnown) {
                            this.lobs.remove(new ByteArrayWrapper(id));
                        }
                    }
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            }
        }

        @Override
        public void postCommit(CDOSessionProtocol.CommitTransactionResult result) {
            try {
                IListener[] listeners;
                boolean branchChanged;
                InternalCDOSession session = CDOTransactionImpl.this.getSession();
                long timeStamp = result.getTimeStamp();
                long previousTimeStamp = result.getPreviousTimeStamp();
                boolean clearResourcePathCache = result.isClearResourcePathCache();
                if (result.getRollbackMessage() != null) {
                    InternalCDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
                    FailureCommitInfo commitInfo = new FailureCommitInfo(commitInfoManager, timeStamp, previousTimeStamp);
                    InternalCDOSession.InvalidationData invalidationData = new InternalCDOSession.InvalidationData();
                    invalidationData.setCommitInfo((CDOCommitInfo)commitInfo);
                    invalidationData.setSender(this.transaction);
                    invalidationData.setClearResourcePathCache(clearResourcePathCache);
                    invalidationData.setSecurityImpact((byte)0);
                    invalidationData.setNewPermissions(null);
                    invalidationData.setLockChangeInfo(null);
                    session.invalidate(invalidationData);
                    return;
                }
                CDOBranch oldBranch = this.getBranch();
                CDOBranch branch = result.getBranch();
                boolean bl = branchChanged = branch != this.getBranch();
                if (branchChanged) {
                    CDOTransactionImpl.this.basicSetBranchPoint(branch.getHead());
                }
                for (CDOPackageUnit newPackageUnit : this.getNewPackageUnits()) {
                    ((InternalCDOPackageUnit)newPackageUnit).setState(CDOPackageUnit.State.LOADED);
                }
                CDOLockChangeInfo unlockChangeInfo = this.makeUnlockChangeInfo(result, (CDOBranch)(branchChanged ? branch : null));
                CDOCommitInfo commitInfo = null;
                CDOProtocol.CommitData newCommitData = result.getNewCommitData();
                if (newCommitData == null) {
                    Map<CDOID, CDOObject> newObjects = this.getNewObjects();
                    this.postCommit(newObjects, result);
                    Map<CDOID, CDOObject> dirtyObjects = this.getDirtyObjects();
                    this.postCommit(dirtyObjects, result);
                    for (CDORevisionDelta delta : this.getRevisionDeltas().values()) {
                        ((InternalCDORevisionDelta)delta).adjustReferences(result.getReferenceAdjuster());
                    }
                    for (CDOID id : this.getDetachedObjects().keySet()) {
                        CDOTransactionImpl.this.removeObject(id);
                    }
                    commitInfo = this.makeCommitInfo(timeStamp, previousTimeStamp);
                    if (!commitInfo.isEmpty()) {
                        InternalCDOSession.InvalidationData sessionInvalidationData = new InternalCDOSession.InvalidationData();
                        sessionInvalidationData.setCommitInfo(commitInfo);
                        sessionInvalidationData.setSender(this.transaction);
                        sessionInvalidationData.setClearResourcePathCache(clearResourcePathCache);
                        sessionInvalidationData.setSecurityImpact(result.getSecurityImpact());
                        sessionInvalidationData.setNewPermissions(result.getNewPermissions());
                        sessionInvalidationData.setLockChangeInfo(unlockChangeInfo);
                        session.invalidate(sessionInvalidationData);
                    } else {
                        CDOLockState[] newLockStates = result.getNewLockStates();
                        if (newLockStates != null) {
                            CDOLockChangeInfo lockChangeInfo = CDOTransactionImpl.this.makeLockChangeInfo(CDOLockChangeInfo.Operation.UNLOCK, null, result.getTimeStamp(), newLockStates);
                            session.handleLockNotification(lockChangeInfo, this.transaction, true);
                        }
                    }
                    if (session.isSticky()) {
                        CDOBranchPoint commitBranchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)result);
                        for (CDOObject object : newObjects.values()) {
                            session.setCommittedSinceLastRefresh(object.cdoID(), commitBranchPoint);
                        }
                        for (CDOID id : dirtyObjects.keySet()) {
                            session.setCommittedSinceLastRefresh(id, commitBranchPoint);
                        }
                        for (CDOID id : this.getDetachedObjects().keySet()) {
                            session.setCommittedSinceLastRefresh(id, commitBranchPoint);
                        }
                    }
                } else {
                    this.applyNewCommitData(newCommitData, result.getIDMappings(), timeStamp);
                }
                CDOTransactionHandler2[] handlers = CDOTransactionImpl.this.getTransactionHandlers2();
                int i = 0;
                while (i < handlers.length) {
                    CDOTransactionHandler2 handler = handlers[i];
                    if (handler instanceof CDOTransactionHandler3) {
                        CDOTransactionHandler3 handler3 = (CDOTransactionHandler3)handler;
                        handler3.committedTransaction(this.transaction, this, commitInfo);
                    } else {
                        handler.committedTransaction(this.transaction, this);
                    }
                    ++i;
                }
                CDOTransactionImpl.this.getChangeSubscriptionManager().committedTransaction(this.transaction, this);
                CDOTransactionImpl.this.getAdapterManager().committedTransaction(this.transaction, this);
                if (newCommitData == null) {
                    CDOTransactionImpl.this.cleanUp(this);
                }
                if ((listeners = CDOTransactionImpl.this.getListeners()) != null) {
                    if (branchChanged) {
                        CDOTransactionImpl.this.fireViewTargetChangedEvent(oldBranch.getHead(), listeners);
                    }
                    Map<CDOID, CDOID> idMappings = result.getIDMappings();
                    CDOTransactionImpl.this.fireEvent(new FinishedEvent(idMappings), listeners);
                }
                if (unlockChangeInfo != null && CDOTransactionImpl.this.isActive()) {
                    CDOTransactionImpl.this.fireLocksChangedEvent(CDOTransactionImpl.this, unlockChangeInfo);
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new TransactionException((Throwable)ex);
            }
        }

        private CDOCommitInfo makeCommitInfo(long timeStamp, long previousTimeStamp) {
            InternalCDOSession session = CDOTransactionImpl.this.getSession();
            CDOBranch branch = this.getBranch();
            String userID = session.getUserID();
            String comment = this.getCommitComment();
            CDOBranchPoint mergeSource = this.getCommitMergeSource();
            InternalCDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            return commitInfoManager.createCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, mergeSource, this.commitData);
        }

        private CDOLockChangeInfo makeUnlockChangeInfo(CDOSessionProtocol.CommitTransactionResult result, CDOBranch newBranch) {
            Map<CDOObject, CDOLockState> lockStates = CDOTransactionImpl.this.getLockStates();
            if (lockStates.isEmpty()) {
                return null;
            }
            ArrayList<InternalCDOLockState> objectsToUnlock = new ArrayList<InternalCDOLockState>();
            HashMap<CDOObject, InternalCDOLockState> newLockStates = new HashMap<CDOObject, InternalCDOLockState>();
            Map<CDOID, CDOID> idMappings = result.getIDMappings();
            for (Map.Entry<CDOObject, CDOLockState> entry : lockStates.entrySet()) {
                CDOObject object = entry.getKey();
                InternalCDOLockState lockState = (InternalCDOLockState)entry.getValue();
                Object lockedObject = lockState.getLockedObject();
                if (lockedObject instanceof CDOID) {
                    CDOID id = (CDOID)lockedObject;
                    CDOID newID = idMappings.get(id);
                    if (newID == null) {
                        newID = id;
                    }
                    if (newID != id) {
                        lockState = (InternalCDOLockState)CDOLockUtil.copyLockState((CDOLockState)lockState, (Object)newID);
                        newLockStates.put(object, lockState);
                    }
                } else {
                    CDOIDAndBranch idAndBranch = (CDOIDAndBranch)lockedObject;
                    CDOID id = idAndBranch.getID();
                    CDOBranch branch = idAndBranch.getBranch();
                    CDOID newID = idMappings.get(id);
                    if (newID == null) {
                        newID = id;
                    }
                    if (newID != id || newBranch != null && newBranch != branch) {
                        CDOIDAndBranch newLockedObject = CDOIDUtil.createIDAndBranch((CDOID)newID, (CDOBranch)(newBranch != null ? newBranch : branch));
                        lockState = (InternalCDOLockState)CDOLockUtil.copyLockState((CDOLockState)lockState, (Object)newLockedObject);
                        newLockStates.put(object, lockState);
                    }
                }
                if (!CDOTransactionImpl.this.options().isEffectiveAutoReleaseLock(object)) continue;
                lockState.dispose();
                objectsToUnlock.add(lockState);
            }
            lockStates.putAll(newLockStates);
            CDOLockState[] array = objectsToUnlock.toArray(new CDOLockState[objectsToUnlock.size()]);
            return CDOTransactionImpl.this.makeLockChangeInfo(CDOLockChangeInfo.Operation.UNLOCK, null, result.getTimeStamp(), array);
        }

        private void preCommit(Map<CDOID, CDOObject> objects, Map<ByteArrayWrapper, CDOLob<?>> lobs) {
            if (!objects.isEmpty()) {
                for (CDOObject object : objects.values()) {
                    this.collectLobs((InternalCDORevision)object.cdoRevision(), lobs);
                    ((InternalCDOObject)object).cdoInternalPreCommit();
                }
            }
        }

        private void collectLobs(InternalCDORevision revision, Map<ByteArrayWrapper, CDOLob<?>> lobs) {
            EStructuralFeature[] features = revision.getClassInfo().getAllPersistentFeatures();
            int i = 0;
            while (i < features.length) {
                CDOLob lob;
                EStructuralFeature feature = features[i];
                if (CDOModelUtil.isLob((EClassifier)feature.getEType()) && (lob = (CDOLob)revision.getValue(feature)) != null) {
                    lobs.put(new ByteArrayWrapper(lob.getID()), lob);
                }
                ++i;
            }
        }

        private void postCommit(Map<CDOID, CDOObject> objects, CDOSessionProtocol.CommitTransactionResult result) {
            if (!objects.isEmpty()) {
                CDOStateMachine.INSTANCE.commit(objects, result);
            }
        }

        private void applyNewCommitData(CDOProtocol.CommitData newCommitData, Map<CDOID, CDOID> idMappings, long timeStamp) {
            Map rememberedNewObjects = CDOIDUtil.createMap();
            rememberedNewObjects.putAll(this.newObjects);
            CDOTransactionImpl.this.bypassRegistrationHandlers(() -> {
                CDOTransactionImpl.this.getTransactionStrategy().rollback(this.transaction, CDOTransactionImpl.this.firstSavepoint);
                CDOTransactionImpl.this.waitForBaseline(timeStamp);
                Map objects = CDOTransactionImpl.this.getModifiableObjects();
                for (Map.Entry entry : rememberedNewObjects.entrySet()) {
                    CDOID tempID;
                    CDOID permID;
                    InternalCDOObject rememberedNewObject = (InternalCDOObject)entry.getValue();
                    if (!(rememberedNewObject instanceof CDOObjectImpl) || (permID = (CDOID)idMappings.get(tempID = (CDOID)entry.getKey())) == null) continue;
                    CDOObjectImpl object = (CDOObjectImpl)CDOTransactionImpl.this.getObject(permID);
                    ReflectUtil.invokeMethod((Method)COPY_OBJECT_METHOD, (Object)object, (Object[])new Object[]{rememberedNewObject});
                    objects.put(permID, rememberedNewObject);
                }
            });
        }
    }

    private final class CleanRevisionsMap
    extends HashMap<InternalCDOObject, InternalCDORevision> {
        private static final long serialVersionUID = 1L;

        @Override
        public InternalCDORevision get(Object key) {
            if (key instanceof EObject) {
                CDOObject cdoObject = CDOUtil.getCDOObject((EObject)key);
                InternalCDORevision revision = (InternalCDORevision)super.get(cdoObject);
                if (revision != null) {
                    CDOTransactionImpl.this.getSession().resolveAllElementProxies((CDORevision)revision);
                }
                return revision;
            }
            return null;
        }

        @Override
        public InternalCDORevision remove(Object key) {
            if (key instanceof EObject) {
                CDOObject cdoObject = CDOUtil.getCDOObject((EObject)key);
                return (InternalCDORevision)super.remove(cdoObject);
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof EObject) {
                CDOObject cdoObject = CDOUtil.getCDOObject((EObject)key);
                return super.containsKey(cdoObject);
            }
            return false;
        }

        @Override
        public Set<InternalCDOObject> keySet() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ConflictEvent
    extends AbstractCDOView.Event
    implements CDOTransactionConflictEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOObject conflictingObject;
        private boolean firstConflict;

        public ConflictEvent(InternalCDOObject conflictingObject, boolean firstConflict) {
            this.conflictingObject = conflictingObject;
            this.firstConflict = firstConflict;
        }

        @Override
        public InternalCDOObject getConflictingObject() {
            return this.conflictingObject;
        }

        @Override
        public boolean isFirstConflict() {
            return this.firstConflict;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionConflictEvent[source={0}, conflictingObject={1}, firstConflict={2}]", this.getSource(), this.getConflictingObject(), this.isFirstConflict());
        }
    }

    private static final class CountedRetryPredicate
    implements java.util.function.Predicate<Long> {
        private final int attempts;
        private int attempt;

        private CountedRetryPredicate(int attempts) {
            this.attempts = attempts;
        }

        @Override
        public boolean test(Long startMillis) {
            return ++this.attempt < this.attempts;
        }
    }

    private final class FinishedEvent
    extends AbstractCDOView.Event
    implements CDOTransactionFinishedEvent {
        private static final long serialVersionUID = 1L;
        private final CDOTransactionFinishedEvent.Cause cause;
        private final Map<CDOID, CDOID> idMappings;

        private FinishedEvent(Map<CDOID, CDOID> idMappings) {
            this.cause = CDOTransactionFinishedEvent.Cause.COMMITTED;
            this.idMappings = idMappings;
        }

        private FinishedEvent(boolean rolledBack) {
            this.cause = rolledBack ? CDOTransactionFinishedEvent.Cause.ROLLED_BACK : CDOTransactionFinishedEvent.Cause.UNDONE;
            this.idMappings = Collections.emptyMap();
        }

        @Override
        @Deprecated
        public CDOTransactionFinishedEvent.Type getType() {
            switch (this.cause) {
                case COMMITTED: {
                    return CDOTransactionFinishedEvent.Type.COMMITTED;
                }
                case ROLLED_BACK: 
                case UNDONE: {
                    return CDOTransactionFinishedEvent.Type.ROLLED_BACK;
                }
            }
            throw new IllegalStateException("Illegal cause: " + (Object)((Object)this.cause));
        }

        @Override
        public CDOTransactionFinishedEvent.Cause getCause() {
            return this.cause;
        }

        @Override
        public Map<CDOID, CDOID> getIDMappings() {
            return this.idMappings;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionFinishedEvent[source={0}, cause={1}, idMappings={2}]", new Object[]{this.getSource(), this.getCause(), this.idMappings == null ? 0 : this.idMappings.size()});
        }
    }

    protected final class OptionsImpl
    extends CDOViewImpl.OptionsImpl
    implements CDOTransaction.Options {
        private CDOUndoDetector undoDetector = DEFAULT_UNDO_DETECTOR;
        private final List<CDOConflictResolver> conflictResolvers = new ArrayList<CDOConflictResolver>();
        private CDOStaleReferenceCleaner staleReferenceCleaner = CDOStaleReferenceCleaner.DEFAULT;
        private boolean autoReleaseLocksEnabled = true;
        private final Map<EObject, Boolean> autoReleaseLocksExemptions = new WeakHashMap<EObject, Boolean>();
        private long commitInfoTimeout = 60000L;
        private Map<CDOID, CDORevision> attachedRevisionsMap;

        @Override
        public CDOUndoDetector getUndoDetector() {
            return this.undoDetector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUndoDetector(CDOUndoDetector undoDetector) {
            CDOTransactionImpl.this.checkActive();
            if (undoDetector == null) {
                undoDetector = DEFAULT_UNDO_DETECTOR;
            }
            UndoDetectorEventImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    if (this.undoDetector != undoDetector) {
                        this.undoDetector = undoDetector;
                        event = new UndoDetectorEventImpl();
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDOTransactionImpl getContainer() {
            return (CDOTransactionImpl)super.getContainer();
        }

        @Override
        public CDOConflictResolver[] getConflictResolvers() {
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOConflictResolver[] cDOConflictResolverArray;
                CDOTransactionImpl.this.lockView();
                try {
                    cDOConflictResolverArray = this.conflictResolvers.toArray(new CDOConflictResolver[this.conflictResolvers.size()]);
                }
                catch (Throwable throwable) {
                    CDOTransactionImpl.this.unlockView();
                    throw throwable;
                }
                CDOTransactionImpl.this.unlockView();
                return cDOConflictResolverArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setConflictResolvers(CDOConflictResolver[] resolvers) {
            CDOTransactionImpl.this.checkActive();
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    for (CDOConflictResolver resolver : this.conflictResolvers) {
                        resolver.setTransaction(null);
                    }
                    this.conflictResolvers.clear();
                    CDOConflictResolver[] cDOConflictResolverArray = resolvers;
                    int n = resolvers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CDOConflictResolver resolver;
                        resolver = cDOConflictResolverArray[n2];
                        this.validateResolver(resolver);
                        this.conflictResolvers.add(resolver);
                        ++n2;
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)new ConflictResolversEventImpl());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConflictResolver(CDOConflictResolver resolver) {
            CDOTransactionImpl.this.checkActive();
            ConflictResolversEventImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    this.validateResolver(resolver);
                    this.conflictResolvers.add(resolver);
                    event = new ConflictResolversEventImpl();
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeConflictResolver(CDOConflictResolver resolver) {
            CDOTransactionImpl.this.checkActive();
            ConflictResolversEventImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    if (this.conflictResolvers.remove(resolver)) {
                        resolver.setTransaction(null);
                        event = new ConflictResolversEventImpl();
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDOStaleReferenceCleaner getStaleReferenceCleaner() {
            return this.staleReferenceCleaner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStaleReferenceCleaner(CDOStaleReferenceCleaner staleReferenceCleaner) {
            CDOTransactionImpl.this.checkActive();
            if (staleReferenceCleaner == null) {
                staleReferenceCleaner = CDOStaleReferenceCleaner.DEFAULT;
            }
            StaleReferenceCleanerEventImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    if (this.staleReferenceCleaner != staleReferenceCleaner) {
                        this.staleReferenceCleaner = staleReferenceCleaner;
                        event = new StaleReferenceCleanerEventImpl();
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        public void disposeConflictResolvers() {
            try {
                CDOConflictResolver[] array;
                CDOConflictResolver[] cDOConflictResolverArray = array = this.conflictResolvers.toArray(new CDOConflictResolver[this.conflictResolvers.size()]);
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOConflictResolver resolver = cDOConflictResolverArray[n2];
                    try {
                        resolver.setTransaction(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void validateResolver(CDOConflictResolver resolver) {
            if (resolver.getTransaction() != null) {
                throw new IllegalArgumentException(Messages.getString("CDOTransactionImpl.17"));
            }
            resolver.setTransaction(CDOTransactionImpl.this);
        }

        @Override
        public boolean isAutoReleaseLocksEnabled() {
            return this.autoReleaseLocksEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAutoReleaseLocksEnabled(boolean on) {
            CDOTransactionImpl.this.checkActive();
            AutoReleaseLocksEnabledEventImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    if (this.autoReleaseLocksEnabled != on) {
                        this.autoReleaseLocksEnabled = on;
                        event = new AutoReleaseLocksEnabledEventImpl();
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public Set<? extends EObject> getAutoReleaseLocksExemptions() {
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                HashSet<EObject> hashSet;
                CDOTransactionImpl.this.lockView();
                try {
                    hashSet = new HashSet<EObject>(this.autoReleaseLocksExemptions.keySet());
                }
                catch (Throwable throwable) {
                    CDOTransactionImpl.this.unlockView();
                    throw throwable;
                }
                CDOTransactionImpl.this.unlockView();
                return hashSet;
            }
        }

        @Override
        public boolean isAutoReleaseLocksExemption(EObject object) {
            Object object2 = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object2) {
                boolean bl;
                CDOTransactionImpl.this.lockView();
                try {
                    bl = this.autoReleaseLocksExemptions.get(CDOUtil.getCDOObject(object)) == Boolean.TRUE;
                }
                catch (Throwable throwable) {
                    CDOTransactionImpl.this.unlockView();
                    throw throwable;
                }
                CDOTransactionImpl.this.unlockView();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAutoReleaseLocksExemptions() {
            CDOTransactionImpl.this.checkActive();
            AutoReleaseLocksExemptionsEventImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    if (!this.autoReleaseLocksExemptions.isEmpty()) {
                        this.autoReleaseLocksExemptions.clear();
                        event = new AutoReleaseLocksExemptionsEventImpl();
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addAutoReleaseLocksExemptions(boolean recursive, EObject ... objects) {
            CDOTransactionImpl.this.checkActive();
            AutoReleaseLocksExemptionsEventImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    EObject[] eObjectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EObject object2 = eObjectArray[n2];
                        if (this.autoReleaseLocksExemptions.put(CDOUtil.getCDOObject(object2), Boolean.TRUE) == null) {
                            event = new AutoReleaseLocksExemptionsEventImpl();
                        }
                        if (recursive) {
                            TreeIterator it = object2.eAllContents();
                            while (it.hasNext()) {
                                EObject child = (EObject)it.next();
                                if (this.autoReleaseLocksExemptions.put(CDOUtil.getCDOObject(child), Boolean.TRUE) != null || event != null) continue;
                                event = new AutoReleaseLocksExemptionsEventImpl();
                            }
                        }
                        ++n2;
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAutoReleaseLocksExemptions(boolean recursive, EObject ... objects) {
            CDOTransactionImpl.this.checkActive();
            AutoReleaseLocksExemptionsEventImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    EObject[] eObjectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EObject object2 = eObjectArray[n2];
                        if (this.autoReleaseLocksExemptions.remove(CDOUtil.getCDOObject(object2)) != null) {
                            event = new AutoReleaseLocksExemptionsEventImpl();
                        }
                        if (recursive) {
                            TreeIterator it = object2.eAllContents();
                            while (it.hasNext()) {
                                EObject child = (EObject)it.next();
                                if (this.autoReleaseLocksExemptions.remove(CDOUtil.getCDOObject(child)) == null || event != null) continue;
                                event = new AutoReleaseLocksExemptionsEventImpl();
                            }
                        }
                        ++n2;
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        public boolean isEffectiveAutoReleaseLock(CDOObject newObject) {
            boolean effectiveAutoReleaseLock = this.autoReleaseLocksEnabled;
            if (this.autoReleaseLocksExemptions.containsKey(newObject)) {
                effectiveAutoReleaseLock = !effectiveAutoReleaseLock;
            }
            return effectiveAutoReleaseLock;
        }

        @Override
        public Map<CDOID, CDORevision> getAttachedRevisionsMap() {
            return this.attachedRevisionsMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttachedRevisionsMap(Map<CDOID, CDORevision> attachedRevisionsMap) {
            CDOTransactionImpl.this.checkActive();
            AttachedRevisionsMapImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    if (this.attachedRevisionsMap != attachedRevisionsMap) {
                        this.attachedRevisionsMap = attachedRevisionsMap;
                        event = new AttachedRevisionsMapImpl();
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public long getCommitInfoTimeout() {
            return this.commitInfoTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCommitInfoTimeout(long commitInfoTimeout) {
            CDOTransactionImpl.this.checkActive();
            CommitInfoTimeoutImpl event = null;
            Object object = CDOTransactionImpl.this.getViewMonitor();
            synchronized (object) {
                CDOTransactionImpl.this.lockView();
                try {
                    if (this.commitInfoTimeout != commitInfoTimeout) {
                        this.commitInfoTimeout = commitInfoTimeout;
                        event = new CommitInfoTimeoutImpl();
                    }
                }
                finally {
                    CDOTransactionImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        private final class AttachedRevisionsMapImpl
        extends OptionsEvent
        implements CDOTransaction.Options.AttachedRevisionsMap {
            private static final long serialVersionUID = 1L;

            public AttachedRevisionsMapImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class AutoReleaseLocksEnabledEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.AutoReleaseLocksEvent.AutoReleaseLocksEnabledEvent {
            private static final long serialVersionUID = 1L;

            public AutoReleaseLocksEnabledEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class AutoReleaseLocksExemptionsEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.AutoReleaseLocksEvent.AutoReleaseLocksExemptionsEvent {
            private static final long serialVersionUID = 1L;

            public AutoReleaseLocksExemptionsEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class CommitInfoTimeoutImpl
        extends OptionsEvent
        implements CDOTransaction.Options.CommitInfoTimeout {
            private static final long serialVersionUID = 1L;

            public CommitInfoTimeoutImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ConflictResolversEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.ConflictResolversEvent {
            private static final long serialVersionUID = 1L;

            public ConflictResolversEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class StaleReferenceCleanerEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.StaleReferenceCleanerEvent {
            private static final long serialVersionUID = 1L;

            public StaleReferenceCleanerEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class UndoDetectorEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.UndoDetectorEvent {
            private static final long serialVersionUID = 1L;

            public UndoDetectorEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    private final class StartedEvent
    extends AbstractCDOView.Event
    implements CDOTransactionStartedEvent {
        private static final long serialVersionUID = 1L;

        private StartedEvent() {
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionStartedEvent[source={0}]", this.getSource());
        }
    }

    private static final class TempIDGenerator
    implements CDOIDGenerator {
        private AtomicInteger lastTemporaryID = new AtomicInteger();

        public CDOID generateCDOID(EObject object) {
            return CDOIDUtil.createTempObject((int)this.lastTemporaryID.incrementAndGet());
        }

        public void reset() {
            this.lastTemporaryID.set(0);
        }
    }
}

