/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.m2e.editor.xml.MvnImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.ui.views.contentoutline.XMLContentOutlineConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PomContentOutlineConfiguration
extends XMLContentOutlineConfiguration {
    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        return new PomLabelProvider(super.getLabelProvider(viewer));
    }

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        if (viewer == null || viewer.getTree().isDisposed()) {
            return new IContributionItem[0];
        }
        return super.createMenuContributions(viewer);
    }

    private final class PomLabelProvider
    implements ILabelProvider {
        private static final String TARGET_PATH = "targetPath";
        private static final String DIRECTORY = "directory";
        private static final String REPORT_SET = "reportSet";
        private static final String PROPERTIES = "properties";
        private static final String REPORTING = "reporting";
        private static final String BUILD = "build";
        private static final String EXCLUDE = "exclude";
        private static final String INCLUDE = "include";
        private static final String FILTER = "filter";
        private static final String TEST_RESOURCE = "testResource";
        private static final String RESOURCE = "resource";
        private static final String TEST_RESOURCES = "testResources";
        private static final String RESOURCES = "resources";
        private static final String GOAL = "goal";
        private static final String EXECUTION = "execution";
        private static final String PLUGIN = "plugin";
        private static final String PLUGINS = "plugins";
        private static final String SNAPSHOT_REPOSITORY = "snapshotRepository";
        private static final String PLUGIN_REPOSITORY = "pluginRepository";
        private static final String REPOSITORY = "repository";
        private static final String SITE = "site";
        private static final String CONTRIBUTOR = "contributor";
        private static final String DEVELOPER = "developer";
        private static final String PROFILE = "profile";
        private static final String PROFILES = "profiles";
        private static final String MODULE = "module";
        private static final String EXTENSION = "extension";
        private static final String EXCLUSION = "exclusion";
        private static final String MODULES = "modules";
        private static final String EXTENSIONS = "extensions";
        private static final String EXCLUSIONS = "exclusions";
        private static final String DEPENDENCIES = "dependencies";
        private static final String PARENT = "parent";
        private static final String SCOPE = "scope";
        private static final String TYPE = "type";
        private static final String CLASSIFIER = "classifier";
        private static final String DEPENDENCY = "dependency";
        private static final String ID = "id";
        private static final String EMAIL = "email";
        private static final String NAME = "name";
        private static final String VERSION = "version";
        private static final String GROUP_ID = "groupId";
        private static final String ARTIFACT_ID = "artifactId";
        private static final String NAMESPACE_POM = "http://maven.apache.org/POM/4.0.0";
        private static final int MAX_LABEL_LENGTH = 120;
        private final ILabelProvider labelProvider;

        private PomLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public Image getImage(Object element) {
            Node node = (Node)element;
            String namespace = node.getNamespaceURI();
            String nodeName = node.getNodeName();
            if (node.getNodeType() == 8) {
                return this.labelProvider.getImage(element);
            }
            if (NAMESPACE_POM.equals(namespace)) {
                if (PARENT.equals(nodeName)) {
                    return MvnImages.IMG_JAR;
                }
                if (DEPENDENCIES.equals(nodeName) || EXCLUSIONS.equals(nodeName) || EXTENSIONS.equals(nodeName) || MODULES.equals(nodeName)) {
                    return MvnImages.IMG_JARS;
                }
                if (DEPENDENCY.equals(nodeName) || EXCLUSION.equals(nodeName) || EXTENSION.equals(nodeName) || MODULE.equals(nodeName)) {
                    return MvnImages.IMG_JAR;
                }
                if (REPOSITORY.equals(nodeName) || PLUGIN_REPOSITORY.equals(nodeName) || SNAPSHOT_REPOSITORY.equals(nodeName) || SITE.equals(nodeName)) {
                    return MvnImages.IMG_REPOSITORY;
                }
                if (PROFILES.equals(nodeName)) {
                    return MvnImages.IMG_PROFILES;
                }
                if (PROFILE.equals(nodeName)) {
                    return MvnImages.IMG_PROFILE;
                }
                if (DEVELOPER.equals(nodeName) || CONTRIBUTOR.equals(nodeName)) {
                    return MvnImages.IMG_PERSON;
                }
                if (PLUGINS.equals(nodeName)) {
                    return MvnImages.IMG_PLUGINS;
                }
                if (PLUGIN.equals(nodeName)) {
                    return MvnImages.IMG_PLUGIN;
                }
                if (EXECUTION.equals(nodeName)) {
                    return MvnImages.IMG_EXECUTION;
                }
                if (GOAL.equals(nodeName)) {
                    return MvnImages.IMG_GOAL;
                }
                if (RESOURCES.equals(nodeName) || TEST_RESOURCES.equals(nodeName)) {
                    return MvnImages.IMG_RESOURCES;
                }
                if (RESOURCE.equals(nodeName) || TEST_RESOURCE.equals(nodeName)) {
                    return MvnImages.IMG_RESOURCE;
                }
                if (FILTER.equals(nodeName)) {
                    return MvnImages.IMG_FILTER;
                }
                if (INCLUDE.equals(nodeName)) {
                    return MvnImages.IMG_INCLUDE;
                }
                if (EXCLUDE.equals(nodeName)) {
                    return MvnImages.IMG_EXCLUDE;
                }
                if (BUILD.equals(nodeName)) {
                    return MvnImages.IMG_BUILD;
                }
                if (REPORTING.equals(nodeName)) {
                    return MvnImages.IMG_REPORT;
                }
                if (PROPERTIES.equals(nodeName)) {
                    return MvnImages.IMG_PROPERTIES;
                }
                if (PROPERTIES.equals(node.getParentNode().getNodeName())) {
                    return MvnImages.IMG_PROPERTY;
                }
                return MvnImages.IMG_ELEMENT;
            }
            return this.labelProvider.getImage(element);
        }

        public String getText(Object element) {
            String text = this.labelProvider.getText(element);
            Node node = (Node)element;
            String namespace = node.getNamespaceURI();
            String nodeName = node.getNodeName();
            if (node.getNodeType() == 8) {
                return this.cleanText(node);
            }
            if (NAMESPACE_POM.equals(namespace)) {
                String nodeText;
                Node item;
                short nodeType;
                if (PARENT.equals(nodeName)) {
                    return this.getLabel(text, node, GROUP_ID, ARTIFACT_ID, VERSION);
                }
                if (DEPENDENCY.equals(nodeName)) {
                    return this.getLabel(text, node, GROUP_ID, ARTIFACT_ID, VERSION, CLASSIFIER, TYPE, SCOPE);
                }
                if (EXCLUSION.equals(nodeName)) {
                    return this.getLabel(text, node, GROUP_ID, ARTIFACT_ID);
                }
                if (EXTENSION.equals(nodeName)) {
                    return this.getLabel(text, node, GROUP_ID, ARTIFACT_ID, VERSION);
                }
                if (REPOSITORY.equals(nodeName) || PLUGIN_REPOSITORY.equals(nodeName) || SNAPSHOT_REPOSITORY.equals(nodeName) || SITE.equals(nodeName) || PROFILE.equals(nodeName) || EXECUTION.equals(nodeName)) {
                    return this.getLabel(text, node, ID);
                }
                if ("mailingList".equals(nodeName)) {
                    return this.getLabel(text, node, NAME);
                }
                if (DEVELOPER.equals(nodeName)) {
                    return this.getLabel(text, node, ID, NAME, EMAIL);
                }
                if (CONTRIBUTOR.equals(nodeName)) {
                    return this.getLabel(text, node, NAME, EMAIL);
                }
                if (PLUGIN.equals(nodeName)) {
                    return this.getLabel(text, node, GROUP_ID, ARTIFACT_ID, VERSION);
                }
                if (RESOURCE.equals(nodeName) || TEST_RESOURCE.equals(nodeName)) {
                    return this.getLabel(text, node, DIRECTORY, TARGET_PATH);
                }
                if (REPORT_SET.equals(nodeName)) {
                    return this.getLabel(text, node, ID);
                }
                if (EXECUTION.equals(nodeName)) {
                    return this.getLabel(text, node, ID);
                }
                NodeList childNodes = node.getChildNodes();
                if (childNodes.getLength() == 1 && ((nodeType = (item = childNodes.item(0)).getNodeType()) == 3 || nodeType == 8) && (nodeText = item.getNodeValue()).length() > 0) {
                    return String.valueOf(text) + "  " + this.cleanText(item);
                }
            }
            return text;
        }

        public boolean isLabelProperty(Object element, String name) {
            return this.labelProvider.isLabelProperty(element, name);
        }

        public void addListener(ILabelProviderListener listener) {
            this.labelProvider.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.labelProvider.removeListener(listener);
        }

        public void dispose() {
            this.labelProvider.dispose();
        }

        private String getLabel(String text, Node node, String ... names) {
            StringBuilder sb = new StringBuilder(text).append("  ");
            String sep = "";
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String value = this.getValue(node, name);
                if (value != null) {
                    sb.append(sep).append(value);
                    sep = " : ";
                }
                ++n2;
            }
            return sb.toString();
        }

        private String getValue(Node node, String name) {
            String val = XmlUtils.getTextValue((Node)XmlUtils.findChild((Element)((Element)node), (String)name));
            if (val != null && val.trim().length() == 0) {
                val = null;
            }
            return val;
        }

        private String cleanText(Node node) {
            String value = node.getNodeValue();
            if (value == null) {
                return "";
            }
            if ((value = value.replaceAll("\\s", " ").replaceAll("(\\s){2,}", " ").trim()).length() > 120) {
                value = String.valueOf(value.substring(0, 120)) + "...";
            }
            return value;
        }
    }
}

