/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.util.Scheduler;

public class GlazedListsFilterRowComboBoxDataProvider<T>
extends FilterRowComboBoxDataProvider<T>
implements ListEventListener<T> {
    private static final Log LOG = LogFactory.getLog(GlazedListsFilterRowComboBoxDataProvider.class);
    private static final Scheduler SCHEDULER = new Scheduler("GlazedListsFilterRowComboBoxDataProvider");
    private AtomicBoolean changeHandlingProcessing = new AtomicBoolean(false);

    public GlazedListsFilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor) {
        this(bodyLayer, baseCollection, columnAccessor, true);
    }

    public GlazedListsFilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor, boolean lazy) {
        super(bodyLayer, baseCollection, columnAccessor, lazy);
        if (baseCollection instanceof EventList) {
            ((EventList)baseCollection).addListEventListener((ListEventListener)this);
        } else {
            LOG.error((Object)"baseCollection is not of type EventList. List changes can not be tracked.");
        }
    }

    public void listChanged(ListEvent<T> listChanges) {
        if (!this.changeHandlingProcessing.getAndSet(true)) {
            SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    HashMap cacheBefore = new HashMap(GlazedListsFilterRowComboBoxDataProvider.this.getValueCache());
                    GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().clear();
                    if (!GlazedListsFilterRowComboBoxDataProvider.this.lazyLoading) {
                        GlazedListsFilterRowComboBoxDataProvider.this.buildValueCache();
                    }
                    for (Map.Entry entry : cacheBefore.entrySet()) {
                        if (GlazedListsFilterRowComboBoxDataProvider.this.lazyLoading) {
                            GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().put((Integer)entry.getKey(), GlazedListsFilterRowComboBoxDataProvider.this.collectValues((Integer)entry.getKey()));
                        }
                        GlazedListsFilterRowComboBoxDataProvider.this.fireCacheUpdateEvent(GlazedListsFilterRowComboBoxDataProvider.this.buildUpdateEvent((Integer)entry.getKey(), (List)entry.getValue(), (List)GlazedListsFilterRowComboBoxDataProvider.this.getValueCache().get(entry.getKey())));
                    }
                    GlazedListsFilterRowComboBoxDataProvider.this.changeHandlingProcessing.set(false);
                }
            }, 100L);
        }
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof CellVisualChangeEvent) {
            int column = ((CellVisualChangeEvent)event).getColumnPosition();
            List cacheBefore = (List)this.getValueCache().get(column);
            this.getValueCache().put(column, this.collectValues(column));
            this.fireCacheUpdateEvent(this.buildUpdateEvent(column, cacheBefore, (List)this.getValueCache().get(column)));
        }
    }

    public void dispose() {
        super.dispose();
        SCHEDULER.shutdownNow();
    }
}

