/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.celleditor.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.emf.nattable.dataprovider.EEnumComboBoxDataProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.celleditor.MultiLineTextCellEditorEx;
import org.eclipse.papyrus.infra.nattable.celleditor.config.AbstractCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.painter.CustomCheckBoxPainter;

@Deprecated
public class EStructuralFeatureEditorConfig
extends AbstractCellEditorConfiguration {
    public static final String EDITOR_CONFIG_ID = "EMF_EDITOR";
    public static final int UNKNOWN_TYPE = -1;
    public static final int SINGLE_BOOLEAN = 1;
    public static final int MULTI_BOOLEAN = 2;
    public static final int SINGLE_STRING = 3;
    public static final int MULTI_STRING = 4;
    public static final int SINGLE_INTEGER = 5;
    public static final int MULTI_INTEGER = 6;
    public static final int SINGLE_EENUM_TYPE = 7;
    public static final int MULTI_EENUM_TYPE = 8;
    public static final int SINGLE_EMF_REFERENCE = 9;
    public static final int MULTI_EMF_REFERENCE = 10;

    public ICellEditor getICellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {
        int editorKind = this.getFeatureIdentifier(table, axisElement);
        TextCellEditor editor = null;
        switch (editorKind) {
            case 3: {
                editor = new MultiLineTextCellEditorEx(true);
                break;
            }
            case 5: {
                editor = new TextCellEditor();
                break;
            }
            case 1: {
                editor = new CheckBoxCellEditor();
                break;
            }
            case 7: {
                editor = new ComboBoxCellEditor((IComboBoxDataProvider)new EEnumComboBoxDataProvider((EEnum)((EStructuralFeature)axisElement).getEType()));
                break;
            }
        }
        return editor;
    }

    public String getEditorConfigId() {
        return EDITOR_CONFIG_ID;
    }

    protected IComboBoxDataProvider getComboDataProvider(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {
        return null;
    }

    public IDisplayConverter getDisplayConvert(Table table, Object axisElement, final ILabelProvider provider) {
        int editorKind = this.getFeatureIdentifier(table, axisElement);
        Object displayConverter = null;
        switch (editorKind) {
            case 1: {
                displayConverter = new DefaultBooleanDisplayConverter();
                break;
            }
            case 5: {
                displayConverter = new DefaultIntegerDisplayConverter();
                break;
            }
            case 7: {
                displayConverter = new DisplayConverter(){

                    public Object displayToCanonicalValue(Object displayValue) {
                        return null;
                    }

                    public Object canonicalToDisplayValue(Object canonicalValue) {
                        return provider.getText(canonicalValue);
                    }
                };
                break;
            }
        }
        return displayConverter;
    }

    public ICellPainter getCellPainter(Table table, Object axisElement) {
        int editorKind = this.getFeatureIdentifier(table, axisElement);
        CustomCheckBoxPainter cellPainter = null;
        switch (editorKind) {
            case 1: {
                cellPainter = new CustomCheckBoxPainter();
                break;
            }
            case 7: {
                cellPainter = new ComboBoxPainter();
                break;
            }
            default: {
                cellPainter = new TextPainter();
            }
        }
        return cellPainter;
    }

    public String getDisplayMode(Table table, Object axisElement) {
        int editorKind = this.getFeatureIdentifier(table, axisElement);
        String displayMode = "EDIT";
        switch (editorKind) {
            case 1: {
                displayMode = "NORMAL";
                break;
            }
        }
        return displayMode;
    }

    public IDataValidator getDataValidator(Table table, Object axisElement) {
        return null;
    }

    public boolean handles(Table table, Object axisElement) {
        return axisElement instanceof EStructuralFeature;
    }

    protected int getFeatureIdentifier(Table table, Object axisElement) {
        int editorKind = -1;
        assert (axisElement instanceof EStructuralFeature);
        EStructuralFeature feature = (EStructuralFeature)axisElement;
        EClassifier eType = feature.getEType();
        boolean isMany = feature.isMany();
        if (eType instanceof EEnum) {
            editorKind = isMany ? 8 : 7;
        } else if (!(eType instanceof EDataType) && EMFHelper.isSuperType((EClassifier)EcorePackage.eINSTANCE.getEObject(), (EClassifier)eType)) {
            editorKind = isMany ? 10 : 9;
        }
        return editorKind;
    }
}

