/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

public class StringHelper {
    public static boolean equals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String camelCaseToLabel(String camelCaseName) {
        String formattedValue = camelCaseName;
        formattedValue = formattedValue.replaceAll("([a-z])([A-Z])", "$1 $2");
        formattedValue = formattedValue.replaceAll("([A-Z]+)([A-Z])([a-z])", "$1 $2$3");
        String[] words = formattedValue.split("\\s+");
        formattedValue = StringHelper.firstToUpper(words[0]);
        int i = 1;
        while (i < words.length) {
            formattedValue = String.valueOf(formattedValue) + " ";
            formattedValue = words[i].matches("^[A-Z]{2,}") ? String.valueOf(formattedValue) + words[i] : String.valueOf(formattedValue) + StringHelper.firstToLower(words[i]);
            ++i;
        }
        return formattedValue;
    }

    public static String firstToUpper(String source) {
        if (source.length() == 0) {
            return source;
        }
        return String.valueOf(source.substring(0, 1).toUpperCase()) + source.substring(1);
    }

    public static String firstToLower(String source) {
        if (source.length() == 0) {
            return source;
        }
        return String.valueOf(source.substring(0, 1).toLowerCase()) + source.substring(1);
    }

    public static String trimToEmpty(String str) {
        return str == null ? "" : str;
    }

    public static String toJavaIdentifier(String label) {
        return StringHelper.getValidJavaIdentifier(label, new StringBuffer()).toString();
    }

    protected static StringBuffer getValidJavaIdentifier(String name, StringBuffer validJavaIdentifier) {
        if (StringHelper.isEmpty(name)) {
            validJavaIdentifier.append('_');
        } else {
            char char_0 = name.charAt(0);
            if (Character.isJavaIdentifierStart(char_0)) {
                validJavaIdentifier.append(char_0);
            } else {
                validJavaIdentifier.append('_');
                if (Character.isJavaIdentifierPart(char_0)) {
                    validJavaIdentifier.append(char_0);
                }
            }
            int i = 1;
            while (i < name.length()) {
                char char_i = name.charAt(i);
                if (Character.isJavaIdentifierPart(char_i)) {
                    validJavaIdentifier.append(char_i);
                }
                ++i;
            }
        }
        return validJavaIdentifier;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

