/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Sleak {
    List list;
    Canvas canvas;
    Button enableTracking;
    Button snapshot;
    Button diff;
    Button stackTrace;
    Button saveAs;
    Button save;
    Text text;
    Label label;
    String filterPath = "";
    String fileName = "sleakout";
    String selectedName = null;
    boolean incrementFileNames = true;
    boolean saveImages = true;
    int fileCount = 0;
    Object[] oldObjects = new Object[0];
    Error[] oldErrors = new Error[0];
    Object[] objects = new Object[0];
    Error[] errors = new Error[0];

    public static void main(String[] args) {
        DeviceData data = new DeviceData();
        data.tracking = true;
        Display display = new Display(data);
        Sleak sleak = new Sleak();
        Shell shell = new Shell(display);
        shell.setText("S-Leak");
        Point size = shell.getSize();
        shell.setSize(size.x / 2, size.y / 2);
        sleak.create((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public void create(Composite parent) {
        this.list = new List(parent, 2560);
        this.list.addListener(13, event -> this.refreshObject());
        this.text = new Text(parent, 2816);
        this.canvas = new Canvas(parent, 2048);
        this.canvas.addListener(9, event -> this.paintCanvas(event));
        this.enableTracking = new Button(parent, 32);
        this.enableTracking.setText("Enable");
        this.enableTracking.setToolTipText("Enable Device resource tracking. Only resources allocated once enabled will be tracked. To track devices created before view is created, turn on tracing options, see https://www.eclipse.org/swt/tools.php");
        this.enableTracking.addListener(13, e -> this.toggleEnableTracking());
        this.enableTracking.setSelection(this.enableTracking.getDisplay().isTracking());
        this.stackTrace = new Button(parent, 32);
        this.stackTrace.setText("Stack");
        this.stackTrace.addListener(13, e -> this.toggleStackTrace());
        this.snapshot = new Button(parent, 8);
        this.snapshot.setText("Snap");
        this.snapshot.addListener(13, event -> this.refreshAll());
        this.diff = new Button(parent, 8);
        this.diff.setText("Diff");
        this.diff.addListener(13, event -> this.refreshDifference());
        this.label = new Label(parent, 2048);
        this.label.setText("0 object(s)");
        this.saveAs = new Button(parent, 8);
        this.saveAs.setText("Save As...");
        this.saveAs.setToolTipText("Saves the contents of the list to a file, optionally with the stack traces if selected.");
        this.saveAs.addListener(13, event -> this.saveToFile(true));
        this.save = new Button(parent, 8);
        this.save.setText("Save");
        this.save.setToolTipText("Saves to the previously selected file.");
        this.save.addListener(13, event -> this.saveToFile(false));
        parent.addListener(11, e -> this.layout());
        this.stackTrace.setSelection(false);
        this.text.setVisible(false);
        this.layout();
    }

    private void toggleEnableTracking() {
        Display display;
        boolean tracking = (display = this.enableTracking.getDisplay()).isTracking();
        display.setTracking(!tracking);
    }

    void refreshLabel() {
        int cursors = 0;
        int fonts = 0;
        int gcs = 0;
        int images = 0;
        int paths = 0;
        int patterns = 0;
        int regions = 0;
        int textLayouts = 0;
        int transforms = 0;
        Object[] objectArray = this.objects;
        int n = this.objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Cursor) {
                ++cursors;
            }
            if (object instanceof Font) {
                ++fonts;
            }
            if (object instanceof GC) {
                ++gcs;
            }
            if (object instanceof Image) {
                ++images;
            }
            if (object instanceof Path) {
                ++paths;
            }
            if (object instanceof Pattern) {
                ++patterns;
            }
            if (object instanceof Region) {
                ++regions;
            }
            if (object instanceof TextLayout) {
                ++textLayouts;
            }
            if (object instanceof Transform) {
                ++transforms;
            }
            ++n2;
        }
        String string = "";
        if (cursors != 0) {
            string = String.valueOf(string) + cursors + " Cursor(s)\n";
        }
        if (fonts != 0) {
            string = String.valueOf(string) + fonts + " Font(s)\n";
        }
        if (gcs != 0) {
            string = String.valueOf(string) + gcs + " GC(s)\n";
        }
        if (images != 0) {
            string = String.valueOf(string) + images + " Image(s)\n";
        }
        if (paths != 0) {
            string = String.valueOf(string) + paths + " Paths(s)\n";
        }
        if (patterns != 0) {
            string = String.valueOf(string) + patterns + " Pattern(s)\n";
        }
        if (regions != 0) {
            string = String.valueOf(string) + regions + " Region(s)\n";
        }
        if (textLayouts != 0) {
            string = String.valueOf(string) + textLayouts + " TextLayout(s)\n";
        }
        if (transforms != 0) {
            string = String.valueOf(string) + transforms + " Transform(s)\n";
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 1);
        }
        this.label.setText(string);
    }

    void refreshDifference() {
        Display display = this.canvas.getDisplay();
        DeviceData info = display.getDeviceData();
        if (!info.tracking) {
            Shell shell = this.canvas.getShell();
            MessageBox dialog = new MessageBox(shell, 200);
            dialog.setText(shell.getText());
            dialog.setMessage("Warning: Device is not tracking resource allocation\nWould you like to enable tracking now for future created resources?");
            if (64 == dialog.open()) {
                this.enableTracking.setSelection(true);
                this.toggleEnableTracking();
            }
        }
        int size = 0;
        int i = 0;
        while (i < info.objects.length) {
            if (!(info.objects[i] instanceof Color)) {
                ++size;
            }
            ++i;
        }
        Object[] newObjects = new Object[size];
        Error[] newErrors = new Error[size];
        int i2 = 0;
        int out_i = 0;
        while (i2 < info.objects.length) {
            if (!(info.objects[i2] instanceof Color)) {
                newObjects[out_i] = info.objects[i2];
                newErrors[out_i] = info.errors[i2];
                ++out_i;
            }
            ++i2;
        }
        Object[] diffObjects = new Object[newObjects.length];
        Error[] diffErrors = new Error[newErrors.length];
        int count = 0;
        int i3 = 0;
        while (i3 < newObjects.length) {
            int index = 0;
            while (index < this.oldObjects.length) {
                if (newObjects[i3] == this.oldObjects[index]) break;
                ++index;
            }
            if (index == this.oldObjects.length) {
                diffObjects[count] = newObjects[i3];
                diffErrors[count] = newErrors[i3];
                ++count;
            }
            ++i3;
        }
        this.objects = new Object[count];
        this.errors = new Error[count];
        System.arraycopy(diffObjects, 0, this.objects, 0, count);
        System.arraycopy(diffErrors, 0, this.errors, 0, count);
        this.list.removeAll();
        this.text.setText("");
        this.canvas.redraw();
        Object[] objectArray = this.objects;
        int n = this.objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.list.add(object.toString());
            ++n2;
        }
        this.refreshLabel();
        this.layout();
    }

    private void saveToFile(boolean prompt) {
        Throwable msg;
        if (prompt || this.selectedName == null) {
            FileDialog dialog = new FileDialog(this.saveAs.getShell(), 8192);
            dialog.setFilterPath(this.filterPath);
            dialog.setFileName(this.fileName);
            dialog.setOverwrite(true);
            this.selectedName = dialog.open();
            this.fileCount = 0;
            if (this.selectedName == null) {
                return;
            }
            this.filterPath = dialog.getFilterPath();
            this.fileName = dialog.getFileName();
            msg = new MessageBox(this.saveAs.getShell(), 196);
            msg.setText("Append incrementing file counter?");
            msg.setMessage("Append an incrementing file count to the file name on each save, starting at 000?");
            this.incrementFileNames = msg.open() == 64;
            msg = new MessageBox(this.saveAs.getShell(), 196);
            msg.setText("Save images for each resource?");
            msg.setMessage("Save an image (png) for each resource?");
            this.saveImages = msg.open() == 64;
        }
        String fileName = this.selectedName;
        if (this.incrementFileNames) {
            fileName = String.format("%s_%03d", fileName, this.fileCount++);
        }
        try {
            msg = null;
            Object var4_6 = null;
            try (PrintWriter file = new PrintWriter(new FileOutputStream(fileName));){
                int i = 0;
                while (i < this.errors.length) {
                    Object object = this.objects[i];
                    Error error = this.errors[i];
                    file.print(object.toString());
                    if (this.saveImages) {
                        String suffix = String.format("%05d.png", i);
                        String pngName = String.format("%s_%s", fileName, suffix);
                        Image image = new Image((Device)this.saveAs.getDisplay(), 100, 100);
                        try {
                            GC gc = new GC((Drawable)image);
                            try {
                                this.draw(gc, object);
                            }
                            finally {
                                gc.dispose();
                            }
                            ImageLoader loader = new ImageLoader();
                            loader.data = new ImageData[]{image.getImageData()};
                            loader.save(pngName, 5);
                        }
                        finally {
                            image.dispose();
                        }
                        file.print(" -> ");
                        file.print(suffix);
                    }
                    file.println();
                    if (this.stackTrace.getSelection()) {
                        error.printStackTrace(file);
                        System.out.println();
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                if (msg == null) {
                    msg = throwable;
                } else if (msg != throwable) {
                    msg.addSuppressed(throwable);
                }
                throw msg;
            }
        }
        catch (IOException e1) {
            MessageBox msg2 = new MessageBox(this.saveAs.getShell(), 33);
            msg2.setText("Failed to save");
            msg2.setMessage("Failed to save S-Leak file.\n" + e1.getMessage());
            msg2.open();
        }
    }

    void toggleStackTrace() {
        this.refreshObject();
        this.layout();
    }

    void paintCanvas(Event event) {
        this.canvas.setCursor(null);
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        GC gc = event.gc;
        Object object = this.objects[index];
        this.draw(gc, object);
    }

    void draw(GC gc, Object object) {
        if (object instanceof Cursor) {
            if (((Cursor)object).isDisposed()) {
                return;
            }
            this.canvas.setCursor((Cursor)object);
            return;
        }
        if (object instanceof Font) {
            if (((Font)object).isDisposed()) {
                return;
            }
            gc.setFont((Font)object);
            String string = "";
            String lf = this.text.getLineDelimiter();
            FontData[] fontDataArray = gc.getFont().getFontData();
            int n = fontDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                String style = "NORMAL";
                int bits = data.getStyle();
                if (bits != 0) {
                    if ((bits & 1) != 0) {
                        style = "BOLD ";
                    }
                    if ((bits & 2) != 0) {
                        style = String.valueOf(style) + "ITALIC";
                    }
                }
                string = String.valueOf(string) + data.getName() + " " + data.getHeight() + " " + style + lf;
                ++n2;
            }
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof Image) {
            if (((Image)object).isDisposed()) {
                return;
            }
            gc.drawImage((Image)object, 0, 0);
            return;
        }
        if (object instanceof Path) {
            if (((Path)object).isDisposed()) {
                return;
            }
            gc.drawPath((Path)object);
            return;
        }
        if (object instanceof Pattern) {
            if (((Pattern)object).isDisposed()) {
                return;
            }
            gc.setBackgroundPattern((Pattern)object);
            gc.fillRectangle(this.canvas.getClientArea());
            gc.setBackgroundPattern(null);
            return;
        }
        if (object instanceof Region) {
            if (((Region)object).isDisposed()) {
                return;
            }
            String string = ((Region)object).getBounds().toString();
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof TextLayout) {
            if (((TextLayout)object).isDisposed()) {
                return;
            }
            ((TextLayout)object).draw(gc, 0, 0);
            return;
        }
        if (object instanceof Transform) {
            if (((Transform)object).isDisposed()) {
                return;
            }
            String string = ((Transform)object).toString();
            gc.drawString(string, 0, 0);
            return;
        }
    }

    void refreshObject() {
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        if (this.stackTrace.getSelection()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            PrintStream s = new PrintStream(stream);
            this.errors[index].printStackTrace(s);
            this.text.setText(stream.toString());
            this.text.setVisible(true);
            this.canvas.setVisible(false);
        } else {
            this.canvas.setVisible(true);
            this.text.setVisible(false);
            this.canvas.redraw();
        }
    }

    void refreshAll() {
        this.oldObjects = new Object[0];
        this.oldErrors = new Error[0];
        this.refreshDifference();
        this.oldObjects = this.objects;
        this.oldErrors = this.errors;
    }

    void layout() {
        Composite parent = this.canvas.getParent();
        Rectangle rect = parent.getClientArea();
        int width = 0;
        String[] items = this.list.getItems();
        GC gc = new GC((Drawable)this.list);
        int i = 0;
        while (i < this.objects.length) {
            width = Math.max(width, gc.stringExtent((String)items[i]).x);
            ++i;
        }
        gc.dispose();
        Point enableTrackingSize = this.enableTracking.computeSize(-1, -1);
        Point snapshotSize = this.snapshot.computeSize(-1, -1);
        Point diffSize = this.diff.computeSize(-1, -1);
        Point stackSize = this.stackTrace.computeSize(-1, -1);
        Point labelSize = this.label.computeSize(-1, -1);
        Point saveAsSize = this.saveAs.computeSize(-1, -1);
        Point saveSize = this.save.computeSize(-1, -1);
        width = Math.max(enableTrackingSize.x, width);
        width = Math.max(snapshotSize.x, Math.max(diffSize.x, Math.max(stackSize.x, width)));
        width = Math.max(saveAsSize.x, Math.max(saveSize.x, width));
        width = Math.max(labelSize.x, this.list.computeSize((int)width, (int)-1).x);
        width = Math.max(64, width);
        this.enableTracking.setBounds(0, 0, width, enableTrackingSize.y);
        this.snapshot.setBounds(0, enableTrackingSize.y, width, snapshotSize.y);
        this.diff.setBounds(0, enableTrackingSize.y + snapshotSize.y, width, diffSize.y);
        this.stackTrace.setBounds(0, enableTrackingSize.y + snapshotSize.y + diffSize.y, width, stackSize.y);
        this.label.setBounds(0, rect.height - saveSize.y - saveAsSize.y - labelSize.y, width, labelSize.y);
        this.saveAs.setBounds(0, rect.height - saveSize.y - saveAsSize.y, width, saveAsSize.y);
        this.save.setBounds(0, rect.height - saveSize.y, width, saveSize.y);
        int height = enableTrackingSize.y + snapshotSize.y + diffSize.y + stackSize.y;
        this.list.setBounds(0, height, width, rect.height - height - labelSize.y - saveAsSize.y - saveSize.y);
        this.text.setBounds(width, 0, rect.width - width, rect.height);
        this.canvas.setBounds(width, 0, rect.width - width, rect.height);
    }
}

