/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.tags.LocalProjectTagSource;
import org.eclipse.team.internal.ccvs.ui.tags.TagContentAssistProcessor;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionArea;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;

public class BranchPromptDialog
extends DetailsDialog {
    private String branchTag = "";
    private String versionTag = "";
    private String versionName = "";
    private boolean allStickyResources;
    private boolean update;
    private Text versionText;
    private Text branchText;
    private static final int TAG_AREA_HEIGHT_HINT = 200;
    private TagSource tagSource;
    private TagSelectionArea tagArea;
    private final IResource[] resources;

    public BranchPromptDialog(Shell parentShell, String title, IResource[] resources, boolean allResourcesSticky, String versionName) {
        super(parentShell, title);
        this.resources = resources;
        this.tagSource = TagSource.create(resources);
        this.allStickyResources = allResourcesSticky;
        this.versionName = versionName;
    }

    protected void createMainDialogArea(Composite composite) {
        BranchPromptDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        int areaWidth = this.convertHorizontalDLUsToPixels(300);
        Label description = SWTUtils.createLabel((Composite)composite, (String)(this.allStickyResources ? CVSUIMessages.BranchWizardPage_pageDescriptionVersion : CVSUIMessages.BranchWizardPage_pageDescription));
        description.setLayoutData((Object)SWTUtils.createGridData((int)areaWidth, (int)-1, (boolean)true, (boolean)false));
        Label name = SWTUtils.createLabel((Composite)composite, (String)CVSUIMessages.BranchWizardPage_branchName);
        name.setLayoutData((Object)SWTUtils.createGridData((int)areaWidth, (int)-1, (boolean)true, (boolean)false));
        this.branchText = CVSWizardPage.createTextField(composite);
        this.branchText.addListener(24, event -> {
            this.branchTag = this.branchText.getText();
            this.updateEnablements();
            this.updateVersionName(this.branchTag);
        });
        this.addBranchContentAssist();
        Button check = SWTUtils.createCheckBox((Composite)composite, (String)CVSUIMessages.BranchWizardPage_startWorking);
        check.addListener(13, event -> {
            boolean bl = this.update = check.getSelection();
        });
        check.setSelection(true);
        this.update = true;
        Label versionLabel1 = SWTUtils.createLabel((Composite)composite, (String)CVSUIMessages.BranchWizardPage_specifyVersion);
        versionLabel1.setLayoutData((Object)SWTUtils.createGridData((int)areaWidth, (int)-1, (boolean)true, (boolean)false));
        Label versionLabel2 = SWTUtils.createLabel((Composite)composite, (String)CVSUIMessages.BranchWizardPage_versionName);
        versionLabel2.setLayoutData((Object)SWTUtils.createGridData((int)areaWidth, (int)-1, (boolean)true, (boolean)false));
        this.versionText = CVSWizardPage.createTextField(composite);
        this.versionText.addListener(24, event -> {
            this.versionTag = this.versionText.getText();
            this.updateEnablements();
        });
        if (this.allStickyResources) {
            this.versionText.setEditable(false);
            this.versionText.setText(this.versionName);
        }
        BranchPromptDialog.applyDialogFont((Control)composite);
        this.branchText.setFocus();
    }

    protected String getHelpContextId() {
        return "org.eclipse.team.cvs.ui.branch_dialog_context";
    }

    private void addBranchContentAssist() {
        TagSource projectTagSource = LocalProjectTagSource.create(this.getSeedProject());
        if (projectTagSource != null) {
            TagContentAssistProcessor.createContentAssistant(this.branchText, projectTagSource, 4);
        }
    }

    private IProject getSeedProject() {
        return this.resources[0].getProject();
    }

    protected void updateVersionName(String branchName) {
        if (this.versionText != null && !this.allStickyResources) {
            this.versionText.setText(String.valueOf(CVSUIMessages.BranchWizardPage_versionPrefix) + branchName);
        }
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        BranchPromptDialog.applyDialogFont((Control)parent);
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)1));
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        composite.setLayoutData((Object)gridData);
        this.tagArea = new TagSelectionArea(this.getShell(), this.tagSource, 12, null);
        this.tagArea.setTagAreaLabel(CVSUIMessages.BranchWizardPage_existingVersionsAndBranches);
        this.tagArea.setIncludeFilterInputArea(false);
        this.tagArea.createArea(composite);
        return composite;
    }

    protected void updateEnablements() {
        String message = null;
        if (this.branchTag.length() == 0) {
            message = "";
        } else {
            IStatus status = CVSTag.validateTagName((String)this.branchTag);
            if (!status.isOK()) {
                message = NLS.bind((String)CVSUIMessages.BranchWizard_branchNameWarning, (Object[])new String[]{status.getMessage()});
            } else if (this.versionText != null) {
                status = CVSTag.validateTagName((String)this.versionText.getText());
                if (!status.isOK()) {
                    message = NLS.bind((String)CVSUIMessages.BranchWizard_versionNameWarning, (Object[])new String[]{status.getMessage()});
                } else if (this.versionTag.length() != 0 && this.versionTag.equals(this.branchTag)) {
                    message = CVSUIMessages.BranchWizard_branchAndVersionMustBeDifferent;
                }
            }
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
    }

    public String getBranchTagName() {
        return this.branchTag;
    }

    public String getVersionTagName() {
        return this.versionTag;
    }

    public boolean getUpdate() {
        return this.update;
    }

    protected boolean isMainGrabVertical() {
        return false;
    }
}

