/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.trace;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapOldPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;

public class PcapOldFile
extends PcapFile {
    private long fTimeAccuracy;
    private long fTimeZoneCorrection;
    private long fSnapshotLength;
    private long fDataLinkType;
    PcapTimestampScale fTimestampPrecision;

    public PcapOldFile(Path filePath) throws BadPcapFileException, IOException {
        super(filePath);
        ByteOrder byteOrder;
        TreeMap<Long, Long> fileIndex = this.getFileIndex();
        ByteBuffer globalHeader = ByteBuffer.allocate(24);
        this.getFileChannel().read(globalHeader);
        globalHeader.flip();
        int magicNumber = globalHeader.getInt();
        switch (magicNumber) {
            case -1582119980: {
                byteOrder = ByteOrder.BIG_ENDIAN;
                this.fTimestampPrecision = PcapTimestampScale.MICROSECOND;
                break;
            }
            case -725372255: {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                this.fTimestampPrecision = PcapTimestampScale.MICROSECOND;
                break;
            }
            case -1582154675: {
                byteOrder = ByteOrder.BIG_ENDIAN;
                this.fTimestampPrecision = PcapTimestampScale.NANOSECOND;
                break;
            }
            case 1295823521: {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                this.fTimestampPrecision = PcapTimestampScale.NANOSECOND;
                break;
            }
            default: {
                this.close();
                throw new BadPcapFileException(String.valueOf(String.format("%08x", magicNumber)) + " is not a known magic number.");
            }
        }
        globalHeader.order(byteOrder);
        int fMajorVersion = ConversionHelper.unsignedShortToInt(globalHeader.getShort());
        int fMinorVersion = ConversionHelper.unsignedShortToInt(globalHeader.getShort());
        this.fTimeAccuracy = ConversionHelper.unsignedIntToLong(globalHeader.getInt());
        this.fTimeZoneCorrection = ConversionHelper.unsignedIntToLong(globalHeader.getInt());
        this.fSnapshotLength = ConversionHelper.unsignedIntToLong(globalHeader.getInt());
        this.fDataLinkType = ConversionHelper.unsignedIntToLong(globalHeader.getInt());
        fileIndex.put(this.getCurrentRank(), this.getFileChannel().position());
        this.init(byteOrder, fMajorVersion, fMinorVersion);
    }

    @Override
    public synchronized @Nullable PcapOldPacket parseNextPacket() throws IOException, BadPcapFileException, BadPacketException {
        if (this.getFileChannel().size() - this.getFileChannel().position() == 0L) {
            return null;
        }
        if (this.getFileChannel().size() - this.getFileChannel().position() < 16L) {
            throw new BadPcapFileException("A pcap header is invalid.");
        }
        ByteBuffer pcapPacketHeader = ByteBuffer.allocate(16);
        pcapPacketHeader.clear();
        pcapPacketHeader.order(this.getByteOrder());
        this.getFileChannel().read(pcapPacketHeader);
        pcapPacketHeader.flip();
        pcapPacketHeader.position(8);
        long includedPacketLength = ConversionHelper.unsignedIntToLong(pcapPacketHeader.getInt());
        if (this.getFileChannel().size() - this.getFileChannel().position() < includedPacketLength) {
            throw new BadPcapFileException("A packet header is invalid.");
        }
        if (includedPacketLength > Integer.MAX_VALUE) {
            throw new BadPacketException("Packets that are bigger than 2^31-1 bytes are not supported.");
        }
        ByteBuffer pcapPacketData = ByteBuffer.allocate((int)includedPacketLength);
        pcapPacketData.clear();
        pcapPacketData.order(this.getByteOrder());
        this.getFileChannel().read(pcapPacketData);
        pcapPacketData.flip();
        TreeMap<Long, Long> fFileIndex = this.getFileIndex();
        this.setCurrentRank(this.getCurrentRank() + 1L);
        fFileIndex.put(this.getCurrentRank(), this.getFileChannel().position());
        return new PcapOldPacket(this, pcapPacketHeader, pcapPacketData, this.getCurrentRank() - 1L);
    }

    @Override
    public synchronized boolean skipNextPacket() throws IOException, BadPcapFileException {
        if (this.getFileChannel().size() - this.getFileChannel().position() == 0L) {
            return false;
        }
        if (this.getFileChannel().size() - this.getFileChannel().position() < 24L) {
            throw new BadPcapFileException("A pcap header is invalid.");
        }
        ByteBuffer pcapPacketHeader = ByteBuffer.allocate(16);
        pcapPacketHeader.clear();
        pcapPacketHeader.order(this.getByteOrder());
        this.getFileChannel().read(pcapPacketHeader);
        pcapPacketHeader.flip();
        pcapPacketHeader.position(8);
        long includedPacketLength = ConversionHelper.unsignedIntToLong(pcapPacketHeader.getInt());
        if (this.getFileChannel().size() - this.getFileChannel().position() < includedPacketLength) {
            throw new BadPcapFileException("A packet header is invalid.");
        }
        this.getFileChannel().position(this.getFileChannel().position() + includedPacketLength);
        TreeMap<Long, Long> fFileIndex = this.getFileIndex();
        this.setCurrentRank(this.getCurrentRank() + 1L);
        fFileIndex.put(this.getCurrentRank(), this.getFileChannel().position());
        return true;
    }

    @Override
    public PcapTimestampScale getTimestampPrecision() {
        return this.fTimestampPrecision;
    }

    public long getTimeAccuracy() {
        return this.fTimeAccuracy;
    }

    public long getTimeZoneCorrection() {
        return this.fTimeZoneCorrection;
    }

    public long getSnapShotLength() {
        return this.fSnapshotLength;
    }

    public long getDataLinkType() {
        return this.fDataLinkType;
    }
}

